/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.unparser;

import com.akiban.sql.TestBase;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.SQLParserFeature;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.unparser.NodeToString;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NodeToStringTest
extends TestBase
implements TestBase.GenerateAndCheckResult {
    public static final File RESOURCE_DIR = new File("src/test/resources/" + NodeToStringTest.class.getPackage().getName().replace('.', '/'));
    protected SQLParser parser;
    protected NodeToString unparser;

    @Before
    public void before() throws Exception {
        this.parser = new SQLParser();
        this.unparser = new NodeToString();
        this.parser.getFeatures().addAll(EnumSet.of(SQLParserFeature.INFIX_BIT_OPERATORS));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> statements() throws Exception {
        return NodeToStringTest.sqlAndExpected(RESOURCE_DIR);
    }

    public NodeToStringTest(String caseName, String sql, String expected, String error) {
        super(caseName, sql, expected, error);
    }

    @Test
    public void testUnparser() throws Exception {
        this.generateAndCheckResult();
    }

    @Override
    public String generateResult() throws Exception {
        StatementNode stmt = this.parser.parseStatement(this.sql);
        return this.unparser.toString((QueryTreeNode)stmt);
    }

    @Override
    public void checkResult(String result) {
        Assert.assertEquals((String)this.caseName, (String)this.expected, (String)result);
    }
}

