/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.parser.CharStream;
import com.akiban.sql.parser.StringCharStream;
import com.akiban.sql.parser.UCode_CharStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.BitSet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StringCharStreamTest {
    private CharStream s1;
    private CharStream s2;
    private static final String STRING = "abc xyz\n1\t2\t3\r\nxxx   yyy\rz";
    private static final char EOF = '\u0000';

    @Before
    public void openStreams() {
        this.s1 = new UCode_CharStream((Reader)new StringReader(STRING), 1, 1);
        this.s2 = new StringCharStream(STRING);
    }

    @After
    public void closeStreams() {
        this.s1.Done();
        this.s2.Done();
    }

    @Test
    public void testRead() {
        char c;
        while ((c = this.read()) != '\u0000') {
        }
    }

    @Test
    public void testBeginTokenAll() {
        char c;
        while ((c = this.beginToken()) != '\u0000') {
        }
    }

    @Test
    public void testBeginTokenSome() {
        int c = 32;
        while ((c = " \t\r\n".indexOf(c) < 0 ? (int)this.read() : (int)this.beginToken()) != 0) {
        }
    }

    @Test
    public void testBackup() {
        BitSet ns = new BitSet(STRING.length());
        ns.set(0);
        while (true) {
            char c;
            if ((c = this.read()) != '\u0000') {
                continue;
            }
            int i = ns.nextClearBit(0);
            if (i >= STRING.length()) break;
            ns.set(i);
            this.backup(i);
        }
    }

    protected char beginToken() {
        char c2;
        char c1;
        try {
            c1 = this.s1.BeginToken();
        }
        catch (IOException ex) {
            c1 = '\u0000';
        }
        try {
            c2 = this.s2.BeginToken();
        }
        catch (IOException ex) {
            c2 = '\u0000';
        }
        Assert.assertEquals((String)"BeginToken", (char)c1, (char)c2);
        this.compare(c1 == '\u0000', c1 == '\u0000' || c1 == '\t');
        return c1;
    }

    protected char read() {
        char c2;
        char c1;
        try {
            c1 = this.s1.readChar();
        }
        catch (IOException ex) {
            c1 = '\u0000';
        }
        try {
            c2 = this.s2.readChar();
        }
        catch (IOException ex) {
            c2 = '\u0000';
        }
        Assert.assertEquals((String)"readChar", (char)c1, (char)c2);
        this.compare();
        return c1;
    }

    protected void backup(int amount) {
        this.s1.backup(amount);
        this.s2.backup(amount);
        this.compare();
    }

    protected void compare() {
        this.compare(false, false);
    }

    protected void compare(boolean expectBeginOffsetEOF, boolean expectBeginColumnDifference) {
        int offset = this.s2.getEndOffset();
        if (expectBeginOffsetEOF) {
            Assert.assertEquals((String)("getBeginOffset[" + offset + "]"), (int)this.s1.getBeginOffset(), (int)(this.s2.getBeginOffset() - 1));
        } else {
            Assert.assertEquals((String)("getBeginOffset[" + offset + "]"), (int)this.s1.getBeginOffset(), (int)this.s2.getBeginOffset());
        }
        Assert.assertEquals((String)("getEndOffset[" + offset + "]"), (int)this.s1.getEndOffset(), (int)this.s2.getEndOffset());
        Assert.assertEquals((String)("getColumn[" + offset + "]"), (int)this.s1.getColumn(), (int)this.s2.getColumn());
        Assert.assertEquals((String)("getLine[" + offset + "]"), (int)this.s1.getLine(), (int)this.s2.getLine());
        if (!expectBeginColumnDifference) {
            Assert.assertEquals((String)("getBeginColumn[" + offset + "]"), (int)this.s1.getBeginColumn(), (int)this.s2.getBeginColumn());
        }
        Assert.assertEquals((String)("getBeginLine[" + offset + "]"), (int)this.s1.getBeginLine(), (int)this.s2.getBeginLine());
        Assert.assertEquals((String)("getEndColumn[" + offset + "]"), (int)this.s1.getEndColumn(), (int)this.s2.getEndColumn());
        Assert.assertEquals((String)("getEndLine[" + offset + "]"), (int)this.s1.getEndLine(), (int)this.s2.getEndLine());
        if (expectBeginOffsetEOF) {
            Assert.assertEquals((String)("GetImage[" + offset + "]"), (String)"", (String)this.s2.GetImage());
        } else {
            Assert.assertEquals((String)("GetImage[" + offset + "]"), (String)this.s1.GetImage(), (String)this.s2.GetImage());
        }
        int size = offset - this.s2.getBeginOffset() + 1;
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((String)("GetSuffix[" + offset + "](" + i + ")"), (String)new String(this.s1.GetSuffix(i)), (String)new String(this.s2.GetSuffix(i)));
        }
    }
}

