/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.StatementNode;
import org.junit.Test;

public class RowCtorTest {
    @Test
    public void regularCase() throws StandardException {
        RowCtorTest.doTest("SELECT 3 IN (4,5,6)");
    }

    @Test
    public void testWithBoolOp1() throws StandardException {
        RowCtorTest.doTest("select ((1 and 2) and 3) IN (2, 4, 5)");
    }

    @Test
    public void testWithTables() throws StandardException {
        RowCtorTest.doTest(" select (c1, c2) in ((1, 3), (c3, c4)) from t");
    }

    @Test
    public void matchingColumn() throws StandardException {
        RowCtorTest.doTest("SELECT (2, 3, 4) IN ((5, 6, 7), (8, (9, 10, 11)))");
    }

    @Test
    public void mistmatchColumnTest() throws StandardException {
        RowCtorTest.doTest("SELECT (2, 3, 4) IN (4, 5, 6)");
    }

    @Test
    public void nestedRows() throws StandardException {
        RowCtorTest.doTest("SELECT ((2, 3), (4, 5)) in ((4, 5), (5, 7))");
    }

    @Test
    public void nonNestedRowsWithParens() throws StandardException {
        RowCtorTest.doTest("SELECT 1  in ((4, ((5))))");
    }

    static void doTest(String st) throws StandardException {
        SQLParser parser = new SQLParser();
        StatementNode node = parser.parseStatement(st);
    }
}

