/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompareWithoutHashes {
    public static final String HASH_REGEX = "[\\p{Alnum}]*\\@[\\p{XDigit}]+";
    private Pattern pattern;
    private Map<String, String> equivalences;

    public CompareWithoutHashes() {
        this(HASH_REGEX);
    }

    public CompareWithoutHashes(String regex) {
        this.pattern = Pattern.compile(regex);
        this.equivalences = new HashMap<String, String>();
    }

    public boolean match(Reader r1, Reader r2) throws IOException {
        block3: {
            String l2;
            String l1;
            BufferedReader br1 = new BufferedReader(r1);
            BufferedReader br2 = new BufferedReader(r2);
            do {
                l1 = br1.readLine();
                l2 = br2.readLine();
                if (l1 == null) {
                    if (l2 != null) {
                        l1 = "";
                        continue;
                    }
                    break block3;
                }
                if (l2 != null) continue;
                l2 = "";
            } while (this.match(l1, l2));
            return false;
        }
        return true;
    }

    public boolean match(String s1, String s2) {
        int i;
        String[][] ha2;
        String[][] ha1 = this.findHashes(s1);
        if (ha1.length != (ha2 = this.findHashes(s2)).length) {
            return false;
        }
        for (i = 0; i < ha1.length; ++i) {
            if (!ha1[i][0].equals(ha2[i][0])) {
                return false;
            }
            String oh2 = this.equivalences.put(ha1[i][1], ha2[i][1]);
            if (oh2 == null || oh2.equals(ha2[i][1])) continue;
            return false;
        }
        for (i = 0; i < ha1.length; ++i) {
            s1 = s1.replace(ha1[i][1], "%!" + i + "!%");
        }
        for (i = 0; i < ha1.length; ++i) {
            s1 = s1.replace("%!" + i + "!%", ha2[i][1]);
        }
        return s1.equals(s2);
    }

    protected String[][] findHashes(String s) {
        Matcher matcher = this.pattern.matcher(s);
        ArrayList<String[]> matches = new ArrayList<String[]>();
        while (matcher.find()) {
            String hash = matcher.group();
            String[] match = new String[]{hash.substring(0, hash.indexOf(64)), hash};
            matches.add(match);
        }
        return (String[][])matches.toArray((T[])new String[matches.size()][2]);
    }

    public String converter(String s1, String s2) {
        String[][] ha1 = this.findHashes(s1);
        String[][] ha2 = this.findHashes(s2);
        int i1 = 0;
        block0: for (int i2 = 0; i1 < ha1.length && i2 < ha2.length; ++i2, ++i1) {
            if (ha1[i1][0].equals(ha2[i2][0])) {
                s1 = s1.replace(ha1[i1][1], "%!" + i2 + "!%");
                continue;
            }
            for (int ia1 = i1; ia1 < Math.min(i1 + 2, ha1.length); ++ia1) {
                for (int ia2 = i2; ia2 < Math.min(i2 + 2, ha2.length); ++ia2) {
                    if (!ha1[ia1][0].equals(ha2[ia2][0])) continue;
                    s1 = s1.replace(ha1[ia1][1], "%!" + ia2 + "!%");
                    i1 = ia1;
                    i2 = ia2;
                    continue block0;
                }
            }
        }
        for (int i = 0; i < ha2.length; ++i) {
            s1 = s1.replace("%!" + i + "!%", ha2[i][1]);
        }
        return s1;
    }
}

