/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.localizationactivity.core;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.util.DisplayMetrics;
import com.akexorcist.localizationactivity.core.LanguageSetting;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/akexorcist/localizationactivity/core/LocalizationUtility;", "", "()V", "getLocaleFromConfiguration", "Ljava/util/Locale;", "configuration", "Landroid/content/res/Configuration;", "getLocalizedConfiguration", "Lkotlin/Pair;", "", "baseContext", "Landroid/content/Context;", "baseConfiguration", "getLocalizedContext", "getLocalizedResources", "Landroid/content/res/Resources;", "baseResources", "isRequestedLocaleChanged", "baseLocale", "currentLocale", "localization_release"})
public final class LocalizationUtility {
    @NotNull
    public static final LocalizationUtility INSTANCE = new LocalizationUtility();

    private LocalizationUtility() {
    }

    @NotNull
    public final Context getLocalizedContext(@NotNull Context baseContext) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Configuration configuration = baseContext.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"baseContext.resources.configuration");
        Pair<Configuration, Boolean> pair = this.getLocalizedConfiguration(baseContext, configuration);
        Configuration configuration2 = (Configuration)pair.component1();
        boolean isChanged = (Boolean)pair.component2();
        if (isChanged && Build.VERSION.SDK_INT >= 17) {
            Context context2 = baseContext.createConfigurationContext(configuration2);
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"baseContext.createConfig\u2026ionContext(configuration)");
            context = context2;
        } else if (isChanged) {
            baseContext.getResources().updateConfiguration(configuration2, baseContext.getResources().getDisplayMetrics());
            context = baseContext;
        } else {
            context = baseContext;
        }
        return context;
    }

    @NotNull
    public final Resources getLocalizedResources(@NotNull Context baseContext, @NotNull Resources baseResources) {
        Resources resources;
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)baseResources, (String)"baseResources");
        Configuration configuration = baseResources.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"baseResources.configuration");
        Pair<Configuration, Boolean> pair = this.getLocalizedConfiguration(baseContext, configuration);
        Configuration configuration2 = (Configuration)pair.component1();
        boolean isChanged = (Boolean)pair.component2();
        if (isChanged && Build.VERSION.SDK_INT >= 17) {
            Resources resources2 = baseContext.createConfigurationContext(configuration2).getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"baseContext.createConfig\u2026(configuration).resources");
            resources = resources2;
        } else {
            if (isChanged) {
                DisplayMetrics displayMetrics = baseContext.getResources().getDisplayMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"baseContext.resources.displayMetrics");
                DisplayMetrics metrics = displayMetrics;
                return new Resources(baseContext.getAssets(), metrics, configuration2);
            }
            resources = baseResources;
        }
        return resources;
    }

    @NotNull
    public final Pair<Configuration, Boolean> getLocalizedConfiguration(@NotNull Context baseContext, @NotNull Configuration baseConfiguration) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)baseConfiguration, (String)"baseConfiguration");
        Locale defaultLocale = LanguageSetting.getDefaultLanguage(baseContext);
        Locale currentLocale = LanguageSetting.INSTANCE.getLanguageWithDefault(baseContext, defaultLocale);
        Locale baseLocale = this.getLocaleFromConfiguration(baseConfiguration);
        if (!this.isRequestedLocaleChanged(baseLocale, currentLocale)) {
            return TuplesKt.to((Object)baseConfiguration, (Object)false);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Locale[] localeArray = new Locale[]{currentLocale};
            LocaleList localeList = new LocaleList(localeArray);
            LocaleList.setDefault((LocaleList)localeList);
            Locale[] $this$getLocalizedConfiguration_u24lambda_u2d0 = localeArray = new Configuration(baseConfiguration);
            boolean bl = false;
            $this$getLocalizedConfiguration_u24lambda_u2d0.setLocale(currentLocale);
            $this$getLocalizedConfiguration_u24lambda_u2d0.setLocales(localeList);
            pair = TuplesKt.to((Object)localeArray, (Object)true);
        } else if (Build.VERSION.SDK_INT >= 17) {
            Configuration configuration;
            Configuration $this$getLocalizedConfiguration_u24lambda_u2d1 = configuration = new Configuration(baseConfiguration);
            boolean bl = false;
            $this$getLocalizedConfiguration_u24lambda_u2d1.setLocale(currentLocale);
            pair = TuplesKt.to((Object)configuration, (Object)true);
        } else {
            Configuration configuration;
            Configuration $this$getLocalizedConfiguration_u24lambda_u2d2 = configuration = new Configuration(baseConfiguration);
            boolean bl = false;
            $this$getLocalizedConfiguration_u24lambda_u2d2.locale = currentLocale;
            if (Build.VERSION.SDK_INT >= 17) {
                $this$getLocalizedConfiguration_u24lambda_u2d2.setLayoutDirection(currentLocale);
            }
            pair = TuplesKt.to((Object)configuration, (Object)true);
        }
        return pair;
    }

    private final Locale getLocaleFromConfiguration(Configuration configuration) {
        Locale locale;
        if (Build.VERSION.SDK_INT >= 26) {
            Locale locale2 = configuration.getLocales().get(0);
            if (locale2 == null) {
                locale2 = Locale.getDefault();
            }
            Locale locale3 = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n            configurat\u2026le.getDefault()\n        }");
            locale = locale3;
        } else {
            Locale locale4 = configuration.locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"{\n            configuration.locale\n        }");
            locale = locale4;
        }
        return locale;
    }

    private final boolean isRequestedLocaleChanged(Locale baseLocale, Locale currentLocale) {
        return !StringsKt.equals((String)baseLocale.toString(), (String)currentLocale.toString(), (boolean)true);
    }
}

