/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.netstorage;

import com.akamai.auth.ClientCredential;
import com.akamai.auth.RequestSigner;
import com.akamai.auth.RequestSigningException;
import com.akamai.netstorage.APIEventBean;
import com.akamai.netstorage.NetStorageException;
import com.akamai.netstorage.SignerInputStream;
import com.akamai.netstorage.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class NetStorageCMSv35Signer
implements RequestSigner {
    private static final String KITVERSION = "Java/3.6";
    private static final String KITVERSION_HEADER = "X-Akamai-NSKit";
    private static final String ACTION_HEADER = "X-Akamai-ACS-Action";
    private static final String AUTH_DATA_HEADER = "X-Akamai-ACS-Auth-Data";
    private static final String AUTH_SIGN_HEADER = "X-Akamai-ACS-Auth-Sign";
    private String method;
    private URL url;
    private APIEventBean params;
    private InputStream uploadStream = null;
    private long uploadSize;
    private SignType signVersion = null;

    public NetStorageCMSv35Signer(String method, URL url, APIEventBean params) {
        this(method, url, params, null, -1L);
    }

    public NetStorageCMSv35Signer(String method, URL url, APIEventBean params, InputStream uploadStream, long uploadSize) {
        this.setMethod(method);
        this.setUrl(url);
        this.setParams(params);
        this.setUploadStream(uploadStream);
        this.setUploadSize(uploadSize);
        this.setSignVersion(SignType.HMACSHA256);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public APIEventBean getParams() {
        return this.params;
    }

    public void setParams(APIEventBean params) {
        this.params = params;
    }

    public InputStream getUploadStream() {
        return this.uploadStream;
    }

    public void setUploadStream(InputStream uploadStream) {
        this.uploadStream = uploadStream;
    }

    public long getUploadSize() {
        return this.uploadSize;
    }

    public void setUploadSize(long uploadSize) {
        this.uploadSize = uploadSize;
    }

    public SignType getSignVersion() {
        return this.signVersion;
    }

    public void setSignVersion(SignType signVersion) {
        this.signVersion = signVersion;
    }

    protected String getActionHeaderValue() {
        return Utils.convertMapAsQueryParams(this.getParams().asQueryParams());
    }

    protected String getAuthDataHeaderValue(ClientCredential credential) {
        Date currentTime = new Date();
        int rand = new Random().nextInt(Integer.MAX_VALUE);
        return String.format("%d, 0.0.0.0, 0.0.0.0, %d, %d, %s", this.getSignVersion().getValue(), currentTime.getTime() / 1000L, rand, credential.getUsername());
    }

    protected String getAuthSignHeaderValue(String action, String authData, ClientCredential credential) {
        String signData = String.format("%s%s\n%s:%s\n", authData, this.getUrl().getPath(), ACTION_HEADER.toLowerCase(), action);
        byte[] hash = Utils.computeKeyedHash(signData.getBytes(StandardCharsets.UTF_8), credential.getKey(), this.getSignVersion().getAlgorithm());
        return Utils.encodeBase64(hash);
    }

    public Map<String, String> computeHeaders(ClientCredential credential) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        String action = this.getActionHeaderValue();
        String authData = this.getAuthDataHeaderValue(credential);
        String authSign = this.getAuthSignHeaderValue(action, authData, credential);
        headers.put(KITVERSION_HEADER, KITVERSION);
        headers.put(ACTION_HEADER, action);
        headers.put(AUTH_DATA_HEADER, authData);
        headers.put(AUTH_SIGN_HEADER, authSign);
        return headers;
    }

    public boolean validate(HttpURLConnection connection) throws NetStorageException, IOException {
        if (connection.getResponseCode() == 200) {
            return true;
        }
        Date currentDate = new Date();
        long responseDate = connection.getHeaderFieldDate("Date", 0L);
        if (responseDate != 0L && currentDate.getTime() - responseDate > 30000L) {
            throw new NetStorageException("Local server Date is more than 30s out of sync with Remote server");
        }
        throw new NetStorageException(String.format("Unexpected Response from Server: %d %s\n%s", connection.getResponseCode(), connection.getResponseMessage(), connection.getHeaderFields()), connection.getResponseCode());
    }

    @Override
    public HttpURLConnection sign(HttpURLConnection request, ClientCredential credential) throws RequestSigningException {
        try {
            if (request == null) {
                request = (HttpURLConnection)this.getUrl().openConnection();
            }
            request.setRequestMethod(this.getMethod());
            for (Map.Entry<String, String> entry : this.computeHeaders(credential).entrySet()) {
                request.setRequestProperty(entry.getKey(), entry.getValue());
            }
            return request;
        }
        catch (IOException ex) {
            throw new RequestSigningException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream execute(HttpURLConnection request, ClientCredential credential) throws RequestSigningException {
        try {
            block42: {
                block44: {
                    request = this.sign(request, credential);
                    request.setConnectTimeout(10000);
                    request.setReadTimeout(10000);
                    if (!this.getMethod().equals("PUT") && !this.getMethod().equals("POST")) break block44;
                    request.setDoOutput(true);
                    if (this.getUploadStream() == null) {
                        request.setFixedLengthStreamingMode(0);
                        request.connect();
                        break block42;
                    } else {
                        byte[] buffer = new byte[0x100000];
                        if (this.getUploadSize() > 0L) {
                            request.setFixedLengthStreamingMode(this.getUploadSize());
                        } else {
                            request.setChunkedStreamingMode(buffer.length);
                        }
                        request.connect();
                        try (BufferedInputStream input = new BufferedInputStream(this.getUploadStream());
                             OutputStream output = request.getOutputStream();){
                            int length;
                            while ((length = input.read(buffer)) > 0) {
                                output.write(buffer, 0, length);
                            }
                            output.flush();
                            break block42;
                        }
                    }
                }
                request.connect();
            }
            this.validate(request);
            return new SignerInputStream(request.getInputStream(), request);
        }
        catch (NetStorageException | IOException e) {
            Throwable throwable;
            InputStream is2;
            block43: {
                if (request == null) throw new NetStorageException("Communication Error", e);
                try {
                    is2 = request.getInputStream();
                    throwable = null;
                    if (is2 == null) break block43;
                    if (throwable != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        is2.close();
                    }
                }
                catch (IOException is2) {
                    // empty catch block
                }
            }
            try {
                is2 = request.getErrorStream();
                throwable = null;
                if (is2 == null) throw new NetStorageException("Communication Error", e);
                if (throwable == null) {
                    is2.close();
                    throw new NetStorageException("Communication Error", e);
                }
                try {
                    is2.close();
                    throw new NetStorageException("Communication Error", e);
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                    throw new NetStorageException("Communication Error", e);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new NetStorageException("Communication Error", e);
        }
    }

    @Override
    public InputStream execute(ClientCredential credential) throws RequestSigningException {
        return this.execute(null, credential);
    }

    public static enum SignType {
        HMACMD5(Utils.KeyedHashAlgorithm.HMACMD5, 3),
        HMACSHA1(Utils.KeyedHashAlgorithm.HMACSHA1, 4),
        HMACSHA256(Utils.KeyedHashAlgorithm.HMACSHA256, 5);

        private final int value;
        private final Utils.KeyedHashAlgorithm algorithm;

        private SignType(Utils.KeyedHashAlgorithm algorithm, int value) {
            this.value = value;
            this.algorithm = algorithm;
        }

        public int getValue() {
            return this.value;
        }

        public Utils.KeyedHashAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static enum NetStorageType {
        FileStore,
        ObjectStore,
        Unknown;

    }
}

