/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.netstorage;

import com.akamai.auth.RequestSigningException;
import com.akamai.netstorage.APIEventBean;
import com.akamai.netstorage.DefaultCredential;
import com.akamai.netstorage.NetStorageCMSv35Signer;
import com.akamai.netstorage.NetStorageException;
import com.akamai.netstorage.SignerInputStream;
import com.akamai.netstorage.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;

public class NetStorage {
    private DefaultCredential credential;

    public NetStorage(DefaultCredential credential) {
        this.credential = credential;
    }

    protected URL getNetstorageUri(String path) {
        try {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return new URL("HTTPS", this.credential.getHostname(), path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("This should never Happened! Protocols are locked to HTTPS and HTTP!", e);
        }
    }

    protected InputStream execute(String method, String path, APIEventBean acsParams, InputStream uploadStream, Long size) throws NetStorageException {
        try {
            return new NetStorageCMSv35Signer(method, this.getNetstorageUri(path), acsParams, uploadStream, size != null && size > 0L ? size : -1L).execute(this.credential);
        }
        catch (RequestSigningException ex) {
            throw new NetStorageException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetStorageCMSv35Signer.NetStorageType getNetStorageType() throws NetStorageException {
        try (InputStream stream = this.stat("/");){
            if (!(stream instanceof SignerInputStream)) return NetStorageCMSv35Signer.NetStorageType.Unknown;
            HttpURLConnection request = ((SignerInputStream)stream).getHttpRequest();
            switch (request.getHeaderField("Server")) {
                case "AkamaiNetStorage": {
                    NetStorageCMSv35Signer.NetStorageType netStorageType = NetStorageCMSv35Signer.NetStorageType.ObjectStore;
                    return netStorageType;
                }
                case "Apache": {
                    NetStorageCMSv35Signer.NetStorageType netStorageType = NetStorageCMSv35Signer.NetStorageType.FileStore;
                    return netStorageType;
                }
            }
            return NetStorageCMSv35Signer.NetStorageType.Unknown;
        }
        catch (IOException ex) {
            throw new NetStorageException(ex);
        }
    }

    protected InputStream execute(String method, String path, APIEventBean acsParams) throws NetStorageException {
        return this.execute(method, path, acsParams, null, null);
    }

    public boolean delete(String path) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("delete");
        try (InputStream inputStream = this.execute("POST", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public InputStream dir(String path) throws NetStorageException {
        return this.dir(path, "xml");
    }

    public InputStream dir(String path, String format) throws NetStorageException {
        return this.dir(path, format, null);
    }

    public InputStream dir(String path, String format, Map<String, String> additionalParams) throws NetStorageException {
        APIEventBean action = new APIEventBean();
        action.setAction("dir");
        if (null != additionalParams) {
            action.setAdditionalParams(additionalParams);
        }
        action.setFormat(format);
        return this.execute("GET", path, action);
    }

    public InputStream download(String path) throws NetStorageException {
        APIEventBean action = new APIEventBean();
        action.setAction("download");
        return this.execute("GET", path, action);
    }

    public InputStream du(String path) throws NetStorageException {
        return this.du(path, "xml");
    }

    public InputStream du(String path, String format) throws NetStorageException {
        APIEventBean action = new APIEventBean();
        action.setAction("du");
        action.setFormat(format);
        return this.execute("GET", path, action);
    }

    public boolean mkdir(String path) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("mkdir");
        try (InputStream inputStream = this.execute("PUT", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean mtime(String path) throws NetStorageException, IOException {
        return this.mtime(path, null);
    }

    public boolean mtime(String path, Date mtime) throws NetStorageException, IOException {
        if (mtime == null) {
            mtime = new Date();
        }
        APIEventBean action = new APIEventBean();
        action.setAction("mtime");
        action.setMtime(mtime);
        try (InputStream inputStream = this.execute("PUT", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean rename(String originalPath, String newPath) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("rename");
        action.setDestination(newPath);
        try (InputStream inputStream = this.execute("PUT", originalPath, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean rmdir(String path) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("rmdir");
        try (InputStream inputStream = this.execute("POST", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public InputStream stat(String path) throws NetStorageException {
        return this.stat(path, "xml");
    }

    public InputStream stat(String path, String format) throws NetStorageException {
        APIEventBean action = new APIEventBean();
        action.setAction("stat");
        action.setFormat(format);
        return this.execute("GET", path, action);
    }

    public boolean symlink(String path, String target) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("symlink");
        action.setTarget(target);
        try (InputStream inputStream = this.execute("PUT", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean quickDelete(String path) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("quick-delete");
        action.setQuickDelete();
        try (InputStream inputStream = this.execute("PUT", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean upload(String path, InputStream uploadFileStream) throws NetStorageException, IOException {
        return this.upload(path, uploadFileStream, null, new Date(), null, null, null, null, false);
    }

    public boolean upload(String path, InputStream uploadFileStream, Date mtime, Long size, byte[] md5Checksum, byte[] sha1Checksum, byte[] sha256Checksum, boolean indexZip) throws NetStorageException, IOException {
        return this.upload(path, uploadFileStream, null, mtime, size, md5Checksum, sha1Checksum, sha256Checksum, indexZip);
    }

    public boolean upload(String path, InputStream uploadFileStream, Map<String, String> additionalParams, Date mtime, Long size, byte[] md5Checksum, byte[] sha1Checksum, byte[] sha256Checksum, boolean indexZip) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("upload");
        action.setAdditionalParams(additionalParams);
        action.setMtime(mtime);
        action.setSize(size);
        action.setMd5(md5Checksum);
        action.setSha1(sha1Checksum);
        action.setSha256(sha256Checksum);
        action.setIndexZip(indexZip ? Boolean.valueOf(indexZip) : null);
        if (action.getIndexZip() != null && action.getIndexZip().booleanValue() && !path.endsWith(".zip")) {
            action.setIndexZip(null);
        }
        if (action.getSize() != null && action.getIndexZip() != null && action.getIndexZip().booleanValue()) {
            action.setSize(null);
        }
        try (InputStream inputStream = this.execute("PUT", path, action, uploadFileStream, size);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }

    public boolean upload(String path, File srcFile) throws NetStorageException, IOException {
        return this.upload(path, srcFile, null, false);
    }

    public boolean upload(String path, File srcFile, Map<String, String> additionalParams) throws NetStorageException, IOException {
        return this.upload(path, srcFile, additionalParams, false);
    }

    public boolean upload(String path, File srcFile, boolean indexZip) throws NetStorageException, IOException {
        return this.upload(path, srcFile, null, indexZip);
    }

    public boolean upload(String path, File srcFile, Map<String, String> additionalParams, boolean indexZip) throws NetStorageException, IOException {
        byte[] checksum;
        if (!srcFile.exists()) {
            throw new FileNotFoundException(String.format("Src file is not accessible %s", srcFile.toString()));
        }
        Date mTime = new Date(srcFile.lastModified());
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(srcFile));){
            checksum = Utils.computeHash(inputStream, Utils.HashAlgorithm.SHA256);
        }
        inputStream = new BufferedInputStream(new FileInputStream(srcFile));
        var8_7 = null;
        try {
            long size = srcFile.length();
            boolean bl = this.upload(path, inputStream, additionalParams, mTime, size, null, null, checksum, indexZip);
            return bl;
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var8_7 != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
        }
    }

    public boolean setmd(String path, Map<String, String> additionalParams) throws NetStorageException, IOException {
        APIEventBean action = new APIEventBean();
        action.setAction("setmd");
        action.setAdditionalParams(additionalParams);
        try (InputStream inputStream = this.execute("PUT", path, action);){
            Utils.readToEnd(inputStream);
        }
        return true;
    }
}

