/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.openapi.api;

import com.aizuda.snailjob.model.request.JobApiRequest;
import com.aizuda.snailjob.model.request.JobTriggerApiRequest;
import com.aizuda.snailjob.model.request.StatusUpdateApiRequest;
import com.aizuda.snailjob.model.request.base.JobRequest;
import com.aizuda.snailjob.model.request.base.JobTriggerRequest;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.model.response.JobApiResponse;
import com.aizuda.snailjob.server.openapi.service.JobApiService;
import com.aizuda.snailjob.server.service.service.JobService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobApi {
    private final JobApiService jobApiService;
    @Qualifier(value="jobApiCommonService")
    private final JobService jobService;

    @PostMapping(value={"/api/job/add"})
    public Long addJob(@RequestBody @Validated JobApiRequest jobRequest) {
        return this.jobService.addJob((JobRequest)jobRequest);
    }

    @PutMapping(value={"/api/job/update"})
    public boolean updateJob(@RequestBody @Validated JobApiRequest jobRequest) {
        return this.jobService.updateJob((JobRequest)jobRequest);
    }

    @DeleteMapping(value={"/api/job/delete"})
    public boolean deleteJobByIds(@RequestBody @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") Set<Long> ids) {
        return this.jobService.deleteJobByIds(ids);
    }

    @PostMapping(value={"/api/job/trigger"})
    public Boolean trigger(@RequestBody @Validated JobTriggerApiRequest jobTrigger) {
        return this.jobService.trigger((JobTriggerRequest)jobTrigger);
    }

    @PutMapping(value={"/api/job/update/status"})
    public Boolean updateJobStatus(@RequestBody @Validated StatusUpdateApiRequest requestDTO) {
        return this.jobService.updateJobStatus((StatusUpdateRequest)requestDTO);
    }

    @GetMapping(value={"/api/job/detail/id"})
    public JobApiResponse getJobById(@RequestParam(value="id") Long id) {
        return (JobApiResponse)this.jobService.getJobById(id, JobApiResponse.class);
    }

    @Generated
    public JobApi(JobApiService jobApiService, @Qualifier(value="jobApiCommonService") JobService jobService) {
        this.jobApiService = jobApiService;
        this.jobService = jobService;
    }
}

