/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Handler;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.AsyncEpoxyDiffer;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.BoundViewHolders;
import com.airbnb.epoxy.ControllerModelList;
import com.airbnb.epoxy.DiffPayload;
import com.airbnb.epoxy.DiffResult;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.NotifyBlocker;
import com.airbnb.epoxy.OnModelBuildFinishedListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EpoxyControllerAdapter
extends BaseEpoxyAdapter
implements AsyncEpoxyDiffer.ResultCallback {
    private final NotifyBlocker notifyBlocker = new NotifyBlocker();
    private final AsyncEpoxyDiffer differ;
    private final EpoxyController epoxyController;
    private int itemCount;
    private final List<OnModelBuildFinishedListener> modelBuildListeners = new ArrayList<OnModelBuildFinishedListener>();
    private static final DiffUtil.ItemCallback<EpoxyModel<?>> ITEM_CALLBACK = new DiffUtil.ItemCallback<EpoxyModel<?>>(){

        public boolean areItemsTheSame(EpoxyModel<?> oldItem, EpoxyModel<?> newItem) {
            return oldItem.id() == newItem.id();
        }

        public boolean areContentsTheSame(EpoxyModel<?> oldItem, EpoxyModel<?> newItem) {
            return oldItem.equals(newItem);
        }

        public Object getChangePayload(EpoxyModel<?> oldItem, EpoxyModel<?> newItem) {
            return new DiffPayload(oldItem);
        }
    };

    EpoxyControllerAdapter(@NonNull EpoxyController epoxyController, Handler diffingHandler) {
        this.epoxyController = epoxyController;
        this.differ = new AsyncEpoxyDiffer(diffingHandler, this, ITEM_CALLBACK);
        this.registerAdapterDataObserver(this.notifyBlocker);
    }

    @Override
    protected void onExceptionSwallowed(@NonNull RuntimeException exception) {
        this.epoxyController.onExceptionSwallowed(exception);
    }

    @Override
    @NonNull
    List<? extends EpoxyModel<?>> getCurrentModels() {
        return this.differ.getCurrentList();
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    void setModels(@NonNull ControllerModelList models) {
        List<EpoxyModel<?>> currentModels = this.getCurrentModels();
        if (!currentModels.isEmpty() && currentModels.get(0).isDebugValidationEnabled()) {
            for (int i = 0; i < currentModels.size(); ++i) {
                EpoxyModel<?> model = currentModels.get(i);
                model.validateStateHasNotChangedSinceAdded("The model was changed between being bound and when models were rebuilt", i);
            }
        }
        this.differ.submitList(models);
    }

    public boolean isDiffInProgress() {
        return this.differ.isDiffInProgress();
    }

    @Override
    public void onResult(@NonNull DiffResult result) {
        this.itemCount = result.newModels.size();
        this.notifyBlocker.allowChanges();
        result.dispatchTo(this);
        this.notifyBlocker.blockChanges();
        for (int i = this.modelBuildListeners.size() - 1; i >= 0; --i) {
            this.modelBuildListeners.get(i).onModelBuildFinished(result);
        }
    }

    public void addModelBuildListener(OnModelBuildFinishedListener listener) {
        this.modelBuildListeners.add(listener);
    }

    public void removeModelBuildListener(OnModelBuildFinishedListener listener) {
        this.modelBuildListeners.remove(listener);
    }

    @Override
    boolean diffPayloadsEnabled() {
        return true;
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.epoxyController.onAttachedToRecyclerViewInternal(recyclerView);
    }

    @Override
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.epoxyController.onDetachedFromRecyclerViewInternal(recyclerView);
    }

    @Override
    public void onViewAttachedToWindow(@NonNull EpoxyViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        this.epoxyController.onViewAttachedToWindow(holder, holder.getModel());
    }

    @Override
    public void onViewDetachedFromWindow(@NonNull EpoxyViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        this.epoxyController.onViewDetachedFromWindow(holder, holder.getModel());
    }

    @Override
    protected void onModelBound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model, int position, @Nullable EpoxyModel<?> previouslyBoundModel) {
        this.epoxyController.onModelBound(holder, model, position, previouslyBoundModel);
    }

    @Override
    protected void onModelUnbound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> model) {
        this.epoxyController.onModelUnbound(holder, model);
    }

    @NonNull
    public List<EpoxyModel<?>> getCopyOfModels() {
        return this.getCurrentModels();
    }

    @NonNull
    public EpoxyModel<?> getModelAtPosition(int position) {
        return this.getCurrentModels().get(position);
    }

    @Nullable
    public EpoxyModel<?> getModelById(long id2) {
        for (EpoxyModel<?> model : this.getCurrentModels()) {
            if (model.id() != id2) continue;
            return model;
        }
        return null;
    }

    @Override
    public int getModelPosition(@NonNull EpoxyModel<?> targetModel) {
        int size = this.getCurrentModels().size();
        for (int i = 0; i < size; ++i) {
            EpoxyModel<?> model = this.getCurrentModels().get(i);
            if (model.id() != targetModel.id()) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NonNull
    public BoundViewHolders getBoundViewHolders() {
        return super.getBoundViewHolders();
    }

    @UiThread
    void moveModel(int fromPosition, int toPosition) {
        ArrayList updatedList = new ArrayList(this.getCurrentModels());
        updatedList.add(toPosition, updatedList.remove(fromPosition));
        this.notifyBlocker.allowChanges();
        this.notifyItemMoved(fromPosition, toPosition);
        this.notifyBlocker.blockChanges();
        boolean interruptedDiff = this.differ.forceListOverride(updatedList);
        if (interruptedDiff) {
            this.epoxyController.requestModelBuild();
        }
    }

    @UiThread
    void notifyModelChanged(int position) {
        ArrayList updatedList = new ArrayList(this.getCurrentModels());
        this.notifyBlocker.allowChanges();
        this.notifyItemChanged(position);
        this.notifyBlocker.blockChanges();
        boolean interruptedDiff = this.differ.forceListOverride(updatedList);
        if (interruptedDiff) {
            this.epoxyController.requestModelBuild();
        }
    }

    @Override
    public boolean isStickyHeader(int position) {
        return this.epoxyController.isStickyHeader(position);
    }

    @Override
    public void setupStickyHeaderView(@NotNull View stickyHeader) {
        this.epoxyController.setupStickyHeaderView(stickyHeader);
    }

    @Override
    public void teardownStickyHeaderView(@NotNull View stickyHeader) {
        this.epoxyController.teardownStickyHeaderView(stickyHeader);
    }
}

