/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMessager;
import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.LoggerKt;
import com.airbnb.epoxy.processor.Timing;
import com.airbnb.epoxy.processor.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000e2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0007J\u0018\u0010\u001e\u001a\u00020\u00132\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u00060!j\u0002`\"0 J?\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\u00172\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H$0*\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0017J\u000e\u0010/\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u00100\u001a\u00020\u0013J\f\u00101\u001a\u00020\u0017*\u00020\u000eH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/airbnb/epoxy/processor/Logger;", "", "messager", "Landroidx/room/compiler/processing/XMessager;", "logTimings", "", "(Landroidx/room/compiler/processing/XMessager;Z)V", "currentTimingBlocks", "Ljava/util/Stack;", "", "Lcom/airbnb/epoxy/processor/Timing;", "getLogTimings", "()Z", "loggedExceptions", "", "getMessager", "()Landroidx/room/compiler/processing/XMessager;", "timings", "logError", "", "element", "Landroidx/room/compiler/processing/XElement;", "msg", "", "args", "", "(Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "e", "message", "logErrors", "exceptions", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "measure", "T", "name", "numItems", "", "isParallel", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "note", "printTimings", "processorName", "warn", "writeExceptions", "stackTraceString", "epoxy-processor"})
public final class Logger {
    @NotNull
    private final XMessager messager;
    private final boolean logTimings;
    @NotNull
    private final List<Timing> timings;
    @NotNull
    private final Stack<List<Timing>> currentTimingBlocks;
    @NotNull
    private final List<Throwable> loggedExceptions;

    public Logger(@NotNull XMessager messager, boolean logTimings) {
        Intrinsics.checkNotNullParameter((Object)messager, (String)"messager");
        this.messager = messager;
        this.logTimings = logTimings;
        this.timings = new ArrayList();
        this.currentTimingBlocks = new Stack();
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
        this.loggedExceptions = list;
    }

    @NotNull
    public final XMessager getMessager() {
        return this.messager;
    }

    public final boolean getLogTimings() {
        return this.logTimings;
    }

    public final void writeExceptions() {
        Iterable $this$forEach$iv = this.loggedExceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable it = (Throwable)element$iv;
            boolean bl = false;
            EpoxyProcessorException epoxyProcessorException = it instanceof EpoxyProcessorException ? (EpoxyProcessorException)it : null;
            XElement element = epoxyProcessorException != null ? epoxyProcessorException.getElement() : null;
            String msg = it.getClass().getSimpleName() + ": " + it.getLocalizedMessage() + '\n' + this.stackTraceString(it);
            if (element != null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, msg, element);
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, msg);
        }
    }

    private final String stackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    public final void logErrors(@NotNull List<? extends Exception> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Iterable $this$forEach$iv = exceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Exception it = (Exception)element$iv;
            boolean bl = false;
            Logger.logError$default(this, it, null, 2, null);
        }
    }

    public final void logError(@NotNull String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Logger.logError$default(this, Utils.buildEpoxyException(msg, Arrays.copyOf(args, args.length)), null, 2, null);
    }

    public final void logError(@NotNull XElement element, @NotNull String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Logger.logError$default(this, Utils.INSTANCE.buildEpoxyException(element, msg, Arrays.copyOf(args, args.length)), null, 2, null);
    }

    public final void logError(@NotNull String msg, @NotNull XElement element) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Logger.logError$default(this, new EpoxyProcessorException(msg, null, element, 2, null), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logError(@NotNull Throwable e, @Nullable String message) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<Throwable> list = this.loggedExceptions;
        String string = message;
        if (string != null) {
            void it;
            String string2 = string;
            List<Throwable> list2 = list;
            boolean bl = false;
            list = list2;
            throwable = new EpoxyProcessorException((String)it, e, null, 4, null);
        } else {
            throwable = e;
        }
        list.add(throwable);
    }

    public static /* synthetic */ void logError$default(Logger logger2, Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        logger2.logError(throwable, string);
    }

    public final void note(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messager.printMessage(Diagnostic.Kind.NOTE, message + "\n ");
    }

    public final <T> T measure(@NotNull String name, @Nullable Integer numItems, @Nullable Boolean isParallel, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.logTimings) {
            return (T)block.invoke();
        }
        this.currentTimingBlocks.add(new ArrayList());
        long start = System.nanoTime();
        Object result = block.invoke();
        long elapsed = (System.nanoTime() - start) / (long)1000000;
        List<Timing> list = this.currentTimingBlocks.pop();
        Intrinsics.checkNotNullExpressionValue(list, (String)"currentTimingBlocks.pop()");
        Timing timing = new Timing(name, elapsed, list, numItems, isParallel);
        List<Timing> list2 = (List<Timing>)CollectionsKt.lastOrNull((List)this.currentTimingBlocks);
        if (list2 == null) {
            list2 = this.timings;
        }
        list2.add(timing);
        return (T)result;
    }

    public static /* synthetic */ Object measure$default(Logger logger2, String string, Integer n, Boolean bl, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = null;
        }
        return logger2.measure(string, n, bl, function0);
    }

    /*
     * WARNING - void declaration
     */
    public final void printTimings(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        if (!this.logTimings) {
            return;
        }
        String timingString = LoggerKt.access$joinToString(this.timings, 1);
        Iterable iterable = this.timings;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Timing timing = (Timing)t;
            int n2 = n;
            boolean bl = false;
            int n3 = (int)it.getDurationMs();
            n = n2 + n3;
        }
        int totalDuration = n;
        this.warn(processorName + " completed in " + totalDuration + " ms:\n" + timingString + "\n ");
    }

    @JvmOverloads
    public final void logError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Logger.logError$default(this, e, null, 2, null);
    }
}

