/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.JavaPoetExtKt;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XFiler;
import androidx.room.compiler.processing.XFilerKt;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XRoundEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.AutoModel;
import com.airbnb.epoxy.processor.BaseProcessorWithPackageConfigs;
import com.airbnb.epoxy.processor.ClassNames;
import com.airbnb.epoxy.processor.ControllerClassInfo;
import com.airbnb.epoxy.processor.ControllerModelField;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.Timer;
import com.airbnb.epoxy.processor.TypeNameWorkaroundKt;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001c\u0010%\u001a\u00020$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0018\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J6\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0014J$\u00104\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u00065"}, d2={"Lcom/airbnb/epoxy/processor/ControllerProcessor;", "Lcom/airbnb/epoxy/processor/BaseProcessorWithPackageConfigs;", "kspEnvironment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "classNameToInfo", "", "Lcom/squareup/javapoet/ClassName;", "Lcom/airbnb/epoxy/processor/ControllerClassInfo;", "usesModelViewConfig", "", "getUsesModelViewConfig", "()Z", "usesPackageEpoxyConfig", "getUsesPackageEpoxyConfig", "additionalSupportedAnnotations", "", "Lkotlin/reflect/KClass;", "buildConstructor", "Lcom/squareup/javapoet/MethodSpec;", "controllerInfo", "buildFieldInfo", "Lcom/airbnb/epoxy/processor/ControllerModelField;", "classElement", "modelFieldElement", "Landroidx/room/compiler/processing/XFieldElement;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "buildFieldsToSaveModelsForValidation", "", "Lcom/squareup/javapoet/FieldSpec;", "buildResetModelsMethod", "buildSaveModelsForNextValidationMethod", "buildValidateModelsHaveNotChangedMethod", "buildValidateSameValueMethod", "generateHelperClassForController", "", "generateJava", "controllerClassMap", "getOrCreateTargetClass", "controllerClassElement", "Landroidx/room/compiler/processing/XTypeElement;", "processRound", "Landroidx/room/compiler/processing/XElement;", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "round", "Landroidx/room/compiler/processing/XRoundEnv;", "timer", "Lcom/airbnb/epoxy/processor/Timer;", "roundNumber", "", "updateClassesForInheritance", "epoxy-processor"})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public final class ControllerProcessor
extends BaseProcessorWithPackageConfigs {
    private final boolean usesPackageEpoxyConfig;
    private final boolean usesModelViewConfig;
    @NotNull
    private final Map<ClassName, ControllerClassInfo> classNameToInfo;

    @JvmOverloads
    public ControllerProcessor(@Nullable SymbolProcessorEnvironment kspEnvironment) {
        super(kspEnvironment);
        this.usesPackageEpoxyConfig = true;
        this.classNameToInfo = new LinkedHashMap();
    }

    public /* synthetic */ ControllerProcessor(SymbolProcessorEnvironment symbolProcessorEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            symbolProcessorEnvironment = null;
        }
        this(symbolProcessorEnvironment);
    }

    @Override
    public boolean getUsesPackageEpoxyConfig() {
        return this.usesPackageEpoxyConfig;
    }

    @Override
    public boolean getUsesModelViewConfig() {
        return this.usesModelViewConfig;
    }

    @Override
    @NotNull
    public List<KClass<?>> additionalSupportedAnnotations() {
        return CollectionsKt.listOf((Object)Reflection.getOrCreateKotlinClass(AutoModel.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<XElement> processRound(@NotNull XProcessingEnv environment, @NotNull XRoundEnv round, @NotNull Memoizer memoizer, @NotNull Timer timer, int roundNumber) {
        void $this$partition$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)round, (String)"round");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        super.processRound(environment, round, memoizer, timer, roundNumber);
        Iterable iterable = round.getElementsAnnotatedWith(Reflection.getOrCreateKotlinClass(AutoModel.class));
        boolean $i$f$filterIsInstance = false;
        void var9_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XFieldElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            XFieldElement it = (XFieldElement)element$iv;
            boolean bl = false;
            if (!this.isKsp() || it.validate()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List validFields = (List)pair.component1();
        List invalidFields = (List)pair.component2();
        timer.markStepCompleted("get automodel fields");
        Iterable $this$forEach$iv = validFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XTypeElement classElement;
            XFieldElement field = (XFieldElement)element$iv;
            boolean bl = false;
            if (XProcessingUtilsKt.getEnclosingTypeElement((XElement)field) == null) {
                throw new IllegalStateException(("Field " + field + " should be used inside a class").toString());
            }
            ControllerClassInfo targetClassInfo = this.getOrCreateTargetClass(classElement, memoizer);
            try {
                targetClassInfo.addModel(this.buildFieldInfo(targetClassInfo, field, memoizer));
            }
            catch (Exception e) {
                Logger.logError$default(this.getLogger(), e, null, 2, null);
            }
        }
        timer.markStepCompleted("parse field info");
        if (invalidFields.isEmpty()) {
            try {
                this.updateClassesForInheritance(environment, this.classNameToInfo);
            }
            catch (Exception e) {
                Logger.logError$default(this.getLogger(), e, null, 2, null);
            }
            timer.markStepCompleted("lookup inheritance details");
            this.generateJava(this.classNameToInfo);
            this.classNameToInfo.clear();
            timer.markStepCompleted("write automodel helpers");
        }
        return invalidFields;
    }

    private final void updateClassesForInheritance(XProcessingEnv environment, Map<ClassName, ControllerClassInfo> controllerClassMap) {
        for (Map.Entry<ClassName, ControllerClassInfo> entry : controllerClassMap.entrySet()) {
            ClassName thisClassName = entry.getKey();
            ControllerClassInfo thisClassInfo = entry.getValue();
            XType thisClassType = environment.requireType((TypeName)thisClassName);
            Map otherClasses = new LinkedHashMap<ClassName, ControllerClassInfo>(controllerClassMap);
            otherClasses.remove(thisClassName);
            for (Map.Entry entry2 : otherClasses.entrySet()) {
                ClassName otherClassName = (ClassName)entry2.getKey();
                ControllerClassInfo otherClassInfo = (ControllerClassInfo)entry2.getValue();
                XType otherClassType = environment.requireType((TypeName)otherClassName);
                if (!XProcessingUtilsKt.isSubTypeOf(thisClassType, otherClassType)) continue;
                Set<ControllerModelField> otherControllerModelFields = otherClassInfo.getModelsImmutable();
                if (Intrinsics.areEqual((Object)thisClassInfo.getClassPackage(), (Object)thisClassInfo.getClassPackage())) {
                    thisClassInfo.addModels((Collection<ControllerModelField>)otherControllerModelFields);
                    continue;
                }
                for (ControllerModelField controllerModelField : otherControllerModelFields) {
                    if (controllerModelField.getPackagePrivate()) continue;
                    thisClassInfo.addModel(controllerModelField);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ControllerClassInfo getOrCreateTargetClass(XTypeElement controllerClassElement, Memoizer memoizer) {
        Object object;
        void $this$getOrPut$iv;
        Map<ClassName, ControllerClassInfo> map = this.classNameToInfo;
        ClassName key$iv = controllerClassElement.getClassName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            if (!XProcessingUtilsKt.isEpoxyController(controllerClassElement, memoizer)) {
                Logger logger2 = this.getLogger();
                XElement xElement = (XElement)controllerClassElement;
                Object[] objectArray = new Object[3];
                Intrinsics.checkNotNullExpressionValue((Object)AutoModel.class.getSimpleName(), (String)"AutoModel::class.java.simpleName");
                objectArray[1] = "com.airbnb.epoxy.EpoxyController";
                objectArray[2] = controllerClassElement.getName();
                logger2.logError(xElement, "Class with %s annotations must extend %s (%s)", objectArray);
            }
            ControllerClassInfo answer$iv = new ControllerClassInfo(controllerClassElement, this.getResourceProcessor(), memoizer);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ControllerClassInfo)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ControllerModelField buildFieldInfo(ControllerClassInfo classElement, XFieldElement modelFieldElement, Memoizer memoizer) {
        TypeName typeName2;
        Utils.validateFieldAccessibleViaGeneratedCode$default(Utils.INSTANCE, (XElement)modelFieldElement, AutoModel.class, this.getLogger(), false, 8, null);
        String fieldName = modelFieldElement.getName();
        XType fieldType = modelFieldElement.getType();
        if (!fieldType.isError()) {
            if (!XProcessingUtilsKt.isEpoxyModel(fieldType, memoizer)) {
                Logger logger2 = this.getLogger();
                XElement xElement = (XElement)modelFieldElement;
                Object[] objectArray = new Object[4];
                Intrinsics.checkNotNullExpressionValue((Object)AutoModel.class.getSimpleName(), (String)"AutoModel::class.java.simpleName");
                objectArray[1] = "com.airbnb.epoxy.EpoxyModel<?>";
                objectArray[2] = XProcessingUtilsKt.getExpectName((XElement)modelFieldElement.getEnclosingElement());
                objectArray[3] = modelFieldElement.getName();
                logger2.logError(xElement, "Fields with %s annotations must be of type %s (%s#%s)", objectArray);
            }
            typeName2 = TypeNameWorkaroundKt.typeNameWithWorkaround(fieldType, memoizer);
        } else {
            Object v3;
            Object object;
            String simpleName2;
            block4: {
                void $this$firstOrNull$iv;
                simpleName2 = fieldType.toString();
                object = classElement.getImports();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it, (String)simpleName2, (boolean)false, (int)2, null)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            String string = v3;
            String packageName = string != null && (object = StringsKt.substringBeforeLast$default((String)string, (String)('.' + simpleName2), null, (int)2, null)) != null ? object : classElement.getClassPackage();
            typeName2 = (TypeName)ClassName.get((String)packageName, (String)simpleName2, (String[])new String[0]);
        }
        TypeName modelTypeName = typeName2;
        Intrinsics.checkNotNullExpressionValue((Object)modelTypeName, (String)"modelTypeName");
        return new ControllerModelField(fieldName, modelTypeName, Utils.isFieldPackagePrivate((XElement)modelFieldElement));
    }

    private final void generateJava(Map<ClassName, ControllerClassInfo> controllerClassMap) {
        Iterator<Map.Entry<ClassName, ControllerClassInfo>> iterator = controllerClassMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ControllerClassInfo classInfo = iterator.next().getValue();
            try {
                this.generateHelperClassForController(classInfo);
            }
            catch (Exception e) {
                Logger.logError$default(this.getLogger(), e, null, 2, null);
            }
        }
    }

    private final void generateHelperClassForController(ControllerClassInfo controllerInfo) {
        TypeSpec.Builder builder;
        TypeName[] typeNameArray = new TypeName[]{controllerInfo.getControllerClassType()};
        ParameterizedTypeName parameterizeSuperClass = ParameterizedTypeName.get((ClassName)ClassNames.EPOXY_CONTROLLER_HELPER, (TypeName[])typeNameArray);
        TypeSpec.Builder $this$generateHelperClassForController_u24lambda_u245 = builder = TypeSpec.classBuilder((ClassName)controllerInfo.getGeneratedClassName());
        boolean bl = false;
        $this$generateHelperClassForController_u24lambda_u245.addJavadoc("Generated file. Do not modify!", new Object[0]);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        $this$generateHelperClassForController_u24lambda_u245.addModifiers(modifierArray);
        $this$generateHelperClassForController_u24lambda_u245.superclass((TypeName)parameterizeSuperClass);
        modifierArray = new Modifier[]{Modifier.FINAL, Modifier.PRIVATE};
        $this$generateHelperClassForController_u24lambda_u245.addField(controllerInfo.getControllerClassType(), "controller", modifierArray);
        $this$generateHelperClassForController_u24lambda_u245.addMethod(this.buildConstructor(controllerInfo));
        $this$generateHelperClassForController_u24lambda_u245.addMethod(this.buildResetModelsMethod(controllerInfo));
        if (this.getConfigManager().shouldValidateModelUsage()) {
            $this$generateHelperClassForController_u24lambda_u245.addFields(this.buildFieldsToSaveModelsForValidation(controllerInfo));
            $this$generateHelperClassForController_u24lambda_u245.addMethod(this.buildValidateModelsHaveNotChangedMethod(controllerInfo));
            $this$generateHelperClassForController_u24lambda_u245.addMethod(this.buildValidateSameValueMethod());
            $this$generateHelperClassForController_u24lambda_u245.addMethod(this.buildSaveModelsForNextValidationMethod(controllerInfo));
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$generateHelperClassForController_u24lambda_u245, (String)"generateHelperClassForController$lambda$5");
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)$this$generateHelperClassForController_u24lambda_u245, (XElement)controllerInfo.getOriginatingElement());
        Iterable $this$forEach$iv = this.originatingConfigElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XElement configElement = (XElement)element$iv;
            boolean bl2 = false;
            JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)$this$generateHelperClassForController_u24lambda_u245, (XElement)configElement);
        }
        TypeSpec classSpec = builder.build();
        JavaFile javaFile = JavaFile.builder((String)controllerInfo.getGeneratedClassName().packageName(), (TypeSpec)classSpec).build();
        Intrinsics.checkNotNullExpressionValue((Object)javaFile, (String)"builder(controllerInfo.g\u2026pec)\n            .build()");
        XFilerKt.writeTo((JavaFile)javaFile, (XFiler)this.getFiler(), (XFiler.Mode)XFiler.Mode.Aggregating);
    }

    private final MethodSpec buildConstructor(ControllerClassInfo controllerInfo) {
        ParameterSpec controllerParam = ParameterSpec.builder((TypeName)controllerInfo.getControllerClassType(), (String)"controller", (Modifier[])new Modifier[0]).build();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec methodSpec = MethodSpec.constructorBuilder().addParameter(controllerParam).addModifiers(modifierArray).addStatement("this.controller = controller", new Object[0]).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"constructorBuilder()\n   \u2026er\")\n            .build()");
        return methodSpec;
    }

    private final Iterable<FieldSpec> buildFieldsToSaveModelsForValidation(ControllerClassInfo controllerInfo) {
        List fields = new ArrayList();
        for (ControllerModelField model : controllerInfo.getModels()) {
            Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)((TypeName)ClassNames.EPOXY_MODEL_UNTYPED), (String)model.getFieldName(), (Modifier[])modifierArray).build();
            Intrinsics.checkNotNullExpressionValue((Object)fieldSpec, (String)"builder(\n               \u2026                ).build()");
            fields.add(fieldSpec);
        }
        return fields;
    }

    private final MethodSpec buildValidateModelsHaveNotChangedMethod(ControllerClassInfo controllerInfo) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"validateModelsHaveNotChanged").addModifiers(modifierArray);
        long id = -1L;
        for (ControllerModelField model : controllerInfo.getModels()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = model.getFieldName();
            objectArray[1] = model.getFieldName();
            objectArray[2] = model.getFieldName();
            long l = id;
            id = l + -1L;
            objectArray[3] = l;
            builder.addStatement("validateSameModel($L, controller.$L, $S, $L)", objectArray);
        }
        MethodSpec methodSpec = builder.addStatement("validateModelHashCodesHaveNotChanged(controller)", new Object[0]).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder\n            .add\u2026r)\")\n            .build()");
        return methodSpec;
    }

    private final MethodSpec buildValidateSameValueMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PRIVATE};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"validateSameModel").addModifiers(objectArray).addParameter((TypeName)ClassNames.EPOXY_MODEL_UNTYPED, "expectedObject", new Modifier[0]).addParameter((TypeName)ClassNames.EPOXY_MODEL_UNTYPED, "actualObject", new Modifier[0]).addParameter((Type)((Object)String.class), "fieldName", new Modifier[0]).addParameter(TypeName.INT, "id", new Modifier[0]).beginControlFlow("if (expectedObject != actualObject)", new Object[0]);
        objectArray = new Object[]{IllegalStateException.class, AutoModel.class.getSimpleName()};
        MethodSpec.Builder builder2 = builder.addStatement("throw new $T(\"Fields annotated with $L cannot be directly assigned. The controller manages these fields for you. (\" + controller.getClass().getSimpleName() + \"#\" + fieldName + \")\")", objectArray).endControlFlow().beginControlFlow("if (actualObject != null && actualObject.id() != id)", new Object[0]);
        objectArray = new Object[]{IllegalStateException.class, AutoModel.class.getSimpleName()};
        MethodSpec methodSpec = builder2.addStatement("throw new $T(\"Fields annotated with $L cannot have their id changed manually. The controller manages the ids of these models for you. (\" + controller.getClass().getSimpleName() + \"#\" + fieldName + \")\")", objectArray).endControlFlow().build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"validateS\u2026ow()\n            .build()");
        return methodSpec;
    }

    private final MethodSpec buildSaveModelsForNextValidationMethod(ControllerClassInfo controllerInfo) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"saveModelsForNextValidation").addModifiers(modifierArray);
        for (ControllerModelField model : controllerInfo.getModels()) {
            Object[] objectArray = new Object[]{model.getFieldName(), model.getFieldName()};
            builder.addStatement("$L = controller.$L", objectArray);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder.build()");
        return methodSpec;
    }

    private final MethodSpec buildResetModelsMethod(ControllerClassInfo controllerInfo) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resetAutoModels").addAnnotation(Override.class).addModifiers(modifierArray);
        if (this.getConfigManager().shouldValidateModelUsage()) {
            builder.addStatement("validateModelsHaveNotChanged()", new Object[0]);
        }
        boolean implicitlyAddAutoModels = this.getConfigManager().implicitlyAddAutoModels(controllerInfo);
        long id = -1L;
        for (ControllerModelField model : controllerInfo.getModels()) {
            Object[] objectArray = new Object[]{model.getFieldName(), model.getTypeName()};
            MethodSpec.Builder builder2 = builder.addStatement("controller.$L = new $T()", objectArray);
            objectArray = new Object[2];
            objectArray[0] = model.getFieldName();
            long l = id;
            id = l + -1L;
            objectArray[1] = l;
            builder2.addStatement("controller.$L.id($L)", objectArray);
            if (!implicitlyAddAutoModels) continue;
            objectArray = new Object[]{model.getFieldName()};
            builder.addStatement("setControllerToStageTo(controller.$L, controller)", objectArray);
        }
        if (this.getConfigManager().shouldValidateModelUsage()) {
            builder.addStatement("saveModelsForNextValidation()", new Object[0]);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder.build()");
        return methodSpec;
    }

    @JvmOverloads
    public ControllerProcessor() {
        this(null, 1, null);
    }
}

