/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.processor.ControllerModelField;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.TypeNameWorkaroundKt;
import com.airbnb.epoxy.processor.resourcescanning.ResourceScanner;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001dJ\u0014\u0010,\u001a\u00020*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001d0.J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0003H\u0002J\b\u00100\u001a\u00020\nH\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00061"}, d2={"Lcom/airbnb/epoxy/processor/ControllerClassInfo;", "", "controllerClassElement", "Landroidx/room/compiler/processing/XTypeElement;", "resourceProcessor", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "(Landroidx/room/compiler/processing/XTypeElement;Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;Lcom/airbnb/epoxy/processor/Memoizer;)V", "classPackage", "", "getClassPackage", "()Ljava/lang/String;", "controllerClassType", "Lcom/squareup/javapoet/TypeName;", "getControllerClassType", "()Lcom/squareup/javapoet/TypeName;", "generatedClassName", "Lcom/squareup/javapoet/ClassName;", "getGeneratedClassName", "()Lcom/squareup/javapoet/ClassName;", "imports", "", "getImports", "()Ljava/util/List;", "imports$delegate", "Lkotlin/Lazy;", "models", "", "Lcom/airbnb/epoxy/processor/ControllerModelField;", "getModels", "()Ljava/util/Set;", "modelsImmutable", "", "getModelsImmutable", "originatingElement", "Landroidx/room/compiler/processing/XElement;", "getOriginatingElement", "()Landroidx/room/compiler/processing/XElement;", "getResourceProcessor", "()Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "addModel", "", "controllerModelField", "addModels", "controllerModelFields", "", "controllerClass", "toString", "epoxy-processor"})
public final class ControllerClassInfo {
    @NotNull
    private final ResourceScanner resourceProcessor;
    @NotNull
    private final XElement originatingElement;
    @NotNull
    private final String classPackage;
    @NotNull
    private final Set<ControllerModelField> models;
    @NotNull
    private final ClassName generatedClassName;
    @NotNull
    private final TypeName controllerClassType;
    @NotNull
    private final Lazy imports$delegate;

    public ControllerClassInfo(@NotNull XTypeElement controllerClassElement, @NotNull ResourceScanner resourceProcessor2, @NotNull Memoizer memoizer) {
        Intrinsics.checkNotNullParameter((Object)controllerClassElement, (String)"controllerClassElement");
        Intrinsics.checkNotNullParameter((Object)resourceProcessor2, (String)"resourceProcessor");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        this.resourceProcessor = resourceProcessor2;
        this.originatingElement = (XElement)controllerClassElement;
        this.classPackage = controllerClassElement.getPackageName();
        this.models = new HashSet();
        this.generatedClassName = this.getGeneratedClassName(controllerClassElement);
        this.controllerClassType = TypeNameWorkaroundKt.typeNameWithWorkaround(controllerClassElement.getType(), memoizer);
        this.imports$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this, controllerClassElement){
            final /* synthetic */ ControllerClassInfo this$0;
            final /* synthetic */ XTypeElement $controllerClassElement;
            {
                this.this$0 = $receiver;
                this.$controllerClassElement = $controllerClassElement;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return this.this$0.getResourceProcessor().getImports(this.$controllerClassElement);
            }
        }));
    }

    @NotNull
    public final ResourceScanner getResourceProcessor() {
        return this.resourceProcessor;
    }

    @NotNull
    public final XElement getOriginatingElement() {
        return this.originatingElement;
    }

    @NotNull
    public final String getClassPackage() {
        return this.classPackage;
    }

    @NotNull
    public final Set<ControllerModelField> getModels() {
        return this.models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<ControllerModelField> getModelsImmutable() {
        Set set;
        Set<ControllerModelField> set2 = this.models;
        synchronized (set2) {
            boolean bl = false;
            set = CollectionsKt.toSet((Iterable)this.models);
        }
        return set;
    }

    @NotNull
    public final ClassName getGeneratedClassName() {
        return this.generatedClassName;
    }

    @NotNull
    public final TypeName getControllerClassType() {
        return this.controllerClassType;
    }

    @NotNull
    public final List<String> getImports() {
        Lazy lazy = this.imports$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addModel(@NotNull ControllerModelField controllerModelField) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)controllerModelField, (String)"controllerModelField");
        Set<ControllerModelField> set = this.models;
        synchronized (set) {
            boolean bl2 = false;
            bl = this.models.add(controllerModelField);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addModels(@NotNull Collection<ControllerModelField> controllerModelFields) {
        boolean bl;
        Intrinsics.checkNotNullParameter(controllerModelFields, (String)"controllerModelFields");
        Set<ControllerModelField> set = this.models;
        synchronized (set) {
            boolean bl2 = false;
            bl = this.models.addAll(controllerModelFields);
        }
        return bl;
    }

    private final ClassName getGeneratedClassName(XTypeElement controllerClass) {
        String packageName = controllerClass.getPackageName();
        int packageLen = packageName.length() + 1;
        String string = controllerClass.getQualifiedName().substring(packageLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String className = StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null);
        ClassName className2 = ClassName.get((String)packageName, (String)(className + "_EpoxyHelper"), (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"get(packageName, \"$class\u2026TED_HELPER_CLASS_SUFFIX\")");
        return className2;
    }

    @NotNull
    public String toString() {
        return "ControllerClassInfo(models=" + this.models + ", generatedClassName=" + this.generatedClassName + ", controllerClassType=" + this.controllerClassType + ')';
    }
}

