/*
 * Decompiled with CFR 0.152.
 */
package com.airsoftware.saas.datasource.core;

import com.airsoftware.saas.datasource.context.SaaSDataSource;
import com.airsoftware.saas.datasource.core.SaaSDataSourceAnnotationAdvisor;
import com.airsoftware.saas.datasource.core.SaaSDataSourceAnnotationInterceptor;
import com.airsoftware.saas.datasource.core.SaaSDataSourceCreator;
import com.airsoftware.saas.datasource.core.SaaSDataSourceManager;
import com.airsoftware.saas.datasource.provider.SaaSDataSourceProvider;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDatasourceAopProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidDynamicDataSourceConfiguration;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
@AutoConfigureAfter(value={DynamicDataSourceAutoConfiguration.class})
@Import(value={DruidDynamicDataSourceConfiguration.class})
public class SaaSDataSourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SaaSDataSourceAutoConfiguration.class);
    @Resource
    private DataSource dynamicRoutingDataSource;
    @Lazy
    @Resource
    private SaaSDataSourceProvider saasDataSourceProvider;

    @Bean
    @ConditionalOnMissingBean
    public SaaSDataSourceAnnotationAdvisor saasDataSourceAnnotationAdvisor(DynamicDataSourceProperties properties) {
        SaaSDataSourceAnnotationInterceptor interceptor = new SaaSDataSourceAnnotationInterceptor();
        SaaSDataSourceAnnotationAdvisor advisor = new SaaSDataSourceAnnotationAdvisor(interceptor);
        SaaSDataSourceManager manager = new SaaSDataSourceManager();
        manager.setSaasDataSourceProvider(this.saasDataSourceProvider);
        manager.setDynamicRoutingDataSource((DynamicRoutingDataSource)this.dynamicRoutingDataSource);
        interceptor.setManager(manager);
        SaaSDataSource.setManager(manager);
        DynamicDatasourceAopProperties aopProperties = properties.getAop();
        advisor.setOrder(aopProperties.getOrder());
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public SaaSDataSourceCreator saasDataSourceCreator(DynamicDataSourceProperties properties) {
        return new SaaSDataSourceCreator(properties);
    }
}

