/*
 * Decompiled with CFR 0.152.
 */
package com.airsoftware.saas.datasource.core;

import com.airsoftware.saas.datasource.annotation.SaaS;
import com.airsoftware.saas.datasource.context.SaaSDataSource;
import com.airsoftware.saas.datasource.core.SaaSDataSourceClassResolver;
import com.airsoftware.saas.datasource.core.SaaSDataSourceManager;
import com.airsoftware.saas.datasource.util.StringUtil;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SaaSDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SaaSDataSourceAnnotationInterceptor.class);
    private SaaSDataSourceManager manager;
    private SaaSDataSourceClassResolver classResolver = new SaaSDataSourceClassResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String dsKey = "";
        boolean requestAddDataSource = false;
        try {
            String currentContext;
            String dsKeyField = this.getDsKeyField(invocation);
            if (RequestContextHolder.getRequestAttributes() != null) {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String sessionValue = (String)request.getSession().getAttribute(dsKeyField);
                String string = dsKey = StringUtil.isNotBlank(sessionValue) ? sessionValue : request.getHeader(dsKeyField);
            }
            if (StringUtil.isBlank(currentContext = SaaSDataSource.current()) && StringUtil.isNotBlank(dsKey)) {
                this.manager.addDataSource(dsKey);
                requestAddDataSource = true;
                DynamicDataSourceContextHolder.push((String)dsKey);
            }
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception e) {
            log.error("An exception occurred during the invocation of @SaaS, the JDBC Connection will switch to latest active or default data source.", (Throwable)e);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (requestAddDataSource) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }

    private String getDsKeyField(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Class<?> declaringClass = this.classResolver.targetClass(invocation);
        SaaS saas = method.isAnnotationPresent(SaaS.class) ? method.getAnnotation(SaaS.class) : (SaaS)AnnotationUtils.findAnnotation(declaringClass, SaaS.class);
        Assert.notNull((Object)saas, (String)"Can not find @SaaS annotation, please ensure that you put the @SaaS annotation in right place.");
        return saas.value();
    }

    public void setManager(SaaSDataSourceManager manager) {
        this.manager = manager;
    }
}

