/*
 * Decompiled with CFR 0.152.
 */
package com.airsoftware.saas.datasource.context;

import com.airsoftware.saas.datasource.core.SaaSDataSourceManager;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.core.NamedThreadLocal;

public final class SaaSDataSource {
    private static SaaSDataSourceManager manager;
    private static final ThreadLocal<Deque<String>> DS_KEY_HOLDER;

    public static String current() {
        return DS_KEY_HOLDER.get().peek();
    }

    public static void switchTo(String dsKey) {
        SaaSDataSource.set(dsKey);
    }

    public static void switchTo(Long dsKey) {
        SaaSDataSource.set(String.valueOf(dsKey));
    }

    public static void switchTo(Integer dsKey) {
        SaaSDataSource.set(String.valueOf(dsKey));
    }

    private static void set(String dsKey) {
        manager.addDataSource(dsKey);
        DS_KEY_HOLDER.get().push(dsKey);
        DynamicDataSourceContextHolder.push((String)dsKey);
    }

    public static void clearCurrent() {
        Deque<String> deque = DS_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            DS_KEY_HOLDER.remove();
        }
        DynamicDataSourceContextHolder.poll();
    }

    public static void clearAll() {
        Deque<String> deque = DS_KEY_HOLDER.get();
        int size = deque.size();
        for (int i = 0; i < size; ++i) {
            DynamicDataSourceContextHolder.poll();
        }
        deque.clear();
        DS_KEY_HOLDER.remove();
    }

    public static void removeAll() {
        Deque<String> deque = DS_KEY_HOLDER.get();
        deque.clear();
        DS_KEY_HOLDER.remove();
        DynamicDataSourceContextHolder.clear();
    }

    public static void setManager(SaaSDataSourceManager manager) {
        SaaSDataSource.manager = manager;
    }

    static {
        DS_KEY_HOLDER = new NamedThreadLocal<Deque<String>>("saas-datasource"){

            protected Deque<String> initialValue() {
                return new ArrayDeque<String>();
            }
        };
    }
}

