/*
 * Decompiled with CFR 0.152.
 */
package com.airsoftware.saas.datasource.context;

import com.airsoftware.saas.datasource.core.SaaSDataSourceManager;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.concurrent.LinkedBlockingDeque;

public class SaaSDataSource {
    private static SaaSDataSourceManager manager;
    private static ThreadLocal<LinkedBlockingDeque<String>> DS_KEY_HOLDER;

    public static String current() {
        LinkedBlockingDeque<String> deque = DS_KEY_HOLDER.get();
        return deque.isEmpty() ? null : deque.getFirst();
    }

    public static void switchTo(String dsKey) {
        SaaSDataSource.set(dsKey);
    }

    public static void switchTo(Long dsKey) {
        SaaSDataSource.set(String.valueOf(dsKey));
    }

    public static void switchTo(Integer dsKey) {
        SaaSDataSource.set(String.valueOf(dsKey));
    }

    private static void set(String dsKey) {
        manager.addDataSource(dsKey);
        DS_KEY_HOLDER.get().addFirst(dsKey);
        DynamicDataSourceContextHolder.setDataSourceLookupKey((String)dsKey);
    }

    public static void clearCurrent() {
        LinkedBlockingDeque<String> deque = DS_KEY_HOLDER.get();
        if (deque.isEmpty()) {
            DS_KEY_HOLDER.remove();
        } else {
            deque.pollFirst();
        }
        DynamicDataSourceContextHolder.clearDataSourceLookupKey();
    }

    public static void clearAll() {
        LinkedBlockingDeque<String> deque = DS_KEY_HOLDER.get();
        int size = deque.size();
        for (int i = 0; i < size; ++i) {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
        deque.clear();
        DS_KEY_HOLDER.remove();
    }

    public static void setManager(SaaSDataSourceManager manager) {
        SaaSDataSource.manager = manager;
    }

    static {
        DS_KEY_HOLDER = ThreadLocal.withInitial(LinkedBlockingDeque::new);
    }
}

