/*
 * Decompiled with CFR 0.152.
 */
package com.ailbb.act.mapreduce;

import com.ailbb.act.$;
import com.ailbb.act.entity.$MapReduceConfiguration;
import com.ailbb.act.hdfs.$Hdfs;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.parquet.avro.AvroParquetInputFormat;

public class $MapReduce
extends Configured
implements Tool {
    private $Hdfs hdfs;
    private Job job;
    private $MapReduceConfiguration mapReduceConfiguration;

    public $MapReduce init($Hdfs hdfs, $MapReduceConfiguration mapReduceConfiguration) throws Exception {
        return this.setMapReduceConfiguration(mapReduceConfiguration).setHdfs(hdfs).getHdfs().run(new PrivilegedExceptionAction<$MapReduce>(){

            @Override
            public $MapReduce run() throws Exception {
                return $MapReduce.this.initJob();
            }
        });
    }

    public void toolRun(String[] args) throws Exception {
        ToolRunner.run((Tool)this, (String[])args);
    }

    public int run(String[] args) throws Exception {
        return this.runJob() ? 0 : 1;
    }

    public boolean runJob() throws InterruptedException, IOException, ClassNotFoundException {
        $.sout((Object[])new Object[]{"============== \u6267\u884c\u4efb\u52a1\uff1a" + this.mapReduceConfiguration.getJobName() + " =============="});
        return this.job.waitForCompletion(true);
    }

    private $MapReduce initJob() throws Exception {
        Job job = Job.getInstance((Configuration)this.hdfs.getConf(), (String)this.mapReduceConfiguration.getJobName());
        FileSystem fs = this.hdfs.getFileSystem();
        for (String p : this.mapReduceConfiguration.getJarPath()) {
            for (FileStatus f : fs.listStatus(new Path(p))) {
                job.addFileToClassPath(f.getPath());
            }
        }
        job.setJarByClass($.isEmptyOrNull((Object[])new Object[]{this.mapReduceConfiguration.getJarClass()}) ? ((Object)((Object)this)).getClass() : this.mapReduceConfiguration.getJarClass());
        job.setMapOutputKeyClass(this.mapReduceConfiguration.getMapOutputKeyClass());
        job.setMapOutputValueClass(this.mapReduceConfiguration.getMapOutputValueClass());
        job.setOutputKeyClass(this.mapReduceConfiguration.getReduceOutputKeyClass());
        job.setOutputValueClass(this.mapReduceConfiguration.getReduceOutputValueClass());
        job.setMapperClass(this.mapReduceConfiguration.getMapper());
        job.setReducerClass(this.mapReduceConfiguration.getReducer());
        job.setInputFormatClass(this.mapReduceConfiguration.getInputFormatClass());
        job.setOutputFormatClass(this.mapReduceConfiguration.getOutputFormatClass());
        job.setNumReduceTasks(this.mapReduceConfiguration.getNumReduceTasks());
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.mapReduceConfiguration.getInputPath())});
        if (!$.isEmptyOrNull((Object[])new Object[]{this.mapReduceConfiguration.getOutputPath()})) {
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.mapReduceConfiguration.getOutputPath()));
        }
        return this;
    }

    public $Hdfs getHdfs() {
        return this.hdfs;
    }

    public $MapReduce setHdfs($Hdfs hdfs) {
        this.hdfs = hdfs;
        return this;
    }

    public Job getJob() {
        return this.job;
    }

    public $MapReduce setJob(Job job) {
        this.job = job;
        return this;
    }

    public $MapReduceConfiguration getMapReduceConfiguration() {
        return this.mapReduceConfiguration;
    }

    public $MapReduce setMapReduceConfiguration($MapReduceConfiguration mapReduceConfiguration) {
        this.mapReduceConfiguration = mapReduceConfiguration;
        return this;
    }
}

