/*
 * Decompiled with CFR 0.152.
 */
package com.ailbb.act.kerberos;

import com.ailbb.act.entity.$ConfSite;
import com.ailbb.act.entity.$KerberosConnConfiguration;
import com.ailbb.ajj.$;
import com.ailbb.ajj.entity.;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class $Kerberos {
    private UserGroupInformation ugi;
    private Configuration conf;
    private $ConfSite confSite;
    private $KerberosConnConfiguration kerberosConnConfiguration;

    public $Kerberos init($KerberosConnConfiguration kerberosConnConfiguration, $ConfSite confSite) {
        $.info((Object[])new Object[]{"============== kerberos\u6267\u884c\u521d\u59cb\u5316 =============="});
        this.setKerberosConnConfiguration(kerberosConnConfiguration).setConfSite(confSite).setUgi(null).valid();
        return this;
    }

    public boolean valid() {
        try {
            $.info((Object[])new Object[]{"============== kerberos\u5f00\u59cb\u9a8c\u8bc1 =============="});
            if (!this.doCheck()) {
                this.doConfig();
                .Result rs = this.doLogin();
                if (!rs.isSuccess()) {
                    if (rs.getError().size() != 0) {
                        $.error((Object[])new Object[]{"============== kerberos\u9a8c\u8bc1\u5931\u8d25 =============="});
                    }
                    return false;
                }
            }
            $.info((Object[])new Object[]{"============== kerberos\u9a8c\u8bc1\u6210\u529f =============="});
            return true;
        }
        catch (Exception e) {
            $.error((Object[])new Object[]{"============== kerberos\u9a8c\u8bc1\u5f02\u5e38 =============="});
            $.exception((Exception[])new Exception[]{e});
            return false;
        }
    }

    public Configuration doConfig() {
        System.setProperty("java.security.krb5.conf", this.kerberosConnConfiguration.getConfFile());
        this.conf = this.confSite.addResource(new Configuration());
        this.conf.setInt("hbase.rpc.timeout", this.kerberosConnConfiguration.getRpcTimeOut());
        this.conf.setInt("hbase.client.operation.timeout", this.kerberosConnConfiguration.getOperationTimeOut());
        this.conf.setInt("hbase.client.scanner.timeout.period", this.kerberosConnConfiguration.getScannerTimeOut());
        this.conf.set("kerberos.principal", this.kerberosConnConfiguration.getPrincipal());
        this.conf.set("kerberos.keytab", this.kerberosConnConfiguration.getKeyTab());
        if ($.isEmptyOrNull((Object[])new Object[]{this.conf.get("hadoop.security.authentication")})) {
            this.conf.set("hadoop.security.authentication", this.kerberosConnConfiguration.getSecurityAuthentication());
        } else {
            this.kerberosConnConfiguration.setSecurityAuthentication(this.conf.get("hadoop.security.authentication"));
        }
        return this.conf;
    }

    public .Result doLogin() {
        .Result rs = $.result();
        try {
            UserGroupInformation.reset();
            UserGroupInformation.setConfiguration((Configuration)this.conf);
            this.outInfo();
            if (!this.kerberosConnConfiguration.isAuthorization() || !UserGroupInformation.isSecurityEnabled()) {
                rs.setSuccess(false).addMessage(new String[]{$.warn((Object[])new Object[]{"============== \u672a\u6267\u884c\u767b\u5f55\uff0c\u56e0\u4e3akerberos\u672a\u542f\u7528 =============="})});
            }
            this.ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.conf.get("kerberos.principal"), (String)this.conf.get("kerberos.keytab"));
            rs.addMessage(new String[]{$.info((Object[])new Object[]{"============== \u767b\u5f55\u6210\u529f =============="})});
        }
        catch (IOException e) {
            rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})}).addMessage(new String[]{$.error((Object[])new Object[]{"============== \u767b\u5f55\u5931\u8d25 =============="})});
        }
        return rs;
    }

    public boolean doCheck() {
        try {
            if (!$.isEmptyOrNull((Object[])new Object[]{this.ugi})) {
                this.ugi.checkTGTAndReloginFromKeytab();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public <T> T run(PrivilegedExceptionAction<T> action) throws Exception {
        return this.doAs(action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws Exception {
        return (T)($.isEmptyOrNull((Object[])new Object[]{this.getUgi()}) ? action.run() : this.getUgi().doAs(action));
    }

    private void outInfo() {
        $.info((Object[])new Object[]{"============== kerberos\u9a8c\u8bc1\u4fe1\u606f =============="});
        $.info((Object[])new Object[]{String.format("coreSite = %s", this.confSite.getCoreSite())});
        $.info((Object[])new Object[]{String.format("hdfsSite = %s", this.confSite.getHdfsSite())});
        $.info((Object[])new Object[]{String.format("yarnSite = %s", this.confSite.getYarnSite())});
        $.info((Object[])new Object[]{String.format("mapredSite = %s", this.confSite.getMapredSite())});
        $.info((Object[])new Object[]{String.format("hiveSite = %s", this.confSite.getHiveSite())});
        $.info((Object[])new Object[]{String.format("hbaseSite = %s", this.confSite.getHbaseSite())});
        $.info((Object[])new Object[]{String.format("hbase.rpc.timeout = %s", this.kerberosConnConfiguration.getRpcTimeOut())});
        $.info((Object[])new Object[]{String.format("hbase.client.operation.timeout = %s", this.kerberosConnConfiguration.getOperationTimeOut())});
        $.info((Object[])new Object[]{String.format("hbase.client.scanner.timeout.period = %s", this.kerberosConnConfiguration.getScannerTimeOut())});
        $.info((Object[])new Object[]{String.format("PRINCIPAL = %s", this.kerberosConnConfiguration.getPrincipal())});
        $.info((Object[])new Object[]{String.format("KEYTAB = %s", this.kerberosConnConfiguration.getKeyTab())});
        $.info((Object[])new Object[]{String.format("hadoop.security.authentication = %s", this.kerberosConnConfiguration.getSecurityAuthentication())});
        $.info((Object[])new Object[]{String.format("\u7528\u6237\u4fe1\u606f = %s", $.isEmptyOrNull((Object[])new Object[]{this.ugi}) ? null : this.ugi.getShortUserName())});
        $.info((Object[])new Object[]{String.format("Kerberos \u662f\u5426\u542f\u7528\uff1a %s", UserGroupInformation.isSecurityEnabled())});
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public $Kerberos setUgi(UserGroupInformation ugi) {
        this.ugi = ugi;
        return this;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public $ConfSite getConfSite() {
        return this.confSite;
    }

    public $Kerberos setConfSite($ConfSite confSite) {
        this.confSite = confSite;
        return this;
    }

    public boolean isEnable() {
        return this.kerberosConnConfiguration.isAuthorization();
    }

    public $KerberosConnConfiguration getKerberosConnConfiguration() {
        return this.kerberosConnConfiguration;
    }

    public $Kerberos setKerberosConnConfiguration($KerberosConnConfiguration kerberosConnConfiguration) {
        this.kerberosConnConfiguration = kerberosConnConfiguration;
        return this;
    }
}

