/*
 * Decompiled with CFR 0.152.
 */
package com.ailbb.act.hdfs;

import com.ailbb.act.$;
import com.ailbb.act.hadoop.$Hadoop;
import com.ailbb.act.kerberos.$Kerberos;
import com.ailbb.ajj.entity.;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;

public class $Hdfs
extends $Hadoop {
    private FileSystem fileSystem = null;
    private Configuration conf;
    private int HDFS_WRITE_BUFSIZE = 524288;
    private long tryTimeOut = 30000L;

    public $Hdfs init($Kerberos kerberos) throws Exception {
        this.setKerberos(kerberos);
        return this.init(kerberos.getConf());
    }

    public $Hdfs init(final Configuration conf) throws Exception {
        $.info((Object[])new Object[]{"============== Hdfs\u6267\u884c\u521d\u59cb\u5316 =============="});
        final $Hdfs hdfs = this.setConf(conf);
        return this.run(new PrivilegedExceptionAction<$Hdfs>(){

            @Override
            public $Hdfs run() throws Exception {
                hdfs.setFileSystem(FileSystem.get((Configuration)conf));
                $.info((Object[])new Object[]{"============== Hdfs\u521d\u59cb\u5316\u5b8c\u6210 =============="});
                $.info((Object[])new Object[]{"============== \u6839\u76ee\u5f55\u5217\u8868 =============="});
                for (String path : hdfs.getNameSpace("/")) {
                    $.info((Object[])new Object[]{path});
                }
                return hdfs;
            }
        });
    }

    public List<String> getNameSpace(final String path) throws Exception {
        return this.run(new PrivilegedExceptionAction<List<String>>(){

            @Override
            public List<String> run() throws Exception {
                ArrayList<String> list = new ArrayList<String>();
                FileStatus[] fileStatuses = null;
                for (FileStatus fileStatus : fileStatuses = $Hdfs.this.getFileSystem().listStatus(new Path(path))) {
                    String[] split = fileStatus.getPath().toString().split("/");
                    list.add(split[split.length - 1]);
                }
                return list;
            }
        });
    }

    public .Result deletePath(final String path, final boolean recursive) {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$Hdfs>(){

                @Override
                public $Hdfs run() throws Exception {
                    $Hdfs.this.getFileSystem().delete(new Path(path), recursive);
                    return $.hdfs;
                }
            });
        }
        catch (Exception e) {
            return rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public .Result deletePath(String path) {
        return this.deletePath(path, true);
    }

    public .Result uploadFile(String path, String descPath) {
        return this.uploadFile(path, descPath, true);
    }

    public .Result uploadFile(final String path, final String descPath, final boolean overwrite) {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$Hdfs>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public $Hdfs run() throws Exception {
                    Path dp = new Path(descPath);
                    $.info((Object[])new Object[]{"upload " + path + " to " + descPath});
                    try {
                        $Hdfs.this.getFileSystem().copyFromLocalFile(false, overwrite, new Path(path), dp);
                    }
                    catch (Exception e) {
                        $.warn((Object[])new Object[]{e});
                        FSDataOutputStream fos = $Hdfs.this.getFileSystem().exists(dp) && !overwrite ? $Hdfs.this.getFileSystem().append(dp, $Hdfs.this.HDFS_WRITE_BUFSIZE) : $Hdfs.this.getFileSystem().create(dp, overwrite, $Hdfs.this.HDFS_WRITE_BUFSIZE, $Hdfs.this.getFileSystem().getDefaultReplication(dp), $Hdfs.this.getFileSystem().getDefaultBlockSize(dp));
                        try {
                            IOUtils.copyBytes((InputStream)$.file.getInputStream(path), (OutputStream)fos, (int)8192, (boolean)true);
                        }
                        finally {
                            $.file.closeStearm((AutoCloseable)fos);
                        }
                    }
                    return $.hdfs;
                }
            });
        }
        catch (Exception e) {
            return rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public .Result downloadFile(final String path, final String descPath, boolean overwrite) {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$Hdfs>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public $Hdfs run() throws Exception {
                    Path sp = new Path(path);
                    Path dp = new Path(descPath);
                    $.info((Object[])new Object[]{"download " + path + " to " + descPath});
                    try {
                        $Hdfs.this.getFileSystem().copyToLocalFile(false, sp, dp);
                    }
                    catch (Exception e) {
                        $.warn((Object[])new Object[]{e});
                        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream($.getFile((String)descPath)));
                        try {
                            IOUtils.copyBytes((InputStream)$Hdfs.this.getFileSystem().open(sp), (OutputStream)fos, (int)8192, (boolean)true);
                        }
                        finally {
                            $.file.closeStearm(fos);
                        }
                    }
                    return $.hdfs;
                }
            });
        }
        catch (Exception e) {
            return rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public FileSystem getFileSystem() throws Exception {
        try {
            if (!$.kerberos.valid()) {
                throw new TimeoutException("\u9a8c\u8bc1\u8d85\u65f6...");
            }
            this.fileSystem.getStatus();
        }
        catch (Exception e) {
            try {
                $.warn((Object[])new Object[]{"\u9a8c\u8bc1\u5931\u8d25[" + e + "]... \u7cfb\u7edf\u5c06\u5728[" + this.tryTimeOut / 1000L + "] \u79d2\u540e\u91cd\u8bd5..."});
                Thread.sleep(this.tryTimeOut);
                this.init(this.conf);
            }
            catch (Exception ex) {
                e.printStackTrace();
                ex.printStackTrace();
                throw ex;
            }
        }
        return this.fileSystem;
    }

    public $Hdfs setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public $Hdfs setConf(Configuration conf) {
        if (null != conf) {
            conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        }
        this.conf = conf;
        return this;
    }

    public long getTryTimeOut() {
        return this.tryTimeOut;
    }

    public void setTryTimeOut(long tryTimeOut) {
        this.tryTimeOut = tryTimeOut;
    }
}

