/*
 * Decompiled with CFR 0.152.
 */
package com.ailbb.act.hbase;

import com.ailbb.act.$;
import com.ailbb.act.exception.$HBaseException$;
import com.ailbb.act.hadoop.$Hadoop;
import com.ailbb.act.hdfs.$Hdfs;
import com.ailbb.act.kerberos.$Kerberos;
import com.ailbb.ajj.entity.;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;

public class $HBase
extends $Hadoop {
    private Connection connection = null;
    private Configuration conf;
    private $Hdfs hdfs;
    private Admin admin;
    public static final byte[] $FAMILY = "f0".getBytes();

    public $HBase init($Kerberos kerberos, $Hdfs hdfs) throws Exception {
        this.setKerberos(kerberos);
        return this.init(kerberos.getConf(), hdfs);
    }

    public $HBase init(final Configuration conf, $Hdfs hdfs) throws Exception {
        $.info((Object[])new Object[]{"============== Hbase\u6267\u884c\u521d\u59cb\u5316 =============="});
        final $HBase hbase = this.setConf(this.initHbaseConfiguration(conf)).setHdfs(hdfs);
        return this.run(new PrivilegedExceptionAction<$HBase>(){

            @Override
            public $HBase run() throws Exception {
                hbase.setConnection(ConnectionFactory.createConnection((Configuration)conf));
                hbase.setAdmin(hbase.getConnection().getAdmin());
                $.info((Object[])new Object[]{"============== Hbase\u521d\u59cb\u5316\u5b8c\u6210 =============="});
                return hbase;
            }
        });
    }

    public Configuration initHbaseConfiguration(Configuration conf) {
        if ($.isEmptyOrNull((Object[])new Object[]{conf})) {
            return HBaseConfiguration.create();
        }
        conf.setClassLoader(HBaseConfiguration.class.getClassLoader());
        try {
            HeapMemorySizeUtil.checkForClusterFreeMemoryLimit((Configuration)conf);
            return conf;
        }
        catch (Exception e) {
            return HBaseConfiguration.addHbaseResources((Configuration)conf);
        }
    }

    public List<String> getHbaseAllNameSpace() throws Exception {
        return this.hdfs.getNameSpace("/hbase/data/");
    }

    public .Result createTable(final String tableName) {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$HBase>(){

                @Override
                public $HBase run() throws Exception {
                    TableName tb = $HBase.this.toTableName(tableName);
                    if ($HBase.this.admin.tableExists(tb)) {
                        throw new $HBaseException$.TableExistsException("\u8868\u5df2\u7ecf\u5b58\u5728\uff1a" + tableName);
                    }
                    HTableDescriptor td = new HTableDescriptor(tb);
                    td.setDurability(Durability.SKIP_WAL);
                    HColumnDescriptor cd = new HColumnDescriptor($FAMILY);
                    cd.setCompressionType(Compression.Algorithm.SNAPPY);
                    cd.setBlocksize(131072);
                    cd.setMaxVersions(1);
                    cd.setBloomFilterType(BloomType.NONE);
                    td.addFamily(cd);
                    $HBase.this.admin.createTable(td);
                    return $.hbase;
                }
            });
        }
        catch ($HBaseException$.TableExistsException e) {
            rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})}).setSuccess(true);
        }
        catch (Exception e) {
            rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public .Result dropTable(final String tableName) {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$HBase>(){

                @Override
                public $HBase run() throws Exception {
                    TableName tb = $HBase.this.toTableName(tableName);
                    if (!$HBase.this.admin.tableExists(tb)) {
                        throw new $HBaseException$.TableNotExistsException("\u8868\u4e0d\u5b58\u5728\uff1a" + tableName);
                    }
                    $HBase.this.admin.deleteTable(tb);
                    return $.hbase;
                }
            });
        }
        catch ($HBaseException$.TableNotExistsException e) {
            rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})}).setSuccess(true);
        }
        catch (Exception e) {
            rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public .Result close() {
        .Result rs = $.result();
        try {
            this.run(new PrivilegedExceptionAction<$HBase>(){

                @Override
                public $HBase run() throws Exception {
                    if (null != $HBase.this.admin) {
                        $HBase.this.admin.close();
                    }
                    return $.hbase;
                }
            });
        }
        catch (Exception e) {
            return rs.addError(new Exception[]{$.exception((Exception[])new Exception[]{e})});
        }
        return rs;
    }

    public TableName toTableName(String tableName) {
        return TableName.valueOf((String)tableName);
    }

    private Connection getConnection() {
        return this.connection;
    }

    public $HBase setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public $HBase setAdmin(Admin admin) {
        this.admin = admin;
        return this;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public $HBase setConf(Configuration conf) {
        this.conf = conf;
        return this;
    }

    public $Hdfs getHdfs() {
        return this.hdfs;
    }

    public $HBase setHdfs($Hdfs hdfs) {
        this.hdfs = hdfs;
        return this;
    }
}

