/*
 * Decompiled with CFR 0.152.
 */
package com.ailbb.act.file.parquet;

import com.ailbb.act.$;
import com.ailbb.act.file.parquet.$ParquetSchemaWriter;
import com.ailbb.act.hdfs.$Hdfs;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;

public class $Parquet {
    private $Hdfs hdfs;

    public $Parquet init($Hdfs hdfs) throws Exception {
        return this.setHdfs(hdfs);
    }

    public List<Object> readFiles(String path, Class c) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Group line;
        ArrayList<Object> datas = new ArrayList<Object>();
        ParquetReader build = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(path)).build();
        while ((line = (Group)build.read()) != null) {
            datas.add(c.getConstructor(Group.class).newInstance(line));
        }
        build.close();
        return datas;
    }

    public List<Group> readFiles(String path) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Group line;
        ArrayList<Group> datas = new ArrayList<Group>();
        ParquetReader build = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(path)).build();
        while ((line = (Group)build.read()) != null) {
            datas.add(line);
        }
        build.close();
        return datas;
    }

    public List<GenericRecord> readGenericRecordFiles(String path) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        GenericRecord line;
        ArrayList<GenericRecord> datas = new ArrayList<GenericRecord>();
        ParquetReader build = AvroParquetReader.builder((Path)new Path(path)).build();
        while ((line = (GenericRecord)build.read()) != null) {
            datas.add(line);
        }
        build.close();
        return datas;
    }

    public List<Object> readGenericRecordFiles(String path, Class c) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        GenericRecord line;
        ArrayList<Object> datas = new ArrayList<Object>();
        ParquetReader build = AvroParquetReader.builder((Path)new Path(path)).build();
        while ((line = (GenericRecord)build.read()) != null) {
            datas.add(c.getConstructor(GenericRecord.class).newInstance(line));
        }
        build.close();
        return datas;
    }

    public void writeGenericRecordFiles(String path, Schema schema, Object o) throws Exception {
        this.getParquetSchemaWriter(path, schema).write(o).close();
    }

    public void writeGenericRecordFiles(String path, Schema schema, List<Object> ol) throws Exception {
        this.getParquetSchemaWriter(path, schema).write(ol).close();
    }

    public $ParquetSchemaWriter getParquetSchemaWriter(String path, Schema schema) throws Exception {
        ParquetWriter parquetWriter;
        try {
            parquetWriter = AvroParquetWriter.builder((Path)this.getParquetWritePath(path)).withSchema(schema).build();
        }
        catch (RemoteException e) {
            return this.getParquetSchemaWriter(path, schema);
        }
        return new $ParquetSchemaWriter((ParquetWriter<GenericRecord>)parquetWriter, schema);
    }

    public Path getParquetWritePath(final String path) throws Exception {
        return this.hdfs.run(new PrivilegedExceptionAction<Path>(){

            @Override
            public Path run() throws Exception {
                Path outpath = new Path(path);
                FileSystem fs = $Parquet.this.hdfs.getFileSystem();
                if (!fs.exists(outpath) || !fs.isFile(outpath)) {
                    return $Parquet.this.getRandomPath(path);
                }
                fs.delete(outpath, false);
                return outpath;
            }
        });
    }

    public Path getRandomPath(final String path) throws Exception {
        return this.hdfs.run(new PrivilegedExceptionAction<Path>(){

            @Override
            public Path run() throws Exception {
                Path outpath = new Path(path);
                FileSystem fs = $Parquet.this.hdfs.getFileSystem();
                int i = 1;
                try {
                    i = fs.listStatus(outpath).length;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (fs.exists(outpath = new Path(path + "/parquet-" + $.string.fill((Object)i++, 6, "0")))) {
                }
                return outpath;
            }
        });
    }

    public $Hdfs getHdfs() {
        return this.hdfs;
    }

    public $Parquet setHdfs($Hdfs hdfs) {
        this.hdfs = hdfs;
        return this;
    }
}

