/*
 * Decompiled with CFR 0.152.
 */
package com.airepublic.microverse.rest.server;

import com.airepublic.microverse.core.common.marshaller.IMarshaller;
import com.airepublic.microverse.core.common.marshaller.MarshallerFactory;
import com.airepublic.microverse.core.descriptor.ServiceDescriptor;
import com.airepublic.microverse.core.descriptor.WebCall;
import com.airepublic.microverse.core.exception.ServiceException;
import com.airepublic.microverse.core.server.AbstractServiceServer;
import com.airepublic.microverse.core.server.IClassLoaderCreator;
import com.airepublic.microverse.rest.server.RestClassLoaderCreator;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/server")
public class RestServiceServer
extends AbstractServiceServer {
    private static final Logger LOG = LoggerFactory.getLogger(RestServiceServer.class);
    private final IClassLoaderCreator classLoaderCreator = new RestClassLoaderCreator();
    private String pathToThisResource;
    private final Object pathToThisResourceSync = new Object();

    @PostConstruct
    public void init() {
        super.init();
        LOG.info("----------- Service-Server has been initialized! -----------");
    }

    protected IClassLoaderCreator getClassLoaderCreator() {
        return this.classLoaderCreator;
    }

    @Path(value="mediatypes")
    @GET
    @Produces(value={"text/plain"})
    public Response getSupportedMediaTypes() {
        StringBuffer mimeTypes = new StringBuffer();
        for (String mimeType : MarshallerFactory.getSupportedMimeTypes()) {
            if (mimeTypes.length() > 0) {
                mimeTypes.append(",");
            }
            mimeTypes.append(mimeType);
        }
        return Response.ok().entity((Object)mimeTypes.toString()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="add")
    @POST
    public Response addService(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context HttpHeaders headers, InputStream inputStream) {
        try {
            Object object = this.pathToThisResourceSync;
            synchronized (object) {
                if (this.pathToThisResource == null) {
                    String pathToThisResource = uriInfo.getAbsolutePath().getRawPath().substring(0, uriInfo.getAbsolutePath().getRawPath().lastIndexOf(47));
                    if (pathToThisResource.startsWith("/")) {
                        pathToThisResource = pathToThisResource.substring(1);
                    }
                    this.pathToThisResource = pathToThisResource;
                }
            }
            ServiceDescriptor serviceDescriptor = this.addService(request.getServerName(), request.getServerPort(), request.isSecure(), inputStream);
            return Response.ok().entity((Object)MarshallerFactory.get((String)this.getMimeTypeForResponse(headers)).serialize((Serializable)serviceDescriptor)).build();
        }
        catch (Exception e) {
            LOG.error("Could not add service!", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not add service!" + e)).build();
        }
    }

    protected WebCall getServiceWebCall(String serviceId, String serviceVersion) {
        return WebCall.create((String)(this.pathToThisResource + "/process/" + serviceId + "/" + serviceVersion), (String)"POST");
    }

    protected WebCall getHeartbeatWebCall(String serviceId, String serviceVersion) {
        return WebCall.create((String)(this.pathToThisResource + "/heartbeat"), (String)"GET");
    }

    @Path(value="remove/{serviceId}/{serviceVersion : .+}")
    @POST
    public Response removeService(@Context HttpHeaders headers, @PathParam(value="serviceId") String serviceId, @PathParam(value="serviceVersion") String serviceVersion) {
        try {
            if (headers.getMediaType() == null) {
                LOG.error("No content-type specified in request!");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No content-type specified in request!").build();
            }
            this.removeService(serviceId, serviceVersion);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Could not remove service: " + serviceId + ":" + serviceVersion, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not remove service: " + serviceId + ":" + serviceVersion + "\n" + e)).build();
        }
    }

    protected void onServiceRegistration(ServiceDescriptor serviceDescriptor) {
    }

    protected void onServiceUnregistration(ServiceDescriptor serviceDescriptor) {
    }

    protected String getMimeTypeFromRequest(HttpHeaders headers) {
        return headers.getMediaType().getType() + "/" + headers.getMediaType().getSubtype();
    }

    protected String getMimeTypeForResponse(HttpHeaders headers) {
        if (headers.getAcceptableMediaTypes() != null && !headers.getAcceptableMediaTypes().isEmpty()) {
            MediaType accept = (MediaType)headers.getAcceptableMediaTypes().get(0);
            return accept.getType() + "/" + accept.getSubtype();
        }
        return null;
    }

    protected ServiceDescriptor unmarshalServiceDescriptor(HttpHeaders headers, InputStream inputStream) {
        ServiceDescriptor serviceDescriptor = null;
        String mimeType = this.getMimeTypeFromRequest(headers);
        IMarshaller marshaller = MarshallerFactory.get((String)mimeType);
        if (marshaller != null) {
            try {
                serviceDescriptor = (ServiceDescriptor)marshaller.deserialize(inputStream, ServiceDescriptor.class);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return serviceDescriptor;
    }

    @Path(value="process/{serviceClass : .+}")
    @POST
    public Response process(@Context HttpHeaders headers, InputStream inputStream, @Context UriInfo uriInfo) {
        try {
            String uri = uriInfo.getAbsolutePath().getPath();
            if (headers.getMediaType() == null) {
                LOG.error("No content-type specified in request!");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No content-type specified in request!").build();
            }
            String mimeType = this.getMimeTypeFromRequest(headers);
            Serializable result = this.process(uri, mimeType, inputStream);
            if (result != null) {
                String returnMimeType = this.getMimeTypeForResponse(headers);
                if (returnMimeType == null) {
                    LOG.error("No accept header found in request!");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No accept header found in request!").build();
                }
                IMarshaller marshaller = MarshallerFactory.get((String)returnMimeType);
                if (marshaller == null) {
                    LOG.error("No marshaller found for mime-type: " + mimeType);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No marshaller to serialize respone found for mime-type: " + mimeType)).build();
                }
                return Response.ok().header("Content-Type", (Object)returnMimeType).entity((Object)marshaller.serialize(result)).build();
            }
            return Response.ok().build();
        }
        catch (Throwable e) {
            LOG.error("Error calling service method!", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Error calling service method!").build();
        }
    }

    @Path(value="heartbeat")
    @GET
    public Response heartbeat() {
        return Response.ok().build();
    }
}

