/*
 * Decompiled with CFR 0.152.
 */
package com.airepublic.microverse.rest.server;

import com.airepublic.microverse.core.common.Configuration;
import com.airepublic.microverse.core.common.marshaller.MarshallerFactory;
import com.airepublic.microverse.core.descriptor.ServiceCreateDescriptor;
import com.airepublic.microverse.core.descriptor.ServiceCreateDescriptorList;
import com.airepublic.microverse.core.exception.ServiceException;
import com.airepublic.microverse.rest.client.Deployer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class AutoDeployer
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(AutoDeployer.class);

    public void contextInitialized(ServletContextEvent event) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    protected void loadConfiguredServices() throws ServiceException {
        try {
            String configDirStr = Configuration.getServiceDeployDir();
            if (configDirStr != null) {
                Path configDir = Paths.get(configDirStr, new String[0]);
                if (!Files.exists(configDir, new LinkOption[0])) {
                    LOG.warn("Could not auto-load services due to invalid service directory configured in 'microverse.service.deploy.dir': " + configDir);
                    return;
                }
                Path configFile = configDir.resolve(Configuration.getAutoDeployDeploymentConfigFilename());
                if (!Files.exists(configFile, new LinkOption[0])) {
                    LOG.warn("Could not auto-load services due to missing configuration file 'microverse.config' in: " + configDir);
                    return;
                }
                byte[] configBytes = Files.readAllBytes(configFile);
                ServiceCreateDescriptorList descriptors = (ServiceCreateDescriptorList)MarshallerFactory.get((String)"application/json").deserialize(configBytes, ServiceCreateDescriptorList.class);
                this.deployConfiguredServices(configDir, descriptors);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected void deployConfiguredServices(Path configDir, ServiceCreateDescriptorList descriptors) throws ServiceException {
        try {
            for (ServiceCreateDescriptor descriptor : descriptors.getDescriptors()) {
                LOG.info("Deploying service: " + descriptor);
                Deployer.deploy((String)descriptors.getHost(), (int)descriptors.getPort(), (boolean)descriptors.getUseSSL(), (String)descriptors.getContextRoot(), (Path)configDir.resolve(descriptor.getBundle()));
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

