/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);

    public static String timeStampAsString() {
        return DateUtil.timeStampAsString("yyyyMMddkkmmssSSS".length());
    }

    public static String timeStampAsString(int numberOfPlaces) {
        String answer = "";
        Calendar cal = Calendar.getInstance();
        String genDate = DateFormatUtils.format((Calendar)cal, (String)"yyyyMMddkkmmssSSS");
        answer = StringUtils.right((String)genDate, (int)numberOfPlaces);
        return answer;
    }

    public static String timeAsHexDigitsString() {
        return DateUtil.timeAsHexDigitsString(Integer.MAX_VALUE);
    }

    public static String timeAsHexDigitsString(int numberOfPlaces) {
        String answer = "";
        Calendar cal = Calendar.getInstance();
        String year = DateFormatUtils.format((Calendar)cal, (String)"yy");
        String month = DateFormatUtils.format((Calendar)cal, (String)"MM");
        String day = DateFormatUtils.format((Calendar)cal, (String)"dd");
        String hour = DateFormatUtils.format((Calendar)cal, (String)"kk");
        String minute = DateFormatUtils.format((Calendar)cal, (String)"mm");
        String second = DateFormatUtils.format((Calendar)cal, (String)"ss");
        answer = answer + Long.toHexString(Long.parseLong(year));
        answer = answer + Long.toHexString(Long.parseLong(month));
        answer = answer + Long.toHexString(Long.parseLong(day));
        answer = answer + Long.toHexString(Long.parseLong(hour));
        answer = answer + Long.toHexString(Long.parseLong(minute));
        answer = answer + Long.toHexString(Long.parseLong(second));
        answer = StringUtils.right((String)answer, (int)numberOfPlaces);
        return answer;
    }

    public static String addDayString(String dateString, int days, String dateFormat) {
        if (StringUtils.isEmpty((String)dateString)) {
            return dateString;
        }
        Date passedDateAsDate = DateUtil.convertToDate(dateString, dateFormat);
        Date newDate = DateUtils.addDays((Date)passedDateAsDate, (int)days);
        String newDateAsString = DateFormatUtils.format((Date)newDate, (String)dateFormat);
        return newDateAsString;
    }

    public static String subtractDayString(String dateString, int days, String dateFormat) {
        int subtractDays = days;
        return DateUtil.addDayString(dateString, subtractDays *= -1, dateFormat);
    }

    public static Date convertToDate(String dateAsString, String format) {
        Date answer = null;
        try {
            answer = DateUtils.parseDate((String)dateAsString, (String[])new String[]{format});
        }
        catch (ParseException e) {
            logger.error("Parsing date '%s' failed", (Object)dateAsString, (Object)e);
        }
        return answer;
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        if (date == null) {
            return null;
        }
        return formatter.format(date);
    }
}

