/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.data;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ScenarioData {
    private String scenarioFullName;
    private String testCaseFullName;
    private Map<String, Object> scenarioParameters;
    private static final Set<Class<?>> SUPPORTED_TYPES = ScenarioData.getSupportedDataTypes();

    public ScenarioData() {
        this("unNamed Scenario");
    }

    public ScenarioData(String scenarioName) {
        this(scenarioName, "");
    }

    public ScenarioData(String scenarioName, String testCaseName) {
        this.scenarioFullName = scenarioName;
        this.testCaseFullName = testCaseName;
        this.scenarioParameters = new HashMap<String, Object>();
    }

    public void putScenarioData(String parameterKey, Object parameterData) {
        this.putScenarioData(parameterKey, parameterData, true);
    }

    public void putScenarioData(String parameterKey, Object parameterData, boolean overwriteIfKeyFound) {
        if (this.ParameterDataTypeIsSupported(parameterData.getClass())) {
            if (overwriteIfKeyFound) {
                this.scenarioParameters.put(parameterKey, parameterData);
            } else if (!this.scenarioParameters.containsKey(parameterKey)) {
                this.scenarioParameters.put(parameterKey, parameterData);
            }
        }
    }

    public String getScenarioName() {
        return this.scenarioFullName;
    }

    public String getTestCaseName() {
        return this.testCaseFullName;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseFullName = testCaseName;
    }

    public int getIntParameterData(String parameterKey) {
        return Integer.parseInt(this.scenarioParameters.get(parameterKey).toString());
    }

    public char getCharParameterData(String parameterKey) {
        return ((Character)this.scenarioParameters.get(parameterKey)).charValue();
    }

    public boolean getBooleanParameterData(String parameterKey) {
        return (Boolean)this.scenarioParameters.get(parameterKey);
    }

    public byte getByteParameterData(String parameterKey) {
        return (Byte)this.scenarioParameters.get(parameterKey);
    }

    public long getShortParameterData(String parameterKey) {
        return (Long)this.scenarioParameters.get(parameterKey);
    }

    public float getFloatParameterData(String parameterKey) {
        return ((Float)this.scenarioParameters.get(parameterKey)).floatValue();
    }

    public double getDoubleParameterData(String parameterKey) {
        return (Double)this.scenarioParameters.get(parameterKey);
    }

    public Date getDateParameterData(String parameterKey) {
        return (Date)this.scenarioParameters.get(parameterKey);
    }

    public String getStringParameterData(String parameterKey) {
        return this.scenarioParameters.get(parameterKey).toString();
    }

    private boolean ParameterDataTypeIsSupported(Class<?> clazz) {
        return SUPPORTED_TYPES.contains(clazz);
    }

    private static Set<Class<?>> getSupportedDataTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(String.class);
        ret.add(Date.class);
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Scenario [name=").append(this.scenarioFullName).append("]");
        return builder.toString();
    }

    public String getParameters() {
        Object[] list = this.scenarioParameters.values().toArray(new String[this.scenarioParameters.size()]);
        return Arrays.toString(list);
    }
}

