/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringHighlighter
extends Highlighter {
    private String start;
    private String escape;
    private boolean doubleEscapes;

    StringHighlighter(Params params) {
        this.start = params.getParam("string");
        this.escape = params.getParam("escape", null);
        this.doubleEscapes = params.isSet("doubleEscapes");
    }

    @Override
    boolean startsWith(CharIter charIter) {
        return charIter.startsWith(this.start);
    }

    @Override
    boolean highlight(CharIter charIter, List<Block> list) {
        charIter.moveNext(this.start.length());
        boolean bl = false;
        while (!charIter.finished()) {
            if (charIter.startsWith(this.start) && !bl) {
                if (!this.doubleEscapes || !charIter.startsWith(this.start, this.start.length())) break;
                charIter.moveNext();
            } else {
                bl = this.escape != null && charIter.startsWith(this.escape) && !bl;
            }
            charIter.moveNext();
        }
        if (!charIter.finished()) {
            charIter.moveNext();
        }
        list.add(charIter.markedToStyledBlock("string"));
        return true;
    }
}

