/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.Params;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OnelineCommentHighlighter
extends Highlighter {
    private String start;

    OnelineCommentHighlighter(Params params) {
        this.start = params.getParam();
    }

    @Override
    boolean startsWith(CharIter charIter) {
        return charIter.startsWith(this.start);
    }

    @Override
    boolean highlight(CharIter charIter, List<Block> list) {
        charIter.moveNext(this.start.length());
        int n = charIter.indexOf("\n");
        if (n == -1) {
            charIter.moveToEnd();
        } else {
            charIter.moveNext(n);
            if (charIter.prev().equals(Character.valueOf('\r'))) {
                charIter.moveNext(-1);
            }
        }
        list.add(charIter.markedToStyledBlock("comment"));
        return true;
    }
}

