package com.agilejava.docbkx.maven;

import javax.xml.transform.URIResolver;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import java.io.File;
import java.util.List;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Target;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;


/**
 * A Maven plugin for generating fo output from DocBook documents, using version
 * 1.76.1 of the DocBook XSL stylesheets.
 *
 * @see http://docbook.sourceforge.net/
 * @goal generate-pdf
 * @configurator override
 */
public class DocbkxPdfMojo
  extends com.agilejava.docbkx.maven.AbstractFoMojo
{

    /**
     * The plugin dependencies.
     *
     * @parameter expression="${plugin.artifacts}"
     * @required
     * @readonly
     */
    List artifacts;

    /**
     * Ant tasks to be executed before the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     *
     * @parameter
     */
    private Target preProcess;

    /**
     * Ant tasks to be executed after the transformation. Comparable
     * to the tasks property in the maven-antrun-plugin.
     *
     * @parameter
     */
    private Target postProcess;

    /**
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    private MavenProject project;

    /**
     * A list of entities to be substituted in the source
     * documents. Note that you can <em>only</em> specify entities if
     * your source DocBook document contains a DTD
     * declaration. Otherwise it will not have any effect at all.
     *
     * @parameter
     */
    private List entities;

    /**
     * A list of additional XSL parameters to give to the XSLT engine.
     * These parameters overrides regular docbook ones as they are last
     * configured.<br/>
     * For regular docbook parameters perfer the use of this plugin facilities
     * offering nammed paramters.<br/>
     * These parameters feet well for custom properties you may have defined
     * within your customization layer.
     *
     * @parameter
     */
    private List customizationParameters = new ArrayList();

    /**
     * List of additional System properties.
     *
     * @parameter
     */
    private Properties systemProperties;

    /**
     * The pattern of the files to be included.
     *
     * @parameter default-value="*.xml"
     */
    private String includes;

    /**
     * A boolean, indicating if XInclude should be supported.
     *
     * @parameter default="false"
     */
     private boolean xincludeSupported;

    /**
     * The location of the stylesheet customization.
     *
     * @parameter
     */
    private String foCustomization;

    /**
     * The extension of the target file name.
     *
     * @parameter default-value="pdf"
     */
    private String targetFileExtension;


    /**
     * The target directory to which all output will be written.
     *
     * @parameter expression="${basedir}/target/docbkx/pdf"
     */
    private File targetDirectory;

    /**
     * The directory containing the source DocBook files.
     *
     * @parameter expression="${basedir}/src/docbkx"
     */
    private File sourceDirectory;

    /**
     * The directory containing the resolved DocBook source before given to the transformer.
     *
     * @parameter
     */
    private File generatedSourceDirectory;

    private boolean useStandardOutput = true;

    /**
     * If the xslt engine should print the to standard output the xsl:messages.
     *
     * @parameter
     */
    private boolean showXslMessages = false;

    /**
     * 
     * (Original XSL attribuut: <code>passivetex.extensions</code>.)
     *
     * @parameter
     */  
    protected String passivetexExtensions;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.condition</code>.)
     *
     * @parameter
     */  
    protected String profileCondition;

    /**
     * In DocBook documents that conform to a schema older than V4.
     * (Original XSL attribuut: <code>use.role.as.xrefstyle</code>.)
     *
     * @parameter
     */  
    protected String useRoleAsXrefstyle;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.role</code>.)
     *
     * @parameter
     */  
    protected String profileRole;

    /**
     * Specifies the border color of table frames.
     * (Original XSL attribuut: <code>table.frame.border.color</code>.)
     *
     * @parameter
     */  
    protected String tableFrameBorderColor;

    /**
     * For compatibility with DSSSL based DBTeXMath from Allin Cottrell you should set this parameter to 0.
     * (Original XSL attribuut: <code>tex.math.delims</code>.)
     *
     * @parameter
     */  
    protected String texMathDelims;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.default.extension</code>.)
     *
     * @parameter
     */  
    protected String graphicDefaultExtension;

    /**
     * This parameter enables a very neat trick for getting properly merged, collated back-of-the-book indexes.
     * (Original XSL attribuut: <code>make.index.markup</code>.)
     *
     * @parameter
     */  
    protected String makeIndexMarkup;

    /**
     * 
     * (Original XSL attribuut: <code>part.autolabel</code>.)
     *
     * @parameter
     */  
    protected String partAutolabel;

    /**
     * The footnote font size is used for.
     * (Original XSL attribuut: <code>footnote.font.size</code>.)
     *
     * @parameter
     */  
    protected String footnoteFontSize;

    /**
     * If true, crop marks will be added to each page.
     * (Original XSL attribuut: <code>crop.marks</code>.)
     *
     * @parameter
     */  
    protected String cropMarks;

    /**
     * If the lines of program listing are too long to fit into one line it is quite common to split them at space and indicite by hook arrow that code continues on the next line.
     * (Original XSL attribuut: <code>hyphenate.verbatim</code>.)
     *
     * @parameter
     */  
    protected String hyphenateVerbatim;

    /**
     * 
     * (Original XSL attribuut: <code>ati.xsl11.bookmarks</code>.)
     *
     * @parameter
     */  
    protected String atiXsl11Bookmarks;

    /**
     * 
     * (Original XSL attribuut: <code>direction.align.end</code>.)
     *
     * @parameter
     */  
    protected String directionAlignEnd;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revision</code>.)
     *
     * @parameter
     */  
    protected String profileRevision;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.assignment</code>.)
     *
     * @parameter
     */  
    protected String ebnfAssignment;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.defaultlabel</code>.)
     *
     * @parameter
     */  
    protected String qandaDefaultlabel;

    /**
     * 
     * (Original XSL attribuut: <code>title.fontset</code>.)
     *
     * @parameter
     */  
    protected String titleFontset;

    /**
     * Select one from portrait or landscape.
     * (Original XSL attribuut: <code>page.orientation</code>.)
     *
     * @parameter
     */  
    protected String pageOrientation;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.format</code>.)
     *
     * @parameter
     */  
    protected String footnoteNumberFormat;

    /**
     * 
     * (Original XSL attribuut: <code>reference.autolabel</code>.)
     *
     * @parameter
     */  
    protected String referenceAutolabel;

    /**
     * The dingbat font family is used for dingbats.
     * (Original XSL attribuut: <code>dingbat.font.family</code>.)
     *
     * @parameter
     */  
    protected String dingbatFontFamily;

    /**
     * This parameter provides the means of adjusting the left margin for titles when the XSL-FO processor being used is an old version of FOP (0.
     * (Original XSL attribuut: <code>title.margin.left</code>.)
     *
     * @parameter
     */  
    protected String titleMarginLeft;

    /**
     * This language is used when there is no language attribute on programlisting.
     * (Original XSL attribuut: <code>highlight.default.language</code>.)
     *
     * @parameter
     */  
    protected String highlightDefaultLanguage;

    /**
     * A mediaobject may contain several objects such as imageobjects.
     * (Original XSL attribuut: <code>preferred.mediaobject.role</code>.)
     *
     * @parameter
     */  
    protected String preferredMediaobjectRole;

    /**
     * This parameter has a structured value.
     * (Original XSL attribuut: <code>generate.toc</code>.)
     *
     * @parameter
     */  
    protected String generateToc;

    /**
     * This parameter lets you select which method to use for sorting and grouping  index entries in an index.
     * (Original XSL attribuut: <code>index.method</code>.)
     *
     * @parameter
     */  
    protected String indexMethod;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.pdf.frag</code>.)
     *
     * @parameter
     */  
    protected String insertOlinkPdfFrag;

    /**
     * The name of the font to specify around Unicode callout glyphs.
     * (Original XSL attribuut: <code>callout.unicode.font</code>.)
     *
     * @parameter
     */  
    protected String calloutUnicodeFont;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.type</code>.)
     *
     * @parameter
     */  
    protected String indexOnType;

    /**
     * 
     * (Original XSL attribuut: <code>email.mailto.enabled</code>.)
     *
     * @parameter
     */  
    protected String emailMailtoEnabled;

    /**
     * String used to separate labels and titles in a table of contents.
     * (Original XSL attribuut: <code>autotoc.label.separator</code>.)
     *
     * @parameter
     */  
    protected String autotocLabelSeparator;

    /**
     * In order to convert CALS column widths into HTML column widths, it is sometimes necessary to have an absolute table width to use for conversion of mixed absolute and relative widths.
     * (Original XSL attribuut: <code>nominal.table.width</code>.)
     *
     * @parameter
     */  
    protected String nominalTableWidth;

    /**
     * Specifies the default width of the label (usually a bullet or other symbol) in an itemized list.
     * (Original XSL attribuut: <code>itemizedlist.label.width</code>.)
     *
     * @parameter
     */  
    protected String itemizedlistLabelWidth;

    /**
     * 
     * (Original XSL attribuut: <code>marker.section.level</code>.)
     *
     * @parameter
     */  
    protected String markerSectionLevel;

    /**
     * 
     * (Original XSL attribuut: <code>kimber.imported</code>.)
     *
     * @parameter
     */  
    protected String kimberImported;

    /**
     * When olinks between documents are resolved, the generated text may not make it clear that the reference is to another document.
     * (Original XSL attribuut: <code>olink.doctitle</code>.)
     *
     * @parameter
     */  
    protected String olinkDoctitle;

    /**
     * 
     * (Original XSL attribuut: <code>insert.xref.page.number</code>.)
     *
     * @parameter
     */  
    protected String insertXrefPageNumber;

    /**
     * The region before extent is the height of the area where headers are printed.
     * (Original XSL attribuut: <code>region.before.extent</code>.)
     *
     * @parameter
     */  
    protected String regionBeforeExtent;

    /**
     * Sets the line-height property.
     * (Original XSL attribuut: <code>line-height</code>.)
     *
     * @parameter
     */  
    protected String lineHeight;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.alt.primary.seps</code>.)
     *
     * @parameter
     */  
    protected String biblioentryAltPrimarySeps;

    /**
     * 
     * (Original XSL attribuut: <code>space.emquad.width</code>.)
     *
     * @parameter
     */  
    protected String spaceEmquadWidth;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.break.after</code>.)
     *
     * @parameter
     */  
    protected String variablelistTermBreakAfter;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.as.blocks</code>.)
     *
     * @parameter
     */  
    protected String variablelistAsBlocks;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.footnotes</code>.)
     *
     * @parameter
     */  
    protected String ulinkFootnotes;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.notations</code>.)
     *
     * @parameter
     */  
    protected String graphicNotations;

    /**
     * If true, comments will be displayed, otherwise they are suppressed.
     * (Original XSL attribuut: <code>show.comments</code>.)
     *
     * @parameter
     */  
    protected String showComments;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.os</code>.)
     *
     * @parameter
     */  
    protected String profileOs;

    /**
     * Specifies the border style of table frames.
     * (Original XSL attribuut: <code>table.frame.border.style</code>.)
     *
     * @parameter
     */  
    protected String tableFrameBorderStyle;

    /**
     * 
     * (Original XSL attribuut: <code>callout.graphics.number.limit</code>.)
     *
     * @parameter
     */  
    protected String calloutGraphicsNumberLimit;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.item.separator</code>.)
     *
     * @parameter
     */  
    protected String biblioentryItemSeparator;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.title-page.separator</code>.)
     *
     * @parameter
     */  
    protected String xrefTitlePageSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.index</code>.)
     *
     * @parameter
     */  
    protected String columnGapIndex;

    /**
     * If true, headers will be placed on blank pages.
     * (Original XSL attribuut: <code>headers.on.blank.pages</code>.)
     *
     * @parameter
     */  
    protected String headersOnBlankPages;

    /**
     * The table columns extension function adjusts the widths of table columns in the HTML result to more accurately reflect the specifications in the CALS table.
     * (Original XSL attribuut: <code>tablecolumns.extension</code>.)
     *
     * @parameter
     */  
    protected String tablecolumnsExtension;

    /**
     * When cross reference data is collected for resolving olinks, it may be necessary to prepend a base URI to each target's href.
     * (Original XSL attribuut: <code>olink.base.uri</code>.)
     *
     * @parameter
     */  
    protected String olinkBaseUri;

    /**
     * If true, footers will be placed on blank pages.
     * (Original XSL attribuut: <code>footers.on.blank.pages</code>.)
     *
     * @parameter
     */  
    protected String footersOnBlankPages;

    /**
     * Value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.audience</code>.)
     *
     * @parameter
     */  
    protected String profileAudience;

    /**
     * 
     * (Original XSL attribuut: <code>email.delimiters.enabled</code>.)
     *
     * @parameter
     */  
    protected String emailDelimitersEnabled;

    /**
     * 
     * (Original XSL attribuut: <code>body.font.size</code>.)
     *
     * @parameter
     */  
    protected String bodyFontSize;

    /**
     * If you want type math directly in TeX notation in equations, this parameter specifies notation used.
     * (Original XSL attribuut: <code>tex.math.in.alt</code>.)
     *
     * @parameter
     */  
    protected String texMathInAlt;

    /**
     * Specifies the size of the callout marker icons.
     * (Original XSL attribuut: <code>callout.icon.size</code>.)
     *
     * @parameter
     */  
    protected String calloutIconSize;

    /**
     * 
     * (Original XSL attribuut: <code>space.hairspace.width</code>.)
     *
     * @parameter
     */  
    protected String spaceHairspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>section.autolabel.max.depth</code>.)
     *
     * @parameter
     */  
    protected String sectionAutolabelMaxDepth;

    /**
     * Specifies, in points, the distance by which each level of the TOC is indented from its parent.
     * (Original XSL attribuut: <code>toc.indent.width</code>.)
     *
     * @parameter
     */  
    protected String tocIndentWidth;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.arch</code>.)
     *
     * @parameter
     */  
    protected String profileArch;

    /**
     * This parameter specifies the list of elements that should be escaped as CDATA sections by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.cdata-section-elements</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputCdataSectionElements;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.conformance</code>.)
     *
     * @parameter
     */  
    protected String profileConformance;

    /**
     * Sets the default width for sidebars when used as a side float.
     * (Original XSL attribuut: <code>sidebar.float.width</code>.)
     *
     * @parameter
     */  
    protected String sidebarFloatWidth;

    /**
     * 
     * (Original XSL attribuut: <code>direction.mode</code>.)
     *
     * @parameter
     */  
    protected String directionMode;

    /**
     * 
     * (Original XSL attribuut: <code>refclass.suppress</code>.)
     *
     * @parameter
     */  
    protected String refclassSuppress;

    /**
     * This parameter specifies the public identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-public</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputDoctypePublic;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.front</code>.)
     *
     * @parameter
     */  
    protected String columnGapFront;

    /**
     * 
     * (Original XSL attribuut: <code>space.enspace.width</code>.)
     *
     * @parameter
     */  
    protected String spaceEnspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.xml</code>.)
     *
     * @parameter
     */  
    protected String l10nXml;

    /**
     * The portrait page height is the length of the long edge of the physical page.
     * (Original XSL attribuut: <code>page.height.portrait</code>.)
     *
     * @parameter
     */  
    protected String pageHeightPortrait;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    protected String tableFootnoteNumberSymbols;

    /**
     * This parameter specifies the encoding to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.encoding</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputEncoding;

    /**
     * If true (true), unlabeled sections will be enumerated.
     * (Original XSL attribuut: <code>section.autolabel</code>.)
     *
     * @parameter
     */  
    protected String sectionAutolabel;

    /**
     * The body top margin is the distance from the top of the region-before to the first line of text in the page body.
     * (Original XSL attribuut: <code>body.margin.top</code>.)
     *
     * @parameter
     */  
    protected String bodyMarginTop;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.titlepage</code>.)
     *
     * @parameter
     */  
    protected String columnGapTitlepage;

    /**
     * 
     * (Original XSL attribuut: <code>glossterm.auto.link</code>.)
     *
     * @parameter
     */  
    protected String glosstermAutoLink;

    /**
     * Sets the default width for margin notes when used as a side float.
     * (Original XSL attribuut: <code>margin.note.width</code>.)
     *
     * @parameter
     */  
    protected String marginNoteWidth;

    /**
     * 
     * (Original XSL attribuut: <code>get</code>.)
     *
     * @parameter
     */  
    protected String get;

    /**
     * 
     * (Original XSL attribuut: <code>space.punctspace.width</code>.)
     *
     * @parameter
     */  
    protected String spacePunctspaceWidth;

    /**
     * This parameter specifies the width reserved for glossary terms when a list presentation is used.
     * (Original XSL attribuut: <code>glossterm.width</code>.)
     *
     * @parameter
     */  
    protected String glosstermWidth;

    /**
     * 
     * (Original XSL attribuut: <code>simplesect.in.toc</code>.)
     *
     * @parameter
     */  
    protected String simplesectInToc;

    /**
     * 
     * (Original XSL attribuut: <code>column.count.titlepage</code>.)
     *
     * @parameter
     */  
    protected String columnCountTitlepage;

    /**
     * This parameter specifies the value of the omit-xml-declaration specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.omit-xml-declaration</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputOmitXmlDeclaration;

    /**
     * This parameter specifies the punctuation that should be added after an honorific in a personal name.
     * (Original XSL attribuut: <code>punct.honorific</code>.)
     *
     * @parameter
     */  
    protected String punctHonorific;

    /**
     * The top page margin is the distance from the physical top of the page to the top of the region-before.
     * (Original XSL attribuut: <code>page.margin.top</code>.)
     *
     * @parameter
     */  
    protected String pageMarginTop;

    /**
     * If true, the scaling attributes on graphics and media objects are ignored.
     * (Original XSL attribuut: <code>ignore.image.scaling</code>.)
     *
     * @parameter
     */  
    protected String ignoreImageScaling;

    /**
     * 
     * (Original XSL attribuut: <code>appendix.autolabel</code>.)
     *
     * @parameter
     */  
    protected String appendixAutolabel;

    /**
     * This parameter permits you to override the text to insert between the end of an index term and its list of page references.
     * (Original XSL attribuut: <code>index.term.separator</code>.)
     *
     * @parameter
     */  
    protected String indexTermSeparator;

    /**
     * If true, the bookmark tree is collapsed so that only the  top-level bookmarks are displayed initially.
     * (Original XSL attribuut: <code>bookmarks.collapse</code>.)
     *
     * @parameter
     */  
    protected String bookmarksCollapse;

    /**
     * This parameter specifies the media type that should be used by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.media-type</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputMediaType;

    /**
     * 
     * (Original XSL attribuut: <code>segmentedlist.as.table</code>.)
     *
     * @parameter
     */  
    protected String segmentedlistAsTable;

    /**
     * This parameter specifies the value of the indent specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.indent</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputIndent;

    /**
     * If true, words may be hyphenated.
     * (Original XSL attribuut: <code>hyphenate</code>.)
     *
     * @parameter
     */  
    protected String hyphenate;

    /**
     * 
     * (Original XSL attribuut: <code>margin.left.inner</code>.)
     *
     * @parameter
     */  
    protected String marginLeftInner;

    /**
     * This value will be used when there is no frame attribute on the table.
     * (Original XSL attribuut: <code>default.table.frame</code>.)
     *
     * @parameter
     */  
    protected String defaultTableFrame;

    /**
     * Glossaries maintained independently across a set of documents are likely to become inconsistent unless considerable effort is expended to keep them in sync.
     * (Original XSL attribuut: <code>glossary.collection</code>.)
     *
     * @parameter
     */  
    protected String glossaryCollection;

    /**
     * The inner page margin is the distance from bound edge of the page to the first column of text.
     * (Original XSL attribuut: <code>page.margin.inner</code>.)
     *
     * @parameter
     */  
    protected String pageMarginInner;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.menu.separator</code>.)
     *
     * @parameter
     */  
    protected String menuchoiceMenuSeparator;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.security</code>.)
     *
     * @parameter
     */  
    protected String profileSecurity;

    /**
     * 
     * (Original XSL attribuut: <code>chapter.autolabel</code>.)
     *
     * @parameter
     */  
    protected String chapterAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>biblioentry.primary.count</code>.)
     *
     * @parameter
     */  
    protected String biblioentryPrimaryCount;

    /**
     * Specifies where formal object titles should occur.
     * (Original XSL attribuut: <code>formal.title.placement</code>.)
     *
     * @parameter
     */  
    protected String formalTitlePlacement;

    /**
     * 
     * (Original XSL attribuut: <code>chunker.output.quiet</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputQuiet;

    /**
     * Maintaining bibliography entries across a set of documents is tedious, time consuming, and error prone.
     * (Original XSL attribuut: <code>bibliography.collection</code>.)
     *
     * @parameter
     */  
    protected String bibliographyCollection;

    /**
     * This parameter permits you to override the text to insert between the two numbers of a page range in an index.
     * (Original XSL attribuut: <code>index.range.separator</code>.)
     *
     * @parameter
     */  
    protected String indexRangeSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>shade.verbatim</code>.)
     *
     * @parameter
     */  
    protected String shadeVerbatim;

    /**
     * If line numbering is enabled, line numbers will appear right justified in a field "width" characters wide.
     * (Original XSL attribuut: <code>linenumbering.width</code>.)
     *
     * @parameter
     */  
    protected String linenumberingWidth;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.gentext.default.language</code>.)
     *
     * @parameter
     */  
    protected String l10nGentextDefaultLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.generate.name</code>.)
     *
     * @parameter
     */  
    protected String refentryGenerateName;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.hyphenate</code>.)
     *
     * @parameter
     */  
    protected String ulinkHyphenate;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-title.separator</code>.)
     *
     * @parameter
     */  
    protected String xrefLabelTitleSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.term.separator</code>.)
     *
     * @parameter
     */  
    protected String variablelistTermSeparator;

    /**
     * Page headers in print output use a three column table to position text at the left, center, and right side of the header on the page.
     * (Original XSL attribuut: <code>header.column.widths</code>.)
     *
     * @parameter
     */  
    protected String headerColumnWidths;

    /**
     * The default sans-serif font family.
     * (Original XSL attribuut: <code>sans.font.family</code>.)
     *
     * @parameter
     */  
    protected String sansFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.inherit.numeration</code>.)
     *
     * @parameter
     */  
    protected String qandaInheritNumeration;

    /**
     * 
     * (Original XSL attribuut: <code>callout.defaultcolumn</code>.)
     *
     * @parameter
     */  
    protected String calloutDefaultcolumn;

    /**
     * 
     * (Original XSL attribuut: <code>space.enquad.width</code>.)
     *
     * @parameter
     */  
    protected String spaceEnquadWidth;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.revisionflag</code>.)
     *
     * @parameter
     */  
    protected String profileRevisionflag;

    /**
     * 
     * (Original XSL attribuut: <code>procedure.step.numeration.formats</code>.)
     *
     * @parameter
     */  
    protected String procedureStepNumerationFormats;

    /**
     * 
     * (Original XSL attribuut: <code>rootid</code>.)
     *
     * @parameter
     */  
    protected String rootid;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.xref.manvolnum</code>.)
     *
     * @parameter
     */  
    protected String refentryXrefManvolnum;

    /**
     * Number of columns on body pages.
     * (Original XSL attribuut: <code>column.count.body</code>.)
     *
     * @parameter
     */  
    protected String columnCountBody;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>collect.xref.targets</code>.)
     *
     * @parameter
     */  
    protected String collectXrefTargets;

    /**
     * If true, year ranges that span a single year will be printed in range notation (1998-1999) instead of discrete notation (1998, 1999).
     * (Original XSL attribuut: <code>make.single.year.ranges</code>.)
     *
     * @parameter
     */  
    protected String makeSingleYearRanges;

    /**
     * This end-indent property is added to the fo:flow for certain page sequences.
     * (Original XSL attribuut: <code>body.end.indent</code>.)
     *
     * @parameter
     */  
    protected String bodyEndIndent;

    /**
     * 
     * (Original XSL attribuut: <code>stylesheet.result.type</code>.)
     *
     * @parameter
     */  
    protected String stylesheetResultType;

    /**
     * Length of crop marks.
     * (Original XSL attribuut: <code>crop.mark.offset</code>.)
     *
     * @parameter
     */  
    protected String cropMarkOffset;

    /**
     * This parameter provides the means of indenting the body text relative to section titles.
     * (Original XSL attribuut: <code>body.start.indent</code>.)
     *
     * @parameter
     */  
    protected String bodyStartIndent;

    /**
     * This parameter permits you to override the text to insert between page references in a formatted index entry.
     * (Original XSL attribuut: <code>index.number.separator</code>.)
     *
     * @parameter
     */  
    protected String indexNumberSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.start.character</code>.)
     *
     * @parameter
     */  
    protected String calloutUnicodeStartCharacter;

    /**
     * 
     * (Original XSL attribuut: <code>l10n.lang.value.rfc.compliant</code>.)
     *
     * @parameter
     */  
    protected String l10nLangValueRfcCompliant;

    /**
     * 
     * (Original XSL attribuut: <code>fop.extensions</code>.)
     *
     * @parameter
     */  
    protected String fopExtensions;

    /**
     * Double-sided documents are printed with a slightly wider margin on the binding edge of the page.
     * (Original XSL attribuut: <code>double.sided</code>.)
     *
     * @parameter
     */  
    protected String doubleSided;

    /**
     * Number of columns on index pages.
     * (Original XSL attribuut: <code>column.count.index</code>.)
     *
     * @parameter
     */  
    protected String columnCountIndex;

    /**
     * This parameter allows you to control the punctuation of certain types of generated cross reference text.
     * (Original XSL attribuut: <code>xref.label-page.separator</code>.)
     *
     * @parameter
     */  
    protected String xrefLabelPageSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>process.empty.source.toc</code>.)
     *
     * @parameter
     */  
    protected String processEmptySourceToc;

    /**
     * 
     * (Original XSL attribuut: <code>axf.extensions</code>.)
     *
     * @parameter
     */  
    protected String axfExtensions;

    /**
     * 
     * (Original XSL attribuut: <code>space.6emspace.width</code>.)
     *
     * @parameter
     */  
    protected String space6emspaceWidth;

    /**
     * This location has precedence over the corresponding Java property.
     * (Original XSL attribuut: <code>highlight.xslthl.config</code>.)
     *
     * @parameter
     */  
    protected String highlightXslthlConfig;

    /**
     * 
     * (Original XSL attribuut: <code>space.thinspace.width</code>.)
     *
     * @parameter
     */  
    protected String spaceThinspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>highlight.source</code>.)
     *
     * @parameter
     */  
    protected String highlightSource;

    /**
     * If true, a rule will be drawn above the page footers.
     * (Original XSL attribuut: <code>footer.rule</code>.)
     *
     * @parameter
     */  
    protected String footerRule;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.generate.title</code>.)
     *
     * @parameter
     */  
    protected String refentryGenerateTitle;

    /**
     * Sets the path to the directory holding the callout graphics.
     * (Original XSL attribuut: <code>callout.graphics.path</code>.)
     *
     * @parameter
     */  
    protected String calloutGraphicsPath;

    /**
     * Number of columns on front matter (dedication, preface, etc.
     * (Original XSL attribuut: <code>column.count.front</code>.)
     *
     * @parameter
     */  
    protected String columnCountFront;

    /**
     * 
     * (Original XSL attribuut: <code>direction.align.start</code>.)
     *
     * @parameter
     */  
    protected String directionAlignStart;

    /**
     * The bottom page margin is the distance from the bottom of the region-after to the physical bottom of the page.
     * (Original XSL attribuut: <code>page.margin.bottom</code>.)
     *
     * @parameter
     */  
    protected String pageMarginBottom;

    /**
     * This parameter specifies the output method to be used in files generated by the chunking stylesheet.
     * (Original XSL attribuut: <code>chunker.output.method</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputMethod;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.in.toc</code>.)
     *
     * @parameter
     */  
    protected String qandaInToc;

    /**
     * If true, then the glossentry elements within a glossary, glossdiv, or glosslist are sorted on the glossterm, using the current lang setting.
     * (Original XSL attribuut: <code>glossary.sort</code>.)
     *
     * @parameter
     */  
    protected String glossarySort;

    /**
     * Sets the filename extension to use on callout graphics.
     * (Original XSL attribuut: <code>callout.graphics.extension</code>.)
     *
     * @parameter
     */  
    protected String calloutGraphicsExtension;

    /**
     * 
     * (Original XSL attribuut: <code>footnote.number.symbols</code>.)
     *
     * @parameter
     */  
    protected String footnoteNumberSymbols;

    /**
     * 
     * (Original XSL attribuut: <code>bridgehead.in.toc</code>.)
     *
     * @parameter
     */  
    protected String bridgeheadInToc;

    /**
     * If line numbering is enabled, everyNth line will be numbered.
     * (Original XSL attribuut: <code>linenumbering.everyNth</code>.)
     *
     * @parameter
     */  
    protected String linenumberingEveryNth;

    /**
     * The body bottom margin is the distance from the last line of text in the page body to the bottom of the region-after.
     * (Original XSL attribuut: <code>body.margin.bottom</code>.)
     *
     * @parameter
     */  
    protected String bodyMarginBottom;

    /**
     * This parameter has effect only when Saxon 6 is used (version 6.
     * (Original XSL attribuut: <code>saxon.character.representation</code>.)
     *
     * @parameter
     */  
    protected String saxonCharacterRepresentation;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.style</code>.)
     *
     * @parameter
     */  
    protected String funcsynopsisStyle;

    /**
     * 
     * (Original XSL attribuut: <code>glossary.as.blocks</code>.)
     *
     * @parameter
     */  
    protected String glossaryAsBlocks;

    /**
     * Specify if an index should be generated.
     * (Original XSL attribuut: <code>generate.index</code>.)
     *
     * @parameter
     */  
    protected String generateIndex;

    /**
     * 
     * (Original XSL attribuut: <code>empty.local.l10n.xml</code>.)
     *
     * @parameter
     */  
    protected String emptyLocalL10nXml;

    /**
     * If true, the language of the target will be used when generating cross reference text.
     * (Original XSL attribuut: <code>l10n.gentext.use.xref.language</code>.)
     *
     * @parameter
     */  
    protected String l10nGentextUseXrefLanguage;

    /**
     * This parameter defines a list of lang values to search among to resolve olinks.
     * (Original XSL attribuut: <code>olink.lang.fallback.sequence</code>.)
     *
     * @parameter
     */  
    protected String olinkLangFallbackSequence;

    /**
     * 
     * (Original XSL attribuut: <code>author.othername.in.middle</code>.)
     *
     * @parameter
     */  
    protected String authorOthernameInMiddle;

    /**
     * Number of columns on back matter (appendix, glossary, etc.
     * (Original XSL attribuut: <code>column.count.back</code>.)
     *
     * @parameter
     */  
    protected String columnCountBack;

    /**
     * 
     * (Original XSL attribuut: <code>menuchoice.separator</code>.)
     *
     * @parameter
     */  
    protected String menuchoiceSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>make.year.ranges</code>.)
     *
     * @parameter
     */  
    protected String makeYearRanges;

    /**
     * If this parameter is set to any value other than the empty string, its value will be used as the value for the language when generating text.
     * (Original XSL attribuut: <code>l10n.gentext.language</code>.)
     *
     * @parameter
     */  
    protected String l10nGentextLanguage;

    /**
     * 
     * (Original XSL attribuut: <code>default.units</code>.)
     *
     * @parameter
     */  
    protected String defaultUnits;

    /**
     * 
     * (Original XSL attribuut: <code>body.fontset</code>.)
     *
     * @parameter
     */  
    protected String bodyFontset;

    /**
     * If true, extensions may be used.
     * (Original XSL attribuut: <code>use.extensions</code>.)
     *
     * @parameter
     */  
    protected String useExtensions;

    /**
     * Specify which characters are to be counted as punctuation.
     * (Original XSL attribuut: <code>runinhead.title.end.punct</code>.)
     *
     * @parameter
     */  
    protected String runinheadTitleEndPunct;

    /**
     * If true, then each olink will generate several messages about how it is being resolved during processing.
     * (Original XSL attribuut: <code>olink.debug</code>.)
     *
     * @parameter
     */  
    protected String olinkDebug;

    /**
     * 
     * (Original XSL attribuut: <code>local.l10n.xml</code>.)
     *
     * @parameter
     */  
    protected String localL10nXml;

    /**
     * 
     * (Original XSL attribuut: <code>xref.with.number.and.title</code>.)
     *
     * @parameter
     */  
    protected String xrefWithNumberAndTitle;

    /**
     * Sets the path to the directory containing the admonition graphics (caution.
     * (Original XSL attribuut: <code>admon.graphics.path</code>.)
     *
     * @parameter
     */  
    protected String admonGraphicsPath;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.show</code>.)
     *
     * @parameter
     */  
    protected String ulinkShow;

    /**
     * 
     * (Original XSL attribuut: <code>glosslist.as.blocks</code>.)
     *
     * @parameter
     */  
    protected String glosslistAsBlocks;

    /**
     * The title font family is used for titles (chapter, section, figure, etc.
     * (Original XSL attribuut: <code>title.font.family</code>.)
     *
     * @parameter
     */  
    protected String titleFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>table.footnote.number.format</code>.)
     *
     * @parameter
     */  
    protected String tableFootnoteNumberFormat;

    /**
     * Specifies with em units the width of a single character of the monospace font.
     * (Original XSL attribuut: <code>monospace.verbatim.font.width</code>.)
     *
     * @parameter
     */  
    protected String monospaceVerbatimFontWidth;

    /**
     * 
     * (Original XSL attribuut: <code>hyphenate.verbatim.characters</code>.)
     *
     * @parameter
     */  
    protected String hyphenateVerbatimCharacters;

    /**
     * 
     * (Original XSL attribuut: <code>default.image.width</code>.)
     *
     * @parameter
     */  
    protected String defaultImageWidth;

    /**
     * If true, a rule will be drawn below the page headers.
     * (Original XSL attribuut: <code>header.rule</code>.)
     *
     * @parameter
     */  
    protected String headerRule;

    /**
     * 
     * (Original XSL attribuut: <code>preface.autolabel</code>.)
     *
     * @parameter
     */  
    protected String prefaceAutolabel;

    /**
     * A typical body or title font does not contain all the character glyphs that DocBook supports.
     * (Original XSL attribuut: <code>symbol.font.family</code>.)
     *
     * @parameter
     */  
    protected String symbolFontFamily;

    /**
     * When olinks between documents are resolved for HTML output, the stylesheet can compute the relative path between the current document and the target document.
     * (Original XSL attribuut: <code>current.docid</code>.)
     *
     * @parameter
     */  
    protected String currentDocid;

    /**
     * The outer page margin is the distance from non-bound edge of the page to the outer edge of the last column of text.
     * (Original XSL attribuut: <code>page.margin.outer</code>.)
     *
     * @parameter
     */  
    protected String pageMarginOuter;

    /**
     * If you are re-using XML content modules in multiple documents, you may want to redirect some of your olinks.
     * (Original XSL attribuut: <code>prefer.internal.olink</code>.)
     *
     * @parameter
     */  
    protected String preferInternalOlink;

    /**
     * If true, SVG will be considered an acceptable image format.
     * (Original XSL attribuut: <code>use.svg</code>.)
     *
     * @parameter
     */  
    protected String useSvg;

    /**
     * 
     * (Original XSL attribuut: <code>profile.attribute</code>.)
     *
     * @parameter
     */  
    protected String profileAttribute;

    /**
     * Specifies the maximal depth of TOC on all levels.
     * (Original XSL attribuut: <code>toc.max.depth</code>.)
     *
     * @parameter
     */  
    protected String tocMaxDepth;

    /**
     * To resolve olinks between documents, the stylesheets use a master database document that identifies the target datafiles for all the documents within the scope of the olinks.
     * (Original XSL attribuut: <code>target.database.document</code>.)
     *
     * @parameter
     */  
    protected String targetDatabaseDocument;

    /**
     * Sets the filename extension to use on admonition graphics.
     * (Original XSL attribuut: <code>admon.graphics.extension</code>.)
     *
     * @parameter
     */  
    protected String admonGraphicsExtension;

    /**
     * Width of crop marks.
     * (Original XSL attribuut: <code>crop.mark.width</code>.)
     *
     * @parameter
     */  
    protected String cropMarkWidth;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.numbered</code>.)
     *
     * @parameter
     */  
    protected String bibliographyNumbered;

    /**
     * Page headers in print output use a three column table to position text at the left, center, and right side of the header on the page.
     * (Original XSL attribuut: <code>header.table.height</code>.)
     *
     * @parameter
     */  
    protected String headerTableHeight;

    /**
     * The textinsert extension element inserts the contents of       a file into the result tree (as text).
     * (Original XSL attribuut: <code>textinsert.extension</code>.)
     *
     * @parameter
     */  
    protected String textinsertExtension;

    /**
     * Selects the element name for outer container of each section.
     * (Original XSL attribuut: <code>section.container.element</code>.)
     *
     * @parameter
     */  
    protected String sectionContainerElement;

    /**
     * 
     * (Original XSL attribuut: <code>arbortext.extensions</code>.)
     *
     * @parameter
     */  
    protected String arbortextExtensions;

    /**
     * Length of invisible part of crop marks.
     * (Original XSL attribuut: <code>crop.mark.bleed</code>.)
     *
     * @parameter
     */  
    protected String cropMarkBleed;

    /**
     * Page footers in print output use a three column table to position text at the left, center, and right side of the footer on the page.
     * (Original XSL attribuut: <code>footer.table.height</code>.)
     *
     * @parameter
     */  
    protected String footerTableHeight;

    /**
     * 
     * (Original XSL attribuut: <code>variablelist.max.termlength</code>.)
     *
     * @parameter
     */  
    protected String variablelistMaxTermlength;

    /**
     * 
     * (Original XSL attribuut: <code>default.table.width</code>.)
     *
     * @parameter
     */  
    protected String defaultTableWidth;

    /**
     * This parameter specifies the system identifier that should be used by the chunking stylesheet in the document type declaration of chunked pages.
     * (Original XSL attribuut: <code>chunker.output.doctype-system</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputDoctypeSystem;

    /**
     * 
     * (Original XSL attribuut: <code>default.table.rules</code>.)
     *
     * @parameter
     */  
    protected String defaultTableRules;

    /**
     * Specifies the depth to which recursive sections should appear in the TOC.
     * (Original XSL attribuut: <code>toc.section.depth</code>.)
     *
     * @parameter
     */  
    protected String tocSectionDepth;

    /**
     * Selects the type of float for sidebar elements.
     * (Original XSL attribuut: <code>sidebar.float.type</code>.)
     *
     * @parameter
     */  
    protected String sidebarFloatType;

    /**
     * Sets direction of text flow and text alignment based on locale.
     * (Original XSL attribuut: <code>writing.mode</code>.)
     *
     * @parameter
     */  
    protected String writingMode;

    /**
     * The stylesheets can use either an image of the numbers one to ten, or the single Unicode character which represents the numeral, in white on a black background.
     * (Original XSL attribuut: <code>callout.unicode</code>.)
     *
     * @parameter
     */  
    protected String calloutUnicode;

    /**
     * 
     * (Original XSL attribuut: <code>space.figspace.width</code>.)
     *
     * @parameter
     */  
    protected String spaceFigspaceWidth;

    /**
     * The paper type is a convenient way to specify the paper size.
     * (Original XSL attribuut: <code>paper.type</code>.)
     *
     * @parameter
     */  
    protected String paperType;

    /**
     * 
     * (Original XSL attribuut: <code>textdata.default.encoding</code>.)
     *
     * @parameter
     */  
    protected String textdataDefaultEncoding;

    /**
     * If true (true), admonitions are presented in an alternate style that uses a graphic.
     * (Original XSL attribuut: <code>admon.graphics</code>.)
     *
     * @parameter
     */  
    protected String admonGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.back</code>.)
     *
     * @parameter
     */  
    protected String columnGapBack;

    /**
     * 
     * (Original XSL attribuut: <code>space.emspace.width</code>.)
     *
     * @parameter
     */  
    protected String spaceEmspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>runinhead.default.title.end.punct</code>.)
     *
     * @parameter
     */  
    protected String runinheadDefaultTitleEndPunct;

    /**
     * The portrait page width is the length of the short edge of the physical page.
     * (Original XSL attribuut: <code>page.width.portrait</code>.)
     *
     * @parameter
     */  
    protected String pageWidthPortrait;

    /**
     * 
     * (Original XSL attribuut: <code>glossentry.show.acronym</code>.)
     *
     * @parameter
     */  
    protected String glossentryShowAcronym;

    /**
     * The monospace font family is used for verbatim environments (program listings, screens, etc.
     * (Original XSL attribuut: <code>monospace.font.family</code>.)
     *
     * @parameter
     */  
    protected String monospaceFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>glossterm.separation</code>.)
     *
     * @parameter
     */  
    protected String glosstermSeparation;

    /**
     * 
     * (Original XSL attribuut: <code>use.role.for.mediaobject</code>.)
     *
     * @parameter
     */  
    protected String useRoleForMediaobject;

    /**
     * If true, section labels are prefixed with the label of the component that contains them.
     * (Original XSL attribuut: <code>section.label.includes.component.label</code>.)
     *
     * @parameter
     */  
    protected String sectionLabelIncludesComponentLabel;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.lot</code>.)
     *
     * @parameter
     */  
    protected String columnGapLot;

    /**
     * If true (true), admonitions are presented with a generated text label such as Note or Warning in the appropriate language.
     * (Original XSL attribuut: <code>admon.textlabel</code>.)
     *
     * @parameter
     */  
    protected String admonTextlabel;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.vendor</code>.)
     *
     * @parameter
     */  
    protected String profileVendor;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.status</code>.)
     *
     * @parameter
     */  
    protected String profileStatus;

    /**
     * 
     * (Original XSL attribuut: <code>index.on.role</code>.)
     *
     * @parameter
     */  
    protected String indexOnRole;

    /**
     * The image to be used for draft watermarks.
     * (Original XSL attribuut: <code>draft.watermark.image</code>.)
     *
     * @parameter
     */  
    protected String draftWatermarkImage;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.wordsize</code>.)
     *
     * @parameter
     */  
    protected String profileWordsize;

    /**
     * 
     * (Original XSL attribuut: <code>space.4emspace.width</code>.)
     *
     * @parameter
     */  
    protected String space4emspaceWidth;

    /**
     * 
     * (Original XSL attribuut: <code>qanda.nested.in.toc</code>.)
     *
     * @parameter
     */  
    protected String qandaNestedInToc;

    /**
     * 
     * (Original XSL attribuut: <code>graphic.extensions</code>.)
     *
     * @parameter
     */  
    protected String graphicExtensions;

    /**
     * 
     * (Original XSL attribuut: <code>page.height</code>.)
     *
     * @parameter
     */  
    protected String pageHeight;

    /**
     * Set the color of table cell borders.
     * (Original XSL attribuut: <code>table.cell.border.color</code>.)
     *
     * @parameter
     */  
    protected String tableCellBorderColor;

    /**
     * Number of columns on a page sequence containing the Table of Contents, List of Figures, etc.
     * (Original XSL attribuut: <code>column.count.lot</code>.)
     *
     * @parameter
     */  
    protected String columnCountLot;

    /**
     * The separator is inserted between line numbers and lines in the verbatim environment.
     * (Original XSL attribuut: <code>linenumbering.separator</code>.)
     *
     * @parameter
     */  
    protected String linenumberingSeparator;

    /**
     * Selects the direction in which a float should be placed.
     * (Original XSL attribuut: <code>default.float.class</code>.)
     *
     * @parameter
     */  
    protected String defaultFloatClass;

    /**
     * The body font family is the default font used for text in the page body.
     * (Original XSL attribuut: <code>body.font.family</code>.)
     *
     * @parameter
     */  
    protected String bodyFontFamily;

    /**
     * 
     * (Original XSL attribuut: <code>xep.extensions</code>.)
     *
     * @parameter
     */  
    protected String xepExtensions;

    /**
     * 
     * (Original XSL attribuut: <code>label.from.part</code>.)
     *
     * @parameter
     */  
    protected String labelFromPart;

    /**
     * 
     * (Original XSL attribuut: <code>page.width</code>.)
     *
     * @parameter
     */  
    protected String pageWidth;

    /**
     * 
     * (Original XSL attribuut: <code>bibliography.style</code>.)
     *
     * @parameter
     */  
    protected String bibliographyStyle;

    /**
     * Specifies the thickness of the border on the table's frame.
     * (Original XSL attribuut: <code>table.frame.border.thickness</code>.)
     *
     * @parameter
     */  
    protected String tableFrameBorderThickness;

    /**
     * If true, then the exsl:node-set() function is available to be used in the stylesheet.
     * (Original XSL attribuut: <code>exsl.node.set.available</code>.)
     *
     * @parameter
     */  
    protected String exslNodeSetAvailable;

    /**
     * Page footers in print output use a three column table to position text at the left, center, and right side of the footer on the page.
     * (Original XSL attribuut: <code>footer.column.widths</code>.)
     *
     * @parameter
     */  
    protected String footerColumnWidths;

    /**
     * The default text alignment is used for most body text.
     * (Original XSL attribuut: <code>alignment</code>.)
     *
     * @parameter
     */  
    protected String alignment;

    /**
     * 
     * (Original XSL attribuut: <code>callouts.extension</code>.)
     *
     * @parameter
     */  
    protected String calloutsExtension;

    /**
     * This parameter specifies the value of the standalone   specification for generated pages.
     * (Original XSL attribuut: <code>chunker.output.standalone</code>.)
     *
     * @parameter
     */  
    protected String chunkerOutputStandalone;

    /**
     * Separator character used for compound profile values.
     * (Original XSL attribuut: <code>profile.separator</code>.)
     *
     * @parameter
     */  
    protected String profileSeparator;

    /**
     * 
     * (Original XSL attribuut: <code>linenumbering.extension</code>.)
     *
     * @parameter
     */  
    protected String linenumberingExtension;

    /**
     * 
     * (Original XSL attribuut: <code>body.font.master</code>.)
     *
     * @parameter
     */  
    protected String bodyFontMaster;

    /**
     * 
     * (Original XSL attribuut: <code>keep.relative.image.uris</code>.)
     *
     * @parameter
     */  
    protected String keepRelativeImageUris;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.userlevel</code>.)
     *
     * @parameter
     */  
    protected String profileUserlevel;

    /**
     * If non-zero, specifies the thickness of borders on table cells.
     * (Original XSL attribuut: <code>table.cell.border.thickness</code>.)
     *
     * @parameter
     */  
    protected String tableCellBorderThickness;

    /**
     * Specifies the border style of table cells.
     * (Original XSL attribuut: <code>table.cell.border.style</code>.)
     *
     * @parameter
     */  
    protected String tableCellBorderStyle;

    /**
     * If true, unlabeled qandadivs will be enumerated.
     * (Original XSL attribuut: <code>qandadiv.autolabel</code>.)
     *
     * @parameter
     */  
    protected String qandadivAutolabel;

    /**
     * 
     * (Original XSL attribuut: <code>ebnf.statement.terminator</code>.)
     *
     * @parameter
     */  
    protected String ebnfStatementTerminator;

    /**
     * In order to resolve olinks efficiently, the stylesheets can generate an external data file containing information about all potential cross reference endpoints in a document.
     * (Original XSL attribuut: <code>targets.filename</code>.)
     *
     * @parameter
     */  
    protected String targetsFilename;

    /**
     * 
     * (Original XSL attribuut: <code>generate.section.toc.level</code>.)
     *
     * @parameter
     */  
    protected String generateSectionTocLevel;

    /**
     * 
     * (Original XSL attribuut: <code>insert.link.page.number</code>.)
     *
     * @parameter
     */  
    protected String insertLinkPageNumber;

    /**
     * 
     * (Original XSL attribuut: <code>function.parens</code>.)
     *
     * @parameter
     */  
    protected String functionParens;

    /**
     * Formal procedures are numbered and always have a title.
     * (Original XSL attribuut: <code>formal.procedures</code>.)
     *
     * @parameter
     */  
    protected String formalProcedures;

    /**
     * 
     * (Original XSL attribuut: <code>process.source.toc</code>.)
     *
     * @parameter
     */  
    protected String processSourceToc;

    /**
     * 
     * (Original XSL attribuut: <code>ulink.hyphenate.chars</code>.)
     *
     * @parameter
     */  
    protected String ulinkHyphenateChars;

    /**
     * When cross reference data is collected for use by olinks, the data for each potential target includes one field containing a completely assembled cross reference string, as if it were an xref generated in that document.
     * (Original XSL attribuut: <code>use.local.olink.style</code>.)
     *
     * @parameter
     */  
    protected String useLocalOlinkStyle;

    /**
     * If true, callouts are presented with graphics (e.
     * (Original XSL attribuut: <code>callout.graphics</code>.)
     *
     * @parameter
     */  
    protected String calloutGraphics;

    /**
     * 
     * (Original XSL attribuut: <code>refentry.pagebreak</code>.)
     *
     * @parameter
     */  
    protected String refentryPagebreak;

    /**
     * 
     * (Original XSL attribuut: <code>insert.olink.page.number</code>.)
     *
     * @parameter
     */  
    protected String insertOlinkPageNumber;

    /**
     * 
     * (Original XSL attribuut: <code>column.gap.body</code>.)
     *
     * @parameter
     */  
    protected String columnGapBody;

    /**
     * Selects the type of float for margin notes.
     * (Original XSL attribuut: <code>margin.note.float.type</code>.)
     *
     * @parameter
     */  
    protected String marginNoteFloatType;

    /**
     * 
     * (Original XSL attribuut: <code>component.label.includes.part.label</code>.)
     *
     * @parameter
     */  
    protected String componentLabelIncludesPartLabel;

    /**
     * 
     * (Original XSL attribuut: <code>profile.value</code>.)
     *
     * @parameter
     */  
    protected String profileValue;

    /**
     * 
     * (Original XSL attribuut: <code>img.src.path</code>.)
     *
     * @parameter
     */  
    protected String imgSrcPath;

    /**
     * 
     * (Original XSL attribuut: <code>firstterm.only.link</code>.)
     *
     * @parameter
     */  
    protected String firsttermOnlyLink;

    /**
     * Selects draft mode.
     * (Original XSL attribuut: <code>draft.mode</code>.)
     *
     * @parameter
     */  
    protected String draftMode;

    /**
     * Specifies the default width of the label (usually a number or sequence of numbers) in an ordered list.
     * (Original XSL attribuut: <code>orderedlist.label.width</code>.)
     *
     * @parameter
     */  
    protected String orderedlistLabelWidth;

    /**
     * The region after extent is the height of the area where footers are printed.
     * (Original XSL attribuut: <code>region.after.extent</code>.)
     *
     * @parameter
     */  
    protected String regionAfterExtent;

    /**
     * 
     * (Original XSL attribuut: <code>kosek.imported</code>.)
     *
     * @parameter
     */  
    protected String kosekImported;

    /**
     * 
     * (Original XSL attribuut: <code>fop1.extensions</code>.)
     *
     * @parameter
     */  
    protected String fop1Extensions;

    /**
     * 
     * (Original XSL attribuut: <code>funcsynopsis.decoration</code>.)
     *
     * @parameter
     */  
    protected String funcsynopsisDecoration;

    /**
     * 
     * (Original XSL attribuut: <code>callout.unicode.number.limit</code>.)
     *
     * @parameter
     */  
    protected String calloutUnicodeNumberLimit;

    /**
     * 
     * (Original XSL attribuut: <code>space.3emspace.width</code>.)
     *
     * @parameter
     */  
    protected String space3emspaceWidth;

    /**
     * The value of this parameter specifies profiles which should be included in the output.
     * (Original XSL attribuut: <code>profile.lang</code>.)
     *
     * @parameter
     */  
    protected String profileLang;

    protected void configure(Transformer transformer) {
        getLog().debug("Configure the transformer.");
        if (passivetexExtensions != null) {
            transformer.setParameter("passivetex.extensions", 
                convertBooleanToXsltParam(passivetexExtensions));
        }                     
        if (profileCondition != null) {
            transformer.setParameter("profile.condition", 
                convertStringToXsltParam(profileCondition));
        }                     
        if (useRoleAsXrefstyle != null) {
            transformer.setParameter("use.role.as.xrefstyle", 
                convertBooleanToXsltParam(useRoleAsXrefstyle));
        }                     
        if (profileRole != null) {
            transformer.setParameter("profile.role", 
                convertStringToXsltParam(profileRole));
        }                     
        if (tableFrameBorderColor != null) {
            transformer.setParameter("table.frame.border.color", 
                convertStringToXsltParam(tableFrameBorderColor));
        }                     
        if (texMathDelims != null) {
            transformer.setParameter("tex.math.delims", 
                convertBooleanToXsltParam(texMathDelims));
        }                     
        if (graphicDefaultExtension != null) {
            transformer.setParameter("graphic.default.extension", 
                convertStringToXsltParam(graphicDefaultExtension));
        }                     
        if (makeIndexMarkup != null) {
            transformer.setParameter("make.index.markup", 
                convertBooleanToXsltParam(makeIndexMarkup));
        }                     
        if (partAutolabel != null) {
            transformer.setParameter("part.autolabel", 
                convertStringToXsltParam(partAutolabel));
        }                     
        if (footnoteFontSize != null) {
            transformer.setParameter("footnote.font.size", 
                convertStringToXsltParam(footnoteFontSize));
        }                     
        if (cropMarks != null) {
            transformer.setParameter("crop.marks", 
                convertBooleanToXsltParam(cropMarks));
        }                     
        if (hyphenateVerbatim != null) {
            transformer.setParameter("hyphenate.verbatim", 
                convertBooleanToXsltParam(hyphenateVerbatim));
        }                     
        if (atiXsl11Bookmarks != null) {
            transformer.setParameter("ati.xsl11.bookmarks", 
                convertStringToXsltParam(atiXsl11Bookmarks));
        }                     
        if (directionAlignEnd != null) {
            transformer.setParameter("direction.align.end", 
                convertStringToXsltParam(directionAlignEnd));
        }                     
        if (profileRevision != null) {
            transformer.setParameter("profile.revision", 
                convertStringToXsltParam(profileRevision));
        }                     
        if (ebnfAssignment != null) {
            transformer.setParameter("ebnf.assignment", 
                convertStringToXsltParam(ebnfAssignment));
        }                     
        if (qandaDefaultlabel != null) {
            transformer.setParameter("qanda.defaultlabel", 
                convertStringToXsltParam(qandaDefaultlabel));
        }                     
        if (titleFontset != null) {
            transformer.setParameter("title.fontset", 
                convertStringToXsltParam(titleFontset));
        }                     
        if (pageOrientation != null) {
            transformer.setParameter("page.orientation", 
                convertStringToXsltParam(pageOrientation));
        }                     
        if (footnoteNumberFormat != null) {
            transformer.setParameter("footnote.number.format", 
                convertStringToXsltParam(footnoteNumberFormat));
        }                     
        if (referenceAutolabel != null) {
            transformer.setParameter("reference.autolabel", 
                convertStringToXsltParam(referenceAutolabel));
        }                     
        if (dingbatFontFamily != null) {
            transformer.setParameter("dingbat.font.family", 
                convertStringToXsltParam(dingbatFontFamily));
        }                     
        if (titleMarginLeft != null) {
            transformer.setParameter("title.margin.left", 
                convertStringToXsltParam(titleMarginLeft));
        }                     
        if (highlightDefaultLanguage != null) {
            transformer.setParameter("highlight.default.language", 
                convertStringToXsltParam(highlightDefaultLanguage));
        }                     
        if (preferredMediaobjectRole != null) {
            transformer.setParameter("preferred.mediaobject.role", 
                convertStringToXsltParam(preferredMediaobjectRole));
        }                     
        if (generateToc != null) {
            transformer.setParameter("generate.toc", 
                convertStringToXsltParam(generateToc));
        }                     
        if (indexMethod != null) {
            transformer.setParameter("index.method", 
                convertStringToXsltParam(indexMethod));
        }                     
        if (insertOlinkPdfFrag != null) {
            transformer.setParameter("insert.olink.pdf.frag", 
                convertBooleanToXsltParam(insertOlinkPdfFrag));
        }                     
        if (calloutUnicodeFont != null) {
            transformer.setParameter("callout.unicode.font", 
                convertStringToXsltParam(calloutUnicodeFont));
        }                     
        if (indexOnType != null) {
            transformer.setParameter("index.on.type", 
                convertBooleanToXsltParam(indexOnType));
        }                     
        if (emailMailtoEnabled != null) {
            transformer.setParameter("email.mailto.enabled", 
                convertBooleanToXsltParam(emailMailtoEnabled));
        }                     
        if (autotocLabelSeparator != null) {
            transformer.setParameter("autotoc.label.separator", 
                convertStringToXsltParam(autotocLabelSeparator));
        }                     
        if (nominalTableWidth != null) {
            transformer.setParameter("nominal.table.width", 
                convertStringToXsltParam(nominalTableWidth));
        }                     
        if (itemizedlistLabelWidth != null) {
            transformer.setParameter("itemizedlist.label.width", 
                convertStringToXsltParam(itemizedlistLabelWidth));
        }                     
        if (markerSectionLevel != null) {
            transformer.setParameter("marker.section.level", 
                convertStringToXsltParam(markerSectionLevel));
        }                     
        if (kimberImported != null) {
            transformer.setParameter("kimber.imported", 
                convertStringToXsltParam(kimberImported));
        }                     
        if (olinkDoctitle != null) {
            transformer.setParameter("olink.doctitle", 
                convertStringToXsltParam(olinkDoctitle));
        }                     
        if (insertXrefPageNumber != null) {
            transformer.setParameter("insert.xref.page.number", 
                convertStringToXsltParam(insertXrefPageNumber));
        }                     
        if (regionBeforeExtent != null) {
            transformer.setParameter("region.before.extent", 
                convertStringToXsltParam(regionBeforeExtent));
        }                     
        if (lineHeight != null) {
            transformer.setParameter("line-height", 
                convertStringToXsltParam(lineHeight));
        }                     
        if (biblioentryAltPrimarySeps != null) {
            transformer.setParameter("biblioentry.alt.primary.seps", 
                convertStringToXsltParam(biblioentryAltPrimarySeps));
        }                     
        if (spaceEmquadWidth != null) {
            transformer.setParameter("space.emquad.width", 
                convertStringToXsltParam(spaceEmquadWidth));
        }                     
        if (variablelistTermBreakAfter != null) {
            transformer.setParameter("variablelist.term.break.after", 
                convertBooleanToXsltParam(variablelistTermBreakAfter));
        }                     
        if (variablelistAsBlocks != null) {
            transformer.setParameter("variablelist.as.blocks", 
                convertBooleanToXsltParam(variablelistAsBlocks));
        }                     
        if (ulinkFootnotes != null) {
            transformer.setParameter("ulink.footnotes", 
                convertBooleanToXsltParam(ulinkFootnotes));
        }                     
        if (graphicNotations != null) {
            transformer.setParameter("graphic.notations", 
                convertStringToXsltParam(graphicNotations));
        }                     
        if (showComments != null) {
            transformer.setParameter("show.comments", 
                convertBooleanToXsltParam(showComments));
        }                     
        if (profileOs != null) {
            transformer.setParameter("profile.os", 
                convertStringToXsltParam(profileOs));
        }                     
        if (tableFrameBorderStyle != null) {
            transformer.setParameter("table.frame.border.style", 
                convertStringToXsltParam(tableFrameBorderStyle));
        }                     
        if (calloutGraphicsNumberLimit != null) {
            transformer.setParameter("callout.graphics.number.limit", 
                convertStringToXsltParam(calloutGraphicsNumberLimit));
        }                     
        if (biblioentryItemSeparator != null) {
            transformer.setParameter("biblioentry.item.separator", 
                convertStringToXsltParam(biblioentryItemSeparator));
        }                     
        if (xrefTitlePageSeparator != null) {
            transformer.setParameter("xref.title-page.separator", 
                convertStringToXsltParam(xrefTitlePageSeparator));
        }                     
        if (columnGapIndex != null) {
            transformer.setParameter("column.gap.index", 
                convertStringToXsltParam(columnGapIndex));
        }                     
        if (headersOnBlankPages != null) {
            transformer.setParameter("headers.on.blank.pages", 
                convertBooleanToXsltParam(headersOnBlankPages));
        }                     
        if (tablecolumnsExtension != null) {
            transformer.setParameter("tablecolumns.extension", 
                convertBooleanToXsltParam(tablecolumnsExtension));
        }                     
        if (olinkBaseUri != null) {
            transformer.setParameter("olink.base.uri", 
                convertStringToXsltParam(olinkBaseUri));
        }                     
        if (footersOnBlankPages != null) {
            transformer.setParameter("footers.on.blank.pages", 
                convertBooleanToXsltParam(footersOnBlankPages));
        }                     
        if (profileAudience != null) {
            transformer.setParameter("profile.audience", 
                convertStringToXsltParam(profileAudience));
        }                     
        if (emailDelimitersEnabled != null) {
            transformer.setParameter("email.delimiters.enabled", 
                convertBooleanToXsltParam(emailDelimitersEnabled));
        }                     
        if (bodyFontSize != null) {
            transformer.setParameter("body.font.size", 
                convertStringToXsltParam(bodyFontSize));
        }                     
        if (texMathInAlt != null) {
            transformer.setParameter("tex.math.in.alt", 
                convertStringToXsltParam(texMathInAlt));
        }                     
        if (calloutIconSize != null) {
            transformer.setParameter("callout.icon.size", 
                convertStringToXsltParam(calloutIconSize));
        }                     
        if (spaceHairspaceWidth != null) {
            transformer.setParameter("space.hairspace.width", 
                convertStringToXsltParam(spaceHairspaceWidth));
        }                     
        if (sectionAutolabelMaxDepth != null) {
            transformer.setParameter("section.autolabel.max.depth", 
                convertStringToXsltParam(sectionAutolabelMaxDepth));
        }                     
        if (tocIndentWidth != null) {
            transformer.setParameter("toc.indent.width", 
                convertStringToXsltParam(tocIndentWidth));
        }                     
        if (profileArch != null) {
            transformer.setParameter("profile.arch", 
                convertStringToXsltParam(profileArch));
        }                     
        if (chunkerOutputCdataSectionElements != null) {
            transformer.setParameter("chunker.output.cdata-section-elements", 
                convertStringToXsltParam(chunkerOutputCdataSectionElements));
        }                     
        if (profileConformance != null) {
            transformer.setParameter("profile.conformance", 
                convertStringToXsltParam(profileConformance));
        }                     
        if (sidebarFloatWidth != null) {
            transformer.setParameter("sidebar.float.width", 
                convertStringToXsltParam(sidebarFloatWidth));
        }                     
        if (directionMode != null) {
            transformer.setParameter("direction.mode", 
                convertStringToXsltParam(directionMode));
        }                     
        if (refclassSuppress != null) {
            transformer.setParameter("refclass.suppress", 
                convertBooleanToXsltParam(refclassSuppress));
        }                     
        if (chunkerOutputDoctypePublic != null) {
            transformer.setParameter("chunker.output.doctype-public", 
                convertStringToXsltParam(chunkerOutputDoctypePublic));
        }                     
        if (columnGapFront != null) {
            transformer.setParameter("column.gap.front", 
                convertStringToXsltParam(columnGapFront));
        }                     
        if (spaceEnspaceWidth != null) {
            transformer.setParameter("space.enspace.width", 
                convertStringToXsltParam(spaceEnspaceWidth));
        }                     
        if (l10nXml != null) {
            transformer.setParameter("l10n.xml", 
                convertStringToXsltParam(l10nXml));
        }                     
        if (pageHeightPortrait != null) {
            transformer.setParameter("page.height.portrait", 
                convertStringToXsltParam(pageHeightPortrait));
        }                     
        if (tableFootnoteNumberSymbols != null) {
            transformer.setParameter("table.footnote.number.symbols", 
                convertStringToXsltParam(tableFootnoteNumberSymbols));
        }                     
        if (chunkerOutputEncoding != null) {
            transformer.setParameter("chunker.output.encoding", 
                convertStringToXsltParam(chunkerOutputEncoding));
        }                     
        if (sectionAutolabel != null) {
            transformer.setParameter("section.autolabel", 
                convertBooleanToXsltParam(sectionAutolabel));
        }                     
        if (bodyMarginTop != null) {
            transformer.setParameter("body.margin.top", 
                convertStringToXsltParam(bodyMarginTop));
        }                     
        if (columnGapTitlepage != null) {
            transformer.setParameter("column.gap.titlepage", 
                convertStringToXsltParam(columnGapTitlepage));
        }                     
        if (glosstermAutoLink != null) {
            transformer.setParameter("glossterm.auto.link", 
                convertBooleanToXsltParam(glosstermAutoLink));
        }                     
        if (marginNoteWidth != null) {
            transformer.setParameter("margin.note.width", 
                convertStringToXsltParam(marginNoteWidth));
        }                     
        if (get != null) {
            transformer.setParameter("get", 
                convertStringToXsltParam(get));
        }                     
        if (spacePunctspaceWidth != null) {
            transformer.setParameter("space.punctspace.width", 
                convertStringToXsltParam(spacePunctspaceWidth));
        }                     
        if (glosstermWidth != null) {
            transformer.setParameter("glossterm.width", 
                convertStringToXsltParam(glosstermWidth));
        }                     
        if (simplesectInToc != null) {
            transformer.setParameter("simplesect.in.toc", 
                convertBooleanToXsltParam(simplesectInToc));
        }                     
        if (columnCountTitlepage != null) {
            transformer.setParameter("column.count.titlepage", 
                convertStringToXsltParam(columnCountTitlepage));
        }                     
        if (chunkerOutputOmitXmlDeclaration != null) {
            transformer.setParameter("chunker.output.omit-xml-declaration", 
                convertStringToXsltParam(chunkerOutputOmitXmlDeclaration));
        }                     
        if (punctHonorific != null) {
            transformer.setParameter("punct.honorific", 
                convertStringToXsltParam(punctHonorific));
        }                     
        if (pageMarginTop != null) {
            transformer.setParameter("page.margin.top", 
                convertStringToXsltParam(pageMarginTop));
        }                     
        if (ignoreImageScaling != null) {
            transformer.setParameter("ignore.image.scaling", 
                convertBooleanToXsltParam(ignoreImageScaling));
        }                     
        if (appendixAutolabel != null) {
            transformer.setParameter("appendix.autolabel", 
                convertStringToXsltParam(appendixAutolabel));
        }                     
        if (indexTermSeparator != null) {
            transformer.setParameter("index.term.separator", 
                convertStringToXsltParam(indexTermSeparator));
        }                     
        if (bookmarksCollapse != null) {
            transformer.setParameter("bookmarks.collapse", 
                convertBooleanToXsltParam(bookmarksCollapse));
        }                     
        if (chunkerOutputMediaType != null) {
            transformer.setParameter("chunker.output.media-type", 
                convertStringToXsltParam(chunkerOutputMediaType));
        }                     
        if (segmentedlistAsTable != null) {
            transformer.setParameter("segmentedlist.as.table", 
                convertBooleanToXsltParam(segmentedlistAsTable));
        }                     
        if (chunkerOutputIndent != null) {
            transformer.setParameter("chunker.output.indent", 
                convertStringToXsltParam(chunkerOutputIndent));
        }                     
        if (hyphenate != null) {
            transformer.setParameter("hyphenate", 
                convertStringToXsltParam(hyphenate));
        }                     
        if (marginLeftInner != null) {
            transformer.setParameter("margin.left.inner", 
                convertStringToXsltParam(marginLeftInner));
        }                     
        if (defaultTableFrame != null) {
            transformer.setParameter("default.table.frame", 
                convertStringToXsltParam(defaultTableFrame));
        }                     
        if (glossaryCollection != null) {
            transformer.setParameter("glossary.collection", 
                convertStringToXsltParam(glossaryCollection));
        }                     
        if (pageMarginInner != null) {
            transformer.setParameter("page.margin.inner", 
                convertStringToXsltParam(pageMarginInner));
        }                     
        if (menuchoiceMenuSeparator != null) {
            transformer.setParameter("menuchoice.menu.separator", 
                convertStringToXsltParam(menuchoiceMenuSeparator));
        }                     
        if (profileSecurity != null) {
            transformer.setParameter("profile.security", 
                convertStringToXsltParam(profileSecurity));
        }                     
        if (chapterAutolabel != null) {
            transformer.setParameter("chapter.autolabel", 
                convertStringToXsltParam(chapterAutolabel));
        }                     
        if (biblioentryPrimaryCount != null) {
            transformer.setParameter("biblioentry.primary.count", 
                convertStringToXsltParam(biblioentryPrimaryCount));
        }                     
        if (formalTitlePlacement != null) {
            transformer.setParameter("formal.title.placement", 
                convertStringToXsltParam(formalTitlePlacement));
        }                     
        if (chunkerOutputQuiet != null) {
            transformer.setParameter("chunker.output.quiet", 
                convertStringToXsltParam(chunkerOutputQuiet));
        }                     
        if (bibliographyCollection != null) {
            transformer.setParameter("bibliography.collection", 
                convertStringToXsltParam(bibliographyCollection));
        }                     
        if (indexRangeSeparator != null) {
            transformer.setParameter("index.range.separator", 
                convertStringToXsltParam(indexRangeSeparator));
        }                     
        if (shadeVerbatim != null) {
            transformer.setParameter("shade.verbatim", 
                convertBooleanToXsltParam(shadeVerbatim));
        }                     
        if (linenumberingWidth != null) {
            transformer.setParameter("linenumbering.width", 
                convertStringToXsltParam(linenumberingWidth));
        }                     
        if (l10nGentextDefaultLanguage != null) {
            transformer.setParameter("l10n.gentext.default.language", 
                convertStringToXsltParam(l10nGentextDefaultLanguage));
        }                     
        if (refentryGenerateName != null) {
            transformer.setParameter("refentry.generate.name", 
                convertBooleanToXsltParam(refentryGenerateName));
        }                     
        if (ulinkHyphenate != null) {
            transformer.setParameter("ulink.hyphenate", 
                convertStringToXsltParam(ulinkHyphenate));
        }                     
        if (xrefLabelTitleSeparator != null) {
            transformer.setParameter("xref.label-title.separator", 
                convertStringToXsltParam(xrefLabelTitleSeparator));
        }                     
        if (variablelistTermSeparator != null) {
            transformer.setParameter("variablelist.term.separator", 
                convertStringToXsltParam(variablelistTermSeparator));
        }                     
        if (headerColumnWidths != null) {
            transformer.setParameter("header.column.widths", 
                convertStringToXsltParam(headerColumnWidths));
        }                     
        if (sansFontFamily != null) {
            transformer.setParameter("sans.font.family", 
                convertStringToXsltParam(sansFontFamily));
        }                     
        if (qandaInheritNumeration != null) {
            transformer.setParameter("qanda.inherit.numeration", 
                convertBooleanToXsltParam(qandaInheritNumeration));
        }                     
        if (calloutDefaultcolumn != null) {
            transformer.setParameter("callout.defaultcolumn", 
                convertStringToXsltParam(calloutDefaultcolumn));
        }                     
        if (spaceEnquadWidth != null) {
            transformer.setParameter("space.enquad.width", 
                convertStringToXsltParam(spaceEnquadWidth));
        }                     
        if (profileRevisionflag != null) {
            transformer.setParameter("profile.revisionflag", 
                convertStringToXsltParam(profileRevisionflag));
        }                     
        if (procedureStepNumerationFormats != null) {
            transformer.setParameter("procedure.step.numeration.formats", 
                convertStringToXsltParam(procedureStepNumerationFormats));
        }                     
        if (rootid != null) {
            transformer.setParameter("rootid", 
                convertStringToXsltParam(rootid));
        }                     
        if (refentryXrefManvolnum != null) {
            transformer.setParameter("refentry.xref.manvolnum", 
                convertBooleanToXsltParam(refentryXrefManvolnum));
        }                     
        if (columnCountBody != null) {
            transformer.setParameter("column.count.body", 
                convertStringToXsltParam(columnCountBody));
        }                     
        if (collectXrefTargets != null) {
            transformer.setParameter("collect.xref.targets", 
                convertStringToXsltParam(collectXrefTargets));
        }                     
        if (makeSingleYearRanges != null) {
            transformer.setParameter("make.single.year.ranges", 
                convertBooleanToXsltParam(makeSingleYearRanges));
        }                     
        if (bodyEndIndent != null) {
            transformer.setParameter("body.end.indent", 
                convertStringToXsltParam(bodyEndIndent));
        }                     
        if (stylesheetResultType != null) {
            transformer.setParameter("stylesheet.result.type", 
                convertStringToXsltParam(stylesheetResultType));
        }                     
        if (cropMarkOffset != null) {
            transformer.setParameter("crop.mark.offset", 
                convertStringToXsltParam(cropMarkOffset));
        }                     
        if (bodyStartIndent != null) {
            transformer.setParameter("body.start.indent", 
                convertStringToXsltParam(bodyStartIndent));
        }                     
        if (indexNumberSeparator != null) {
            transformer.setParameter("index.number.separator", 
                convertStringToXsltParam(indexNumberSeparator));
        }                     
        if (calloutUnicodeStartCharacter != null) {
            transformer.setParameter("callout.unicode.start.character", 
                convertStringToXsltParam(calloutUnicodeStartCharacter));
        }                     
        if (l10nLangValueRfcCompliant != null) {
            transformer.setParameter("l10n.lang.value.rfc.compliant", 
                convertBooleanToXsltParam(l10nLangValueRfcCompliant));
        }                     
        if (fopExtensions != null) {
            transformer.setParameter("fop.extensions", 
                convertBooleanToXsltParam(fopExtensions));
        }                     
        if (doubleSided != null) {
            transformer.setParameter("double.sided", 
                convertBooleanToXsltParam(doubleSided));
        }                     
        if (columnCountIndex != null) {
            transformer.setParameter("column.count.index", 
                convertStringToXsltParam(columnCountIndex));
        }                     
        if (xrefLabelPageSeparator != null) {
            transformer.setParameter("xref.label-page.separator", 
                convertStringToXsltParam(xrefLabelPageSeparator));
        }                     
        if (processEmptySourceToc != null) {
            transformer.setParameter("process.empty.source.toc", 
                convertBooleanToXsltParam(processEmptySourceToc));
        }                     
        if (axfExtensions != null) {
            transformer.setParameter("axf.extensions", 
                convertBooleanToXsltParam(axfExtensions));
        }                     
        if (space6emspaceWidth != null) {
            transformer.setParameter("space.6emspace.width", 
                convertStringToXsltParam(space6emspaceWidth));
        }                     
        if (highlightXslthlConfig != null) {
            transformer.setParameter("highlight.xslthl.config", 
                convertStringToXsltParam(highlightXslthlConfig));
        }                     
        if (spaceThinspaceWidth != null) {
            transformer.setParameter("space.thinspace.width", 
                convertStringToXsltParam(spaceThinspaceWidth));
        }                     
        if (highlightSource != null) {
            transformer.setParameter("highlight.source", 
                convertBooleanToXsltParam(highlightSource));
        }                     
        if (footerRule != null) {
            transformer.setParameter("footer.rule", 
                convertBooleanToXsltParam(footerRule));
        }                     
        if (refentryGenerateTitle != null) {
            transformer.setParameter("refentry.generate.title", 
                convertBooleanToXsltParam(refentryGenerateTitle));
        }                     
        if (calloutGraphicsPath != null) {
            transformer.setParameter("callout.graphics.path", 
                convertStringToXsltParam(calloutGraphicsPath));
        }                     
        if (columnCountFront != null) {
            transformer.setParameter("column.count.front", 
                convertStringToXsltParam(columnCountFront));
        }                     
        if (directionAlignStart != null) {
            transformer.setParameter("direction.align.start", 
                convertStringToXsltParam(directionAlignStart));
        }                     
        if (pageMarginBottom != null) {
            transformer.setParameter("page.margin.bottom", 
                convertStringToXsltParam(pageMarginBottom));
        }                     
        if (chunkerOutputMethod != null) {
            transformer.setParameter("chunker.output.method", 
                convertStringToXsltParam(chunkerOutputMethod));
        }                     
        if (qandaInToc != null) {
            transformer.setParameter("qanda.in.toc", 
                convertBooleanToXsltParam(qandaInToc));
        }                     
        if (glossarySort != null) {
            transformer.setParameter("glossary.sort", 
                convertBooleanToXsltParam(glossarySort));
        }                     
        if (calloutGraphicsExtension != null) {
            transformer.setParameter("callout.graphics.extension", 
                convertStringToXsltParam(calloutGraphicsExtension));
        }                     
        if (footnoteNumberSymbols != null) {
            transformer.setParameter("footnote.number.symbols", 
                convertStringToXsltParam(footnoteNumberSymbols));
        }                     
        if (bridgeheadInToc != null) {
            transformer.setParameter("bridgehead.in.toc", 
                convertBooleanToXsltParam(bridgeheadInToc));
        }                     
        if (linenumberingEveryNth != null) {
            transformer.setParameter("linenumbering.everyNth", 
                convertStringToXsltParam(linenumberingEveryNth));
        }                     
        if (bodyMarginBottom != null) {
            transformer.setParameter("body.margin.bottom", 
                convertStringToXsltParam(bodyMarginBottom));
        }                     
        if (saxonCharacterRepresentation != null) {
            transformer.setParameter("saxon.character.representation", 
                convertStringToXsltParam(saxonCharacterRepresentation));
        }                     
        if (funcsynopsisStyle != null) {
            transformer.setParameter("funcsynopsis.style", 
                convertStringToXsltParam(funcsynopsisStyle));
        }                     
        if (glossaryAsBlocks != null) {
            transformer.setParameter("glossary.as.blocks", 
                convertBooleanToXsltParam(glossaryAsBlocks));
        }                     
        if (generateIndex != null) {
            transformer.setParameter("generate.index", 
                convertBooleanToXsltParam(generateIndex));
        }                     
        if (emptyLocalL10nXml != null) {
            transformer.setParameter("empty.local.l10n.xml", 
                convertStringToXsltParam(emptyLocalL10nXml));
        }                     
        if (l10nGentextUseXrefLanguage != null) {
            transformer.setParameter("l10n.gentext.use.xref.language", 
                convertBooleanToXsltParam(l10nGentextUseXrefLanguage));
        }                     
        if (olinkLangFallbackSequence != null) {
            transformer.setParameter("olink.lang.fallback.sequence", 
                convertStringToXsltParam(olinkLangFallbackSequence));
        }                     
        if (authorOthernameInMiddle != null) {
            transformer.setParameter("author.othername.in.middle", 
                convertBooleanToXsltParam(authorOthernameInMiddle));
        }                     
        if (columnCountBack != null) {
            transformer.setParameter("column.count.back", 
                convertStringToXsltParam(columnCountBack));
        }                     
        if (menuchoiceSeparator != null) {
            transformer.setParameter("menuchoice.separator", 
                convertStringToXsltParam(menuchoiceSeparator));
        }                     
        if (makeYearRanges != null) {
            transformer.setParameter("make.year.ranges", 
                convertBooleanToXsltParam(makeYearRanges));
        }                     
        if (l10nGentextLanguage != null) {
            transformer.setParameter("l10n.gentext.language", 
                convertStringToXsltParam(l10nGentextLanguage));
        }                     
        if (defaultUnits != null) {
            transformer.setParameter("default.units", 
                convertStringToXsltParam(defaultUnits));
        }                     
        if (bodyFontset != null) {
            transformer.setParameter("body.fontset", 
                convertStringToXsltParam(bodyFontset));
        }                     
        if (useExtensions != null) {
            transformer.setParameter("use.extensions", 
                convertBooleanToXsltParam(useExtensions));
        }                     
        if (runinheadTitleEndPunct != null) {
            transformer.setParameter("runinhead.title.end.punct", 
                convertStringToXsltParam(runinheadTitleEndPunct));
        }                     
        if (olinkDebug != null) {
            transformer.setParameter("olink.debug", 
                convertBooleanToXsltParam(olinkDebug));
        }                     
        if (localL10nXml != null) {
            transformer.setParameter("local.l10n.xml", 
                convertStringToXsltParam(localL10nXml));
        }                     
        if (xrefWithNumberAndTitle != null) {
            transformer.setParameter("xref.with.number.and.title", 
                convertBooleanToXsltParam(xrefWithNumberAndTitle));
        }                     
        if (admonGraphicsPath != null) {
            transformer.setParameter("admon.graphics.path", 
                convertStringToXsltParam(admonGraphicsPath));
        }                     
        if (ulinkShow != null) {
            transformer.setParameter("ulink.show", 
                convertBooleanToXsltParam(ulinkShow));
        }                     
        if (glosslistAsBlocks != null) {
            transformer.setParameter("glosslist.as.blocks", 
                convertBooleanToXsltParam(glosslistAsBlocks));
        }                     
        if (titleFontFamily != null) {
            transformer.setParameter("title.font.family", 
                convertStringToXsltParam(titleFontFamily));
        }                     
        if (tableFootnoteNumberFormat != null) {
            transformer.setParameter("table.footnote.number.format", 
                convertStringToXsltParam(tableFootnoteNumberFormat));
        }                     
        if (monospaceVerbatimFontWidth != null) {
            transformer.setParameter("monospace.verbatim.font.width", 
                convertStringToXsltParam(monospaceVerbatimFontWidth));
        }                     
        if (hyphenateVerbatimCharacters != null) {
            transformer.setParameter("hyphenate.verbatim.characters", 
                convertStringToXsltParam(hyphenateVerbatimCharacters));
        }                     
        if (defaultImageWidth != null) {
            transformer.setParameter("default.image.width", 
                convertStringToXsltParam(defaultImageWidth));
        }                     
        if (headerRule != null) {
            transformer.setParameter("header.rule", 
                convertBooleanToXsltParam(headerRule));
        }                     
        if (prefaceAutolabel != null) {
            transformer.setParameter("preface.autolabel", 
                convertStringToXsltParam(prefaceAutolabel));
        }                     
        if (symbolFontFamily != null) {
            transformer.setParameter("symbol.font.family", 
                convertStringToXsltParam(symbolFontFamily));
        }                     
        if (currentDocid != null) {
            transformer.setParameter("current.docid", 
                convertStringToXsltParam(currentDocid));
        }                     
        if (pageMarginOuter != null) {
            transformer.setParameter("page.margin.outer", 
                convertStringToXsltParam(pageMarginOuter));
        }                     
        if (preferInternalOlink != null) {
            transformer.setParameter("prefer.internal.olink", 
                convertBooleanToXsltParam(preferInternalOlink));
        }                     
        if (useSvg != null) {
            transformer.setParameter("use.svg", 
                convertBooleanToXsltParam(useSvg));
        }                     
        if (profileAttribute != null) {
            transformer.setParameter("profile.attribute", 
                convertStringToXsltParam(profileAttribute));
        }                     
        if (tocMaxDepth != null) {
            transformer.setParameter("toc.max.depth", 
                convertStringToXsltParam(tocMaxDepth));
        }                     
        if (targetDatabaseDocument != null) {
            transformer.setParameter("target.database.document", 
                convertStringToXsltParam(targetDatabaseDocument));
        }                     
        if (admonGraphicsExtension != null) {
            transformer.setParameter("admon.graphics.extension", 
                convertStringToXsltParam(admonGraphicsExtension));
        }                     
        if (cropMarkWidth != null) {
            transformer.setParameter("crop.mark.width", 
                convertStringToXsltParam(cropMarkWidth));
        }                     
        if (bibliographyNumbered != null) {
            transformer.setParameter("bibliography.numbered", 
                convertBooleanToXsltParam(bibliographyNumbered));
        }                     
        if (headerTableHeight != null) {
            transformer.setParameter("header.table.height", 
                convertStringToXsltParam(headerTableHeight));
        }                     
        if (textinsertExtension != null) {
            transformer.setParameter("textinsert.extension", 
                convertBooleanToXsltParam(textinsertExtension));
        }                     
        if (sectionContainerElement != null) {
            transformer.setParameter("section.container.element", 
                convertStringToXsltParam(sectionContainerElement));
        }                     
        if (arbortextExtensions != null) {
            transformer.setParameter("arbortext.extensions", 
                convertBooleanToXsltParam(arbortextExtensions));
        }                     
        if (cropMarkBleed != null) {
            transformer.setParameter("crop.mark.bleed", 
                convertStringToXsltParam(cropMarkBleed));
        }                     
        if (footerTableHeight != null) {
            transformer.setParameter("footer.table.height", 
                convertStringToXsltParam(footerTableHeight));
        }                     
        if (variablelistMaxTermlength != null) {
            transformer.setParameter("variablelist.max.termlength", 
                convertStringToXsltParam(variablelistMaxTermlength));
        }                     
        if (defaultTableWidth != null) {
            transformer.setParameter("default.table.width", 
                convertStringToXsltParam(defaultTableWidth));
        }                     
        if (chunkerOutputDoctypeSystem != null) {
            transformer.setParameter("chunker.output.doctype-system", 
                convertStringToXsltParam(chunkerOutputDoctypeSystem));
        }                     
        if (defaultTableRules != null) {
            transformer.setParameter("default.table.rules", 
                convertStringToXsltParam(defaultTableRules));
        }                     
        if (tocSectionDepth != null) {
            transformer.setParameter("toc.section.depth", 
                convertStringToXsltParam(tocSectionDepth));
        }                     
        if (sidebarFloatType != null) {
            transformer.setParameter("sidebar.float.type", 
                convertStringToXsltParam(sidebarFloatType));
        }                     
        if (writingMode != null) {
            transformer.setParameter("writing.mode", 
                convertStringToXsltParam(writingMode));
        }                     
        if (calloutUnicode != null) {
            transformer.setParameter("callout.unicode", 
                convertBooleanToXsltParam(calloutUnicode));
        }                     
        if (spaceFigspaceWidth != null) {
            transformer.setParameter("space.figspace.width", 
                convertStringToXsltParam(spaceFigspaceWidth));
        }                     
        if (paperType != null) {
            transformer.setParameter("paper.type", 
                convertStringToXsltParam(paperType));
        }                     
        if (textdataDefaultEncoding != null) {
            transformer.setParameter("textdata.default.encoding", 
                convertStringToXsltParam(textdataDefaultEncoding));
        }                     
        if (admonGraphics != null) {
            transformer.setParameter("admon.graphics", 
                convertBooleanToXsltParam(admonGraphics));
        }                     
        if (columnGapBack != null) {
            transformer.setParameter("column.gap.back", 
                convertStringToXsltParam(columnGapBack));
        }                     
        if (spaceEmspaceWidth != null) {
            transformer.setParameter("space.emspace.width", 
                convertStringToXsltParam(spaceEmspaceWidth));
        }                     
        if (runinheadDefaultTitleEndPunct != null) {
            transformer.setParameter("runinhead.default.title.end.punct", 
                convertStringToXsltParam(runinheadDefaultTitleEndPunct));
        }                     
        if (pageWidthPortrait != null) {
            transformer.setParameter("page.width.portrait", 
                convertStringToXsltParam(pageWidthPortrait));
        }                     
        if (glossentryShowAcronym != null) {
            transformer.setParameter("glossentry.show.acronym", 
                convertStringToXsltParam(glossentryShowAcronym));
        }                     
        if (monospaceFontFamily != null) {
            transformer.setParameter("monospace.font.family", 
                convertStringToXsltParam(monospaceFontFamily));
        }                     
        if (glosstermSeparation != null) {
            transformer.setParameter("glossterm.separation", 
                convertStringToXsltParam(glosstermSeparation));
        }                     
        if (useRoleForMediaobject != null) {
            transformer.setParameter("use.role.for.mediaobject", 
                convertBooleanToXsltParam(useRoleForMediaobject));
        }                     
        if (sectionLabelIncludesComponentLabel != null) {
            transformer.setParameter("section.label.includes.component.label", 
                convertBooleanToXsltParam(sectionLabelIncludesComponentLabel));
        }                     
        if (columnGapLot != null) {
            transformer.setParameter("column.gap.lot", 
                convertStringToXsltParam(columnGapLot));
        }                     
        if (admonTextlabel != null) {
            transformer.setParameter("admon.textlabel", 
                convertBooleanToXsltParam(admonTextlabel));
        }                     
        if (profileVendor != null) {
            transformer.setParameter("profile.vendor", 
                convertStringToXsltParam(profileVendor));
        }                     
        if (profileStatus != null) {
            transformer.setParameter("profile.status", 
                convertStringToXsltParam(profileStatus));
        }                     
        if (indexOnRole != null) {
            transformer.setParameter("index.on.role", 
                convertBooleanToXsltParam(indexOnRole));
        }                     
        if (draftWatermarkImage != null) {
            transformer.setParameter("draft.watermark.image", 
                convertStringToXsltParam(draftWatermarkImage));
        }                     
        if (profileWordsize != null) {
            transformer.setParameter("profile.wordsize", 
                convertStringToXsltParam(profileWordsize));
        }                     
        if (space4emspaceWidth != null) {
            transformer.setParameter("space.4emspace.width", 
                convertStringToXsltParam(space4emspaceWidth));
        }                     
        if (qandaNestedInToc != null) {
            transformer.setParameter("qanda.nested.in.toc", 
                convertBooleanToXsltParam(qandaNestedInToc));
        }                     
        if (graphicExtensions != null) {
            transformer.setParameter("graphic.extensions", 
                convertStringToXsltParam(graphicExtensions));
        }                     
        if (pageHeight != null) {
            transformer.setParameter("page.height", 
                convertStringToXsltParam(pageHeight));
        }                     
        if (tableCellBorderColor != null) {
            transformer.setParameter("table.cell.border.color", 
                convertStringToXsltParam(tableCellBorderColor));
        }                     
        if (columnCountLot != null) {
            transformer.setParameter("column.count.lot", 
                convertStringToXsltParam(columnCountLot));
        }                     
        if (linenumberingSeparator != null) {
            transformer.setParameter("linenumbering.separator", 
                convertStringToXsltParam(linenumberingSeparator));
        }                     
        if (defaultFloatClass != null) {
            transformer.setParameter("default.float.class", 
                convertStringToXsltParam(defaultFloatClass));
        }                     
        if (bodyFontFamily != null) {
            transformer.setParameter("body.font.family", 
                convertStringToXsltParam(bodyFontFamily));
        }                     
        if (xepExtensions != null) {
            transformer.setParameter("xep.extensions", 
                convertBooleanToXsltParam(xepExtensions));
        }                     
        if (labelFromPart != null) {
            transformer.setParameter("label.from.part", 
                convertBooleanToXsltParam(labelFromPart));
        }                     
        if (pageWidth != null) {
            transformer.setParameter("page.width", 
                convertStringToXsltParam(pageWidth));
        }                     
        if (bibliographyStyle != null) {
            transformer.setParameter("bibliography.style", 
                convertStringToXsltParam(bibliographyStyle));
        }                     
        if (tableFrameBorderThickness != null) {
            transformer.setParameter("table.frame.border.thickness", 
                convertStringToXsltParam(tableFrameBorderThickness));
        }                     
        if (exslNodeSetAvailable != null) {
            transformer.setParameter("exsl.node.set.available", 
                convertBooleanToXsltParam(exslNodeSetAvailable));
        }                     
        if (footerColumnWidths != null) {
            transformer.setParameter("footer.column.widths", 
                convertStringToXsltParam(footerColumnWidths));
        }                     
        if (alignment != null) {
            transformer.setParameter("alignment", 
                convertStringToXsltParam(alignment));
        }                     
        if (calloutsExtension != null) {
            transformer.setParameter("callouts.extension", 
                convertBooleanToXsltParam(calloutsExtension));
        }                     
        if (chunkerOutputStandalone != null) {
            transformer.setParameter("chunker.output.standalone", 
                convertStringToXsltParam(chunkerOutputStandalone));
        }                     
        if (profileSeparator != null) {
            transformer.setParameter("profile.separator", 
                convertStringToXsltParam(profileSeparator));
        }                     
        if (linenumberingExtension != null) {
            transformer.setParameter("linenumbering.extension", 
                convertBooleanToXsltParam(linenumberingExtension));
        }                     
        if (bodyFontMaster != null) {
            transformer.setParameter("body.font.master", 
                convertStringToXsltParam(bodyFontMaster));
        }                     
        if (keepRelativeImageUris != null) {
            transformer.setParameter("keep.relative.image.uris", 
                convertBooleanToXsltParam(keepRelativeImageUris));
        }                     
        if (profileUserlevel != null) {
            transformer.setParameter("profile.userlevel", 
                convertStringToXsltParam(profileUserlevel));
        }                     
        if (tableCellBorderThickness != null) {
            transformer.setParameter("table.cell.border.thickness", 
                convertStringToXsltParam(tableCellBorderThickness));
        }                     
        if (tableCellBorderStyle != null) {
            transformer.setParameter("table.cell.border.style", 
                convertStringToXsltParam(tableCellBorderStyle));
        }                     
        if (qandadivAutolabel != null) {
            transformer.setParameter("qandadiv.autolabel", 
                convertBooleanToXsltParam(qandadivAutolabel));
        }                     
        if (ebnfStatementTerminator != null) {
            transformer.setParameter("ebnf.statement.terminator", 
                convertStringToXsltParam(ebnfStatementTerminator));
        }                     
        if (targetsFilename != null) {
            transformer.setParameter("targets.filename", 
                convertStringToXsltParam(targetsFilename));
        }                     
        if (generateSectionTocLevel != null) {
            transformer.setParameter("generate.section.toc.level", 
                convertStringToXsltParam(generateSectionTocLevel));
        }                     
        if (insertLinkPageNumber != null) {
            transformer.setParameter("insert.link.page.number", 
                convertStringToXsltParam(insertLinkPageNumber));
        }                     
        if (functionParens != null) {
            transformer.setParameter("function.parens", 
                convertBooleanToXsltParam(functionParens));
        }                     
        if (formalProcedures != null) {
            transformer.setParameter("formal.procedures", 
                convertBooleanToXsltParam(formalProcedures));
        }                     
        if (processSourceToc != null) {
            transformer.setParameter("process.source.toc", 
                convertBooleanToXsltParam(processSourceToc));
        }                     
        if (ulinkHyphenateChars != null) {
            transformer.setParameter("ulink.hyphenate.chars", 
                convertStringToXsltParam(ulinkHyphenateChars));
        }                     
        if (useLocalOlinkStyle != null) {
            transformer.setParameter("use.local.olink.style", 
                convertBooleanToXsltParam(useLocalOlinkStyle));
        }                     
        if (calloutGraphics != null) {
            transformer.setParameter("callout.graphics", 
                convertBooleanToXsltParam(calloutGraphics));
        }                     
        if (refentryPagebreak != null) {
            transformer.setParameter("refentry.pagebreak", 
                convertBooleanToXsltParam(refentryPagebreak));
        }                     
        if (insertOlinkPageNumber != null) {
            transformer.setParameter("insert.olink.page.number", 
                convertStringToXsltParam(insertOlinkPageNumber));
        }                     
        if (columnGapBody != null) {
            transformer.setParameter("column.gap.body", 
                convertStringToXsltParam(columnGapBody));
        }                     
        if (marginNoteFloatType != null) {
            transformer.setParameter("margin.note.float.type", 
                convertStringToXsltParam(marginNoteFloatType));
        }                     
        if (componentLabelIncludesPartLabel != null) {
            transformer.setParameter("component.label.includes.part.label", 
                convertBooleanToXsltParam(componentLabelIncludesPartLabel));
        }                     
        if (profileValue != null) {
            transformer.setParameter("profile.value", 
                convertStringToXsltParam(profileValue));
        }                     
        if (imgSrcPath != null) {
            transformer.setParameter("img.src.path", 
                convertStringToXsltParam(imgSrcPath));
        }                     
        if (firsttermOnlyLink != null) {
            transformer.setParameter("firstterm.only.link", 
                convertBooleanToXsltParam(firsttermOnlyLink));
        }                     
        if (draftMode != null) {
            transformer.setParameter("draft.mode", 
                convertStringToXsltParam(draftMode));
        }                     
        if (orderedlistLabelWidth != null) {
            transformer.setParameter("orderedlist.label.width", 
                convertStringToXsltParam(orderedlistLabelWidth));
        }                     
        if (regionAfterExtent != null) {
            transformer.setParameter("region.after.extent", 
                convertStringToXsltParam(regionAfterExtent));
        }                     
        if (kosekImported != null) {
            transformer.setParameter("kosek.imported", 
                convertStringToXsltParam(kosekImported));
        }                     
        if (fop1Extensions != null) {
            transformer.setParameter("fop1.extensions", 
                convertBooleanToXsltParam(fop1Extensions));
        }                     
        if (funcsynopsisDecoration != null) {
            transformer.setParameter("funcsynopsis.decoration", 
                convertBooleanToXsltParam(funcsynopsisDecoration));
        }                     
        if (calloutUnicodeNumberLimit != null) {
            transformer.setParameter("callout.unicode.number.limit", 
                convertStringToXsltParam(calloutUnicodeNumberLimit));
        }                     
        if (space3emspaceWidth != null) {
            transformer.setParameter("space.3emspace.width", 
                convertStringToXsltParam(space3emspaceWidth));
        }                     
        if (profileLang != null) {
            transformer.setParameter("profile.lang", 
                convertStringToXsltParam(profileLang));
        }                     
    }

    public File getSourceDirectory() {
        return sourceDirectory;
    }

    public File getTargetDirectory() {
        return targetDirectory;
    }

    public File getGeneratedSourceDirectory() {
        return generatedSourceDirectory;
    }

	public String getDefaultStylesheetLocation() {
        return "docbook/fo/docbook.xsl";
	}

	public String getType() {
	    return "fo";
	}

    public String getStylesheetLocation() {
    	getLog().debug("Customization: " + foCustomization);
        if (foCustomization != null) {
            return foCustomization;
        } else if (getNonDefaultStylesheetLocation() == null) {
            return getDefaultStylesheetLocation();
        } else {
            return getNonDefaultStylesheetLocation();
        }
    }

    public String getTargetFileExtension() {
        return targetFileExtension;
    }

    public void setTargetFileExtension(String extension) {
        targetFileExtension = extension;
    }

    public String[] getIncludes() {
        String[] results = includes.split(",");
        for (int i = 0; i < results.length; i++) {
            results[i] = results[i].trim();
        }
        return results;
    }

    public List getEntities() {
        return entities;
    }

    public List getCustomizationParameters()
    {
    	return customizationParameters;
    }

    public Properties getSystemProperties()
    {
        return systemProperties;
    }

    public Target getPreProcess() {
        return preProcess;
    }

    public Target getPostProcess() {
        return postProcess;
    }

    public MavenProject getMavenProject() {
        return project;
    }

    public List getArtifacts() {
        return artifacts;
    }

    protected boolean getXIncludeSupported() {
        return xincludeSupported;
    }

    /**
     * Returns false if the stylesheet is responsible to create the output file(s) using its own naming scheme.
     *
     * @return If using the standard output.
     */
    protected boolean isUseStandardOutput() {
        return useStandardOutput;
    }

    protected boolean isShowXslMessages() {
        return showXslMessages;
    }

    protected void setShowXslMessages(boolean showXslMessages) {
        this.showXslMessages = showXslMessages;
    }

    protected void setUseStandardOutput(boolean useStandardOutput) {
        this.useStandardOutput = useStandardOutput;
    }

    
}