/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security.web;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AttributeService {
    private static final AttributeService SINGLETON = new AttributeService();
    private final Map<Thread, Map<String, Object>> threadMap = new ConcurrentHashMap<Thread, Map<String, Object>>();

    public static AttributeService getInstance() {
        return SINGLETON;
    }

    private AttributeService() {
    }

    private Map<String, Object> getAttributeMap() {
        Thread currentThread = Thread.currentThread();
        Map<String, Object> attributeMap = this.threadMap.get(currentThread);
        if (attributeMap == null) {
            attributeMap = new LinkedHashMap<String, Object>();
            this.threadMap.put(currentThread, attributeMap);
        }
        return attributeMap;
    }

    public Object getAttribute(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty name");
        }
        return this.getAttributeMap().get(name);
    }

    public void setAttribute(String name, Object attribute) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty name");
        }
        this.getAttributeMap().put(name, attribute);
    }

    public void destroyAttribute(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty name");
        }
        Map<String, Object> attributeMap = this.threadMap.get(Thread.currentThread());
        if (attributeMap != null) {
            attributeMap.remove(name);
        }
    }

    public void destroyAttributes() {
        this.threadMap.remove(Thread.currentThread());
    }
}

