/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.qrcode.internal.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.TimerData;
import com.adyen.checkout.components.core.internal.util.ContextExtensionsKt;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.qrcode.R;
import com.adyen.checkout.qrcode.databinding.SimpleQrcodeViewBinding;
import com.adyen.checkout.qrcode.internal.ui.QRCodeDelegate;
import com.adyen.checkout.qrcode.internal.ui.model.QRCodeOutputData;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.google.android.material.button.MaterialButton;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0003\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010&\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/adyen/checkout/qrcode/internal/ui/view/SimpleQRCodeView;", "Landroid/widget/LinearLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/qrcode/databinding/SimpleQrcodeViewBinding;", "delegate", "Lcom/adyen/checkout/qrcode/internal/ui/QRCodeDelegate;", "localizedContext", "copyCode", "", "qrCodeData", "", "getMessageTextResource", "paymentMethodType", "(Ljava/lang/String;)Ljava/lang/Integer;", "getView", "Landroid/view/View;", "highlightValidationErrors", "initLocalizedStrings", "initView", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "observeDelegate", "onTimerTick", "timerData", "Lcom/adyen/checkout/components/core/internal/ui/model/TimerData;", "outputDataChanged", "outputData", "Lcom/adyen/checkout/qrcode/internal/ui/model/QRCodeOutputData;", "updateLogo", "updateMessageText", "qr-code_release"})
@SourceDebugExtension(value={"SMAP\nSimpleQRCodeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleQRCodeView.kt\ncom/adyen/checkout/qrcode/internal/ui/view/SimpleQRCodeView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,148:1\n1#2:149\n16#3,17:150\n16#3,17:167\n*S KotlinDebug\n*F\n+ 1 SimpleQRCodeView.kt\ncom/adyen/checkout/qrcode/internal/ui/view/SimpleQRCodeView\n*L\n89#1:150,17\n104#1:167,17\n*E\n"})
public final class SimpleQRCodeView
extends LinearLayout
implements ComponentView {
    @NotNull
    private final SimpleQrcodeViewBinding binding;
    private Context localizedContext;
    private QRCodeDelegate delegate;

    @JvmOverloads
    public SimpleQRCodeView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        SimpleQrcodeViewBinding simpleQrcodeViewBinding = SimpleQrcodeViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)simpleQrcodeViewBinding, (String)"inflate(...)");
        this.binding = simpleQrcodeViewBinding;
        this.setOrientation(1);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_double_margin);
        this.setPadding(padding, padding, padding, padding);
    }

    public /* synthetic */ SimpleQRCodeView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof QRCodeDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.delegate = (QRCodeDelegate)delegate;
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.observeDelegate((QRCodeDelegate)delegate, coroutineScope);
        this.binding.copyButton.setOnClickListener(arg_0 -> SimpleQRCodeView.initView$lambda$1(this, delegate, arg_0));
    }

    private final void initLocalizedStrings(Context localizedContext) {
        MaterialButton materialButton = this.binding.copyButton;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"copyButton");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)materialButton), (int)R.style.AdyenCheckout_QrCode_CopyButton, (Context)localizedContext, (boolean)false, (int)4, null);
    }

    private final void observeDelegate(QRCodeDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<QRCodeOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SimpleQRCodeView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        QRCodeOutputData it = (QRCodeOutputData)this.L$0;
                        SimpleQRCodeView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull QRCodeOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getTimerFlow(), (Function2)((Function2)new Function2<TimerData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SimpleQRCodeView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TimerData it = (TimerData)this.L$0;
                        SimpleQRCodeView.access$onTimerTick(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull TimerData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void outputDataChanged(QRCodeOutputData outputData) {
        SimpleQRCodeView simpleQRCodeView = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "outputDataChanged";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        this.updateMessageText(outputData.getPaymentMethodType());
        this.updateLogo(outputData.getPaymentMethodType());
    }

    @StringRes
    private final Integer getMessageTextResource(String paymentMethodType) {
        return Intrinsics.areEqual((Object)paymentMethodType, (Object)"pix") ? Integer.valueOf(R.string.checkout_qr_code_pix) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLogo(String paymentMethodType) {
        Object object = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "updateLogo - " + paymentMethodType;
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        object = paymentMethodType;
        if (!(object == null || object.length() == 0)) {
            ImageView imageView = this.binding.imageViewLogo;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewLogo");
            QRCodeDelegate qRCodeDelegate = this.delegate;
            if (qRCodeDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                qRCodeDelegate = null;
            }
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)qRCodeDelegate.getComponentParams().getEnvironment(), (String)paymentMethodType, null, null, null, (int)0, (int)0, (int)124, null);
        }
    }

    private final void updateMessageText(String paymentMethodType) {
        Integer n = this.getMessageTextResource(paymentMethodType);
        if (n == null) {
            return;
        }
        int resId = n;
        TextView textView = this.binding.textViewTopLabel;
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        textView.setText((CharSequence)context.getString(resId));
    }

    private final void onTimerTick(TimerData timerData) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timerData.getMillisUntilFinished());
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timerData.getMillisUntilFinished()) % TimeUnit.MINUTES.toSeconds(1L);
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = context.getString(R.string.checkout_qr_code_time_left_format, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String minutesSecondsString = string2;
        TextView textView = this.binding.textViewTimer;
        Context context2 = this.localizedContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context2 = null;
        }
        Object[] objectArray2 = new Object[]{minutesSecondsString};
        textView.setText((CharSequence)context2.getString(R.string.checkout_qr_code_timer_text, objectArray2));
        this.binding.progressIndicator.setProgress(timerData.getProgress());
    }

    private final void copyCode(String qrCodeData) {
        if (qrCodeData == null) {
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = this.localizedContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context2 = null;
        }
        ContextExtensionsKt.copyTextToClipboard((Context)context, (String)"Pix Code", (String)qrCodeData, (String)context2.getString(R.string.checkout_qr_code_copied_toast));
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    public void highlightValidationErrors() {
    }

    @JvmOverloads
    public SimpleQRCodeView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SimpleQRCodeView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initView$lambda$1(SimpleQRCodeView this$0, ComponentDelegate $delegate, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        this$0.copyCode(((QRCodeOutputData)((QRCodeDelegate)$delegate).getOutputData()).getQrCodeData());
    }

    public static final /* synthetic */ void access$outputDataChanged(SimpleQRCodeView $this, QRCodeOutputData outputData) {
        $this.outputDataChanged(outputData);
    }

    public static final /* synthetic */ void access$onTimerTick(SimpleQRCodeView $this, TimerData timerData) {
        $this.onTimerTick(timerData);
    }
}

