/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.util;

import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.util.AmountFormat;
import com.adyen.checkout.components.core.paymentmethod.GooglePayPaymentMethod;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.googlepay.MerchantInfo;
import com.adyen.checkout.googlepay.ShippingAddressParameters;
import com.adyen.checkout.googlepay.internal.data.model.CardParameters;
import com.adyen.checkout.googlepay.internal.data.model.GooglePayPaymentMethodModel;
import com.adyen.checkout.googlepay.internal.data.model.IsReadyToPayRequestModel;
import com.adyen.checkout.googlepay.internal.data.model.PaymentDataRequestModel;
import com.adyen.checkout.googlepay.internal.data.model.PaymentMethodTokenizationSpecification;
import com.adyen.checkout.googlepay.internal.data.model.TokenizationParameters;
import com.adyen.checkout.googlepay.internal.data.model.TransactionInfoModel;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.Wallet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u00100\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u001b\u00101\u001a\b\u0012\u0004\u0012\u00020\u0019022\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b3R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/adyen/checkout/googlepay/internal/util/GooglePayUtils;", "", "()V", "ADYEN_GATEWAY", "", "CARD_NETWORK", "GOOGLE_PAY_DECIMAL_FORMAT", "Ljava/text/DecimalFormat;", "GOOGLE_PAY_DECIMAL_SCALE", "", "INFO", "MAJOR_API_VERSION", "MINOT_API_VERSION", "NOT_CURRENTLY_KNOWN", "PAYMENT_GATEWAY", "PAYMENT_METHOD_DATA", "PAYMENT_TYPE_CARD", "TAG", "TOKEN", "TOKENIZATION_DATA", "createCardParameters", "Lcom/adyen/checkout/googlepay/internal/data/model/CardParameters;", "params", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "createCardPaymentMethod", "Lcom/adyen/checkout/googlepay/internal/data/model/GooglePayPaymentMethodModel;", "createGatewayParameters", "Lcom/adyen/checkout/googlepay/internal/data/model/TokenizationParameters;", "createGooglePayPaymentMethod", "Lcom/adyen/checkout/components/core/paymentmethod/GooglePayPaymentMethod;", "paymentData", "Lcom/google/android/gms/wallet/PaymentData;", "paymentMethodType", "checkoutAttemptId", "createIsReadyToPayRequest", "Lcom/google/android/gms/wallet/IsReadyToPayRequest;", "createIsReadyToPayRequestModel", "Lcom/adyen/checkout/googlepay/internal/data/model/IsReadyToPayRequestModel;", "createPaymentDataRequest", "Lcom/google/android/gms/wallet/PaymentDataRequest;", "createPaymentDataRequestModel", "Lcom/adyen/checkout/googlepay/internal/data/model/PaymentDataRequestModel;", "createTokenizationSpecification", "Lcom/adyen/checkout/googlepay/internal/data/model/PaymentMethodTokenizationSpecification;", "createTransactionInfo", "Lcom/adyen/checkout/googlepay/internal/data/model/TransactionInfoModel;", "createWalletOptions", "Lcom/google/android/gms/wallet/Wallet$WalletOptions;", "findToken", "getAllowedPaymentMethods", "", "getAllowedPaymentMethods$googlepay_release", "googlepay_release"})
public final class GooglePayUtils {
    @NotNull
    public static final GooglePayUtils INSTANCE = new GooglePayUtils();
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @NotNull
    private static final DecimalFormat GOOGLE_PAY_DECIMAL_FORMAT = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.ROOT));
    private static final int GOOGLE_PAY_DECIMAL_SCALE = 2;
    private static final int MAJOR_API_VERSION = 2;
    private static final int MINOT_API_VERSION = 0;
    @NotNull
    private static final String PAYMENT_TYPE_CARD = "CARD";
    @NotNull
    private static final String PAYMENT_GATEWAY = "PAYMENT_GATEWAY";
    @NotNull
    private static final String ADYEN_GATEWAY = "adyen";
    @NotNull
    private static final String PAYMENT_METHOD_DATA = "paymentMethodData";
    @NotNull
    private static final String INFO = "info";
    @NotNull
    private static final String CARD_NETWORK = "cardNetwork";
    @NotNull
    private static final String TOKENIZATION_DATA = "tokenizationData";
    @NotNull
    private static final String TOKEN = "token";
    @NotNull
    private static final String NOT_CURRENTLY_KNOWN = "NOT_CURRENTLY_KNOWN";

    private GooglePayUtils() {
    }

    @NotNull
    public final Wallet.WalletOptions createWalletOptions(@NotNull GooglePayComponentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Wallet.WalletOptions walletOptions = new Wallet.WalletOptions.Builder().setEnvironment(params.getGooglePayEnvironment()).build();
        Intrinsics.checkNotNullExpressionValue((Object)walletOptions, (String)"build(...)");
        return walletOptions;
    }

    @NotNull
    public final IsReadyToPayRequest createIsReadyToPayRequest(@NotNull GooglePayComponentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        IsReadyToPayRequestModel isReadyToPayRequestModel = this.createIsReadyToPayRequestModel(params);
        String string = IsReadyToPayRequestModel.SERIALIZER.serialize((ModelObject)isReadyToPayRequestModel).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String requestJsonString = string;
        IsReadyToPayRequest isReadyToPayRequest = IsReadyToPayRequest.fromJson((String)requestJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)isReadyToPayRequest, (String)"fromJson(...)");
        return isReadyToPayRequest;
    }

    @NotNull
    public final PaymentDataRequest createPaymentDataRequest(@NotNull GooglePayComponentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PaymentDataRequestModel paymentDataRequestModel = this.createPaymentDataRequestModel(params);
        String string = PaymentDataRequestModel.SERIALIZER.serialize((ModelObject)paymentDataRequestModel).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String requestJsonString = string;
        PaymentDataRequest paymentDataRequest = PaymentDataRequest.fromJson((String)requestJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)paymentDataRequest, (String)"fromJson(...)");
        return paymentDataRequest;
    }

    @NotNull
    public final String findToken(@NotNull PaymentData paymentData) throws CheckoutException {
        String string;
        Intrinsics.checkNotNullParameter((Object)paymentData, (String)"paymentData");
        try {
            JSONObject paymentDataJson = new JSONObject(paymentData.toJson());
            JSONObject paymentMethodDataJson = paymentDataJson.getJSONObject(PAYMENT_METHOD_DATA);
            JSONObject tokenizationDataJson = paymentMethodDataJson.getJSONObject(TOKENIZATION_DATA);
            string = tokenizationDataJson.getString(TOKEN);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (JSONException e) {
            throw new CheckoutException("Failed to find Google Pay token.", (Throwable)e);
        }
        return string;
    }

    @Nullable
    public final GooglePayPaymentMethod createGooglePayPaymentMethod(@Nullable PaymentData paymentData, @Nullable String paymentMethodType, @Nullable String checkoutAttemptId) {
        GooglePayPaymentMethod googlePayPaymentMethod;
        if (paymentData == null) {
            return null;
        }
        GooglePayPaymentMethod $this$createGooglePayPaymentMethod_u24lambda_u240 = googlePayPaymentMethod = new GooglePayPaymentMethod(paymentMethodType, checkoutAttemptId, null, null, 12, null);
        boolean bl = false;
        try {
            JSONObject paymentDataJson = new JSONObject(paymentData.toJson());
            JSONObject paymentMethodDataJson = paymentDataJson.getJSONObject(PAYMENT_METHOD_DATA);
            JSONObject tokenizationDataJson = paymentMethodDataJson.getJSONObject(TOKENIZATION_DATA);
            $this$createGooglePayPaymentMethod_u24lambda_u240.setGooglePayToken(tokenizationDataJson.getString(TOKEN));
            JSONObject infoJson = paymentMethodDataJson.optJSONObject(INFO);
            if (infoJson != null && infoJson.has(CARD_NETWORK)) {
                $this$createGooglePayPaymentMethod_u24lambda_u240.setGooglePayCardNetwork(infoJson.getString(CARD_NETWORK));
            }
        }
        catch (JSONException e) {
            Logger.e((String)TAG, (String)"Failed to find Google Pay token.", (Throwable)e);
        }
        return googlePayPaymentMethod;
    }

    private final IsReadyToPayRequestModel createIsReadyToPayRequestModel(GooglePayComponentParams params) {
        boolean bl = params.isExistingPaymentMethodRequired();
        List<GooglePayPaymentMethodModel> list = this.getAllowedPaymentMethods$googlepay_release(params);
        return new IsReadyToPayRequestModel(2, 0, list, bl);
    }

    private final PaymentDataRequestModel createPaymentDataRequestModel(GooglePayComponentParams params) {
        MerchantInfo merchantInfo = params.getMerchantInfo();
        TransactionInfoModel transactionInfoModel = this.createTransactionInfo(params);
        List<GooglePayPaymentMethodModel> list = this.getAllowedPaymentMethods$googlepay_release(params);
        boolean bl = params.isEmailRequired();
        boolean bl2 = params.isShippingAddressRequired();
        ShippingAddressParameters shippingAddressParameters = params.getShippingAddressParameters();
        return new PaymentDataRequestModel(2, 0, merchantInfo, list, transactionInfoModel, bl, bl2, shippingAddressParameters);
    }

    @NotNull
    public final List<GooglePayPaymentMethodModel> getAllowedPaymentMethods$googlepay_release(@NotNull GooglePayComponentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return CollectionsKt.listOf((Object)((Object)this.createCardPaymentMethod(params)));
    }

    private final GooglePayPaymentMethodModel createCardPaymentMethod(GooglePayComponentParams params) {
        return new GooglePayPaymentMethodModel(PAYMENT_TYPE_CARD, this.createCardParameters(params), this.createTokenizationSpecification(params));
    }

    private final CardParameters createCardParameters(GooglePayComponentParams params) {
        return new CardParameters(params.getAllowedAuthMethods(), params.getAllowedCardNetworks(), params.isAllowPrepaidCards(), params.isAllowCreditCards(), params.isAssuranceDetailsRequired(), params.isBillingAddressRequired(), params.getBillingAddressParameters());
    }

    private final PaymentMethodTokenizationSpecification createTokenizationSpecification(GooglePayComponentParams params) {
        return new PaymentMethodTokenizationSpecification(PAYMENT_GATEWAY, this.createGatewayParameters(params));
    }

    private final TokenizationParameters createGatewayParameters(GooglePayComponentParams params) {
        return new TokenizationParameters(ADYEN_GATEWAY, params.getGatewayMerchantId());
    }

    private final TransactionInfoModel createTransactionInfo(GooglePayComponentParams params) {
        Object object = params.getCountryCode();
        String string = params.getTotalPriceStatus();
        String string2 = params.getAmount().getCurrency();
        Object $this$createTransactionInfo_u24lambda_u241 = object = new TransactionInfoModel(string2, (String)object, null, string, null, null, null, 116, null);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)params.getTotalPriceStatus(), (Object)NOT_CURRENTLY_KNOWN)) {
            BigDecimal bigDecimalAmount = AmountFormat.toBigDecimal((Amount)params.getAmount()).setScale(2, RoundingMode.HALF_UP);
            String displayAmount = GOOGLE_PAY_DECIMAL_FORMAT.format(bigDecimalAmount);
            ((TransactionInfoModel)((Object)$this$createTransactionInfo_u24lambda_u241)).setTotalPrice(displayAmount);
        }
        return object;
    }
}

