/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.provider;

import android.app.Application;
import android.content.Context;
import androidx.activity.ComponentActivity;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import com.adyen.checkout.action.core.internal.DefaultActionHandlingComponent;
import com.adyen.checkout.action.core.internal.provider.GenericActionComponentProvider;
import com.adyen.checkout.action.core.internal.ui.GenericActionDelegate;
import com.adyen.checkout.components.core.ComponentAvailableCallback;
import com.adyen.checkout.components.core.ComponentCallback;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.BaseComponentCallback;
import com.adyen.checkout.components.core.internal.ComponentEventHandler;
import com.adyen.checkout.components.core.internal.Configuration;
import com.adyen.checkout.components.core.internal.DefaultComponentEventHandler;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentMethodAvailabilityCheck;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsMapper;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepositoryData;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsService;
import com.adyen.checkout.components.core.internal.data.api.DefaultAnalyticsRepository;
import com.adyen.checkout.components.core.internal.provider.PaymentComponentProvider;
import com.adyen.checkout.components.core.internal.ui.PaymentComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.components.core.internal.util.ViewModelExtKt;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.data.api.HttpClient;
import com.adyen.checkout.core.internal.data.api.HttpClientFactory;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.googlepay.GooglePayComponent;
import com.adyen.checkout.googlepay.GooglePayComponentState;
import com.adyen.checkout.googlepay.GooglePayConfiguration;
import com.adyen.checkout.googlepay.internal.ui.DefaultGooglePayDelegate;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParamsMapper;
import com.adyen.checkout.googlepay.internal.util.GooglePayUtils;
import com.adyen.checkout.sessions.core.CheckoutSession;
import com.adyen.checkout.sessions.core.SessionComponentCallback;
import com.adyen.checkout.sessions.core.internal.SessionComponentEventHandler;
import com.adyen.checkout.sessions.core.internal.SessionInteractor;
import com.adyen.checkout.sessions.core.internal.SessionSavedStateHandleContainer;
import com.adyen.checkout.sessions.core.internal.data.api.SessionRepository;
import com.adyen.checkout.sessions.core.internal.data.api.SessionService;
import com.adyen.checkout.sessions.core.internal.provider.SessionPaymentComponentProvider;
import com.adyen.checkout.sessions.core.internal.ui.model.SessionParamsFactory;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 .2 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u00012 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u00062\b\u0012\u0004\u0012\u00020\u00030\b:\u0001.B+\b\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J`\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016JX\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J*\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/adyen/checkout/googlepay/internal/provider/GooglePayComponentProvider;", "Lcom/adyen/checkout/components/core/internal/provider/PaymentComponentProvider;", "Lcom/adyen/checkout/googlepay/GooglePayComponent;", "Lcom/adyen/checkout/googlepay/GooglePayConfiguration;", "Lcom/adyen/checkout/googlepay/GooglePayComponentState;", "Lcom/adyen/checkout/components/core/ComponentCallback;", "Lcom/adyen/checkout/sessions/core/internal/provider/SessionPaymentComponentProvider;", "Lcom/adyen/checkout/sessions/core/SessionComponentCallback;", "Lcom/adyen/checkout/components/core/internal/PaymentMethodAvailabilityCheck;", "overrideComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "overrideSessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "analyticsRepository", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;", "(Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;)V", "componentParamsMapper", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper;", "assertSupported", "", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "get", "savedStateRegistryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "configuration", "application", "Landroid/app/Application;", "componentCallback", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "Lcom/adyen/checkout/components/core/Order;", "key", "", "checkoutSession", "Lcom/adyen/checkout/sessions/core/CheckoutSession;", "isAvailable", "applicationContext", "callback", "Lcom/adyen/checkout/components/core/ComponentAvailableCallback;", "isPaymentMethodSupported", "", "Companion", "googlepay_release"})
public final class GooglePayComponentProvider
implements PaymentComponentProvider<GooglePayComponent, GooglePayConfiguration, GooglePayComponentState, ComponentCallback<GooglePayComponentState>>,
SessionPaymentComponentProvider<GooglePayComponent, GooglePayConfiguration, GooglePayComponentState, SessionComponentCallback<GooglePayComponentState>>,
PaymentMethodAvailabilityCheck<GooglePayConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AnalyticsRepository analyticsRepository;
    @NotNull
    private final GooglePayComponentParamsMapper componentParamsMapper;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public GooglePayComponentProvider(@Nullable ComponentParams overrideComponentParams, @Nullable SessionParams overrideSessionParams, @Nullable AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
        this.componentParamsMapper = new GooglePayComponentParamsMapper(overrideComponentParams, overrideSessionParams);
    }

    public /* synthetic */ GooglePayComponentProvider(ComponentParams componentParams, SessionParams sessionParams, AnalyticsRepository analyticsRepository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            componentParams = null;
        }
        if ((n & 2) != 0) {
            sessionParams = null;
        }
        if ((n & 4) != 0) {
            analyticsRepository = null;
        }
        this(componentParams, sessionParams, analyticsRepository);
    }

    @NotNull
    public GooglePayComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull Application application, @NotNull ComponentCallback<GooglePayComponentState> componentCallback, @Nullable OrderRequest order, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(paymentMethod);
        GooglePayComponentParams componentParams = this.componentParamsMapper.mapToParams(configuration, paymentMethod, null);
        AbstractSavedStateViewModelFactory googlePayFactory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, GooglePayComponent>(this, application, componentParams, paymentMethod, order, configuration){
            final /* synthetic */ GooglePayComponentProvider this$0;
            final /* synthetic */ Application $application;
            final /* synthetic */ GooglePayComponentParams $componentParams;
            final /* synthetic */ PaymentMethod $paymentMethod;
            final /* synthetic */ OrderRequest $order;
            final /* synthetic */ GooglePayConfiguration $configuration;
            {
                this.this$0 = $receiver;
                this.$application = $application;
                this.$componentParams = $componentParams;
                this.$paymentMethod = $paymentMethod;
                this.$order = $order;
                this.$configuration = $configuration;
                super(1);
            }

            @NotNull
            public final GooglePayComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                AnalyticsRepository analyticsRepository = GooglePayComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)this.$componentParams, this.$paymentMethod, null, 8, null), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(this.$componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                DefaultGooglePayDelegate googlePayDelegate = new DefaultGooglePayDelegate(new PaymentObserverRepository(null, 1, null), this.$paymentMethod, this.$order, this.$componentParams, analyticsRepository2);
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)this.$componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$googlepay_release(), savedStateHandle, this.$application);
                return new GooglePayComponent(googlePayDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)googlePayDelegate), (ComponentEventHandler<GooglePayComponentState>)((ComponentEventHandler)new DefaultComponentEventHandler()));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)googlePayFactory2), (String)key, GooglePayComponent.class);
        GooglePayComponent component = (GooglePayComponent)viewModel;
        boolean bl = false;
        component.observe$googlepay_release(lifecycleOwner, (Function1<? super PaymentComponentEvent<GooglePayComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<GooglePayComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ GooglePayComponent $component;
            final /* synthetic */ ComponentCallback<GooglePayComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<GooglePayComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$googlepay_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (GooglePayComponent)viewModel;
    }

    @NotNull
    public GooglePayComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull Application application, @NotNull SessionComponentCallback<GooglePayComponentState> componentCallback, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)checkoutSession, (String)"checkoutSession");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(paymentMethod);
        GooglePayComponentParams componentParams = this.componentParamsMapper.mapToParams(configuration, paymentMethod, SessionParamsFactory.INSTANCE.create(checkoutSession));
        AbstractSavedStateViewModelFactory googlePayFactory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, GooglePayComponent>(componentParams, this, application, paymentMethod, checkoutSession, configuration){
            final /* synthetic */ GooglePayComponentParams $componentParams;
            final /* synthetic */ GooglePayComponentProvider this$0;
            final /* synthetic */ Application $application;
            final /* synthetic */ PaymentMethod $paymentMethod;
            final /* synthetic */ CheckoutSession $checkoutSession;
            final /* synthetic */ GooglePayConfiguration $configuration;
            {
                this.$componentParams = $componentParams;
                this.this$0 = $receiver;
                this.$application = $application;
                this.$paymentMethod = $paymentMethod;
                this.$checkoutSession = $checkoutSession;
                this.$configuration = $configuration;
                super(1);
            }

            @NotNull
            public final GooglePayComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                HttpClient httpClient = HttpClientFactory.INSTANCE.getHttpClient(this.$componentParams.getEnvironment());
                AnalyticsRepository analyticsRepository = GooglePayComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)this.$componentParams, this.$paymentMethod, this.$checkoutSession.getSessionSetupResponse().getId()), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(this.$componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                DefaultGooglePayDelegate googlePayDelegate = new DefaultGooglePayDelegate(new PaymentObserverRepository(null, 1, null), this.$paymentMethod, this.$checkoutSession.getOrder(), this.$componentParams, analyticsRepository2);
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)this.$componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$googlepay_release(), savedStateHandle, this.$application);
                SessionSavedStateHandleContainer sessionSavedStateHandleContainer = new SessionSavedStateHandleContainer(savedStateHandle, this.$checkoutSession);
                Boolean bl = sessionSavedStateHandleContainer.isFlowTakenOver();
                SessionInteractor sessionInteractor = new SessionInteractor(new SessionRepository(new SessionService(httpClient), this.$componentParams.getClientKey()), sessionSavedStateHandleContainer.getSessionModel(), bl != null ? bl : false);
                SessionComponentEventHandler sessionComponentEventHandler = new SessionComponentEventHandler(sessionInteractor, sessionSavedStateHandleContainer);
                return new GooglePayComponent(googlePayDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)googlePayDelegate), (ComponentEventHandler<GooglePayComponentState>)((ComponentEventHandler)sessionComponentEventHandler));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)googlePayFactory2), (String)key, GooglePayComponent.class);
        GooglePayComponent component = (GooglePayComponent)viewModel;
        boolean bl = false;
        component.observe$googlepay_release(lifecycleOwner, (Function1<? super PaymentComponentEvent<GooglePayComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<GooglePayComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ GooglePayComponent $component;
            final /* synthetic */ SessionComponentCallback<GooglePayComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<GooglePayComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$googlepay_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (GooglePayComponent)viewModel;
    }

    public void isAvailable(@NotNull Application applicationContext, @NotNull PaymentMethod paymentMethod, @Nullable GooglePayConfiguration configuration, @NotNull ComponentAvailableCallback callback) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (configuration == null) {
            throw new CheckoutException("GooglePayConfiguration cannot be null", null, 2, null);
        }
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)applicationContext) != 0) {
            callback.onAvailabilityResult(false, paymentMethod);
            return;
        }
        WeakReference<ComponentAvailableCallback> callbackWeakReference = new WeakReference<ComponentAvailableCallback>(callback);
        GooglePayComponentParams componentParams = this.componentParamsMapper.mapToParams(configuration, paymentMethod, null);
        PaymentsClient paymentsClient = Wallet.getPaymentsClient((Context)((Context)applicationContext), (Wallet.WalletOptions)GooglePayUtils.INSTANCE.createWalletOptions(componentParams));
        Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(...)");
        PaymentsClient paymentsClient2 = paymentsClient;
        IsReadyToPayRequest readyToPayRequest = GooglePayUtils.INSTANCE.createIsReadyToPayRequest(componentParams);
        Task task = paymentsClient2.isReadyToPay(readyToPayRequest);
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"isReadyToPay(...)");
        Task readyToPayTask = task;
        readyToPayTask.addOnSuccessListener(arg_0 -> GooglePayComponentProvider.isAvailable$lambda$2((Function1)new Function1<Boolean, Unit>(callbackWeakReference, paymentMethod){
            final /* synthetic */ WeakReference<ComponentAvailableCallback> $callbackWeakReference;
            final /* synthetic */ PaymentMethod $paymentMethod;
            {
                this.$callbackWeakReference = $callbackWeakReference;
                this.$paymentMethod = $paymentMethod;
                super(1);
            }

            public final void invoke(Boolean result) {
                block0: {
                    ComponentAvailableCallback componentAvailableCallback = (ComponentAvailableCallback)this.$callbackWeakReference.get();
                    if (componentAvailableCallback == null) break block0;
                    componentAvailableCallback.onAvailabilityResult(Intrinsics.areEqual((Object)result, (Object)true), this.$paymentMethod);
                }
            }
        }, arg_0));
        readyToPayTask.addOnCanceledListener(() -> GooglePayComponentProvider.isAvailable$lambda$3(callbackWeakReference, paymentMethod));
        readyToPayTask.addOnFailureListener(arg_0 -> GooglePayComponentProvider.isAvailable$lambda$4(callbackWeakReference, paymentMethod, arg_0));
    }

    private final void assertSupported(PaymentMethod paymentMethod) {
        if (!this.isPaymentMethodSupported(paymentMethod)) {
            throw new ComponentException("Unsupported payment method " + paymentMethod.getType(), null, 2, null);
        }
    }

    public boolean isPaymentMethodSupported(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        return CollectionsKt.contains((Iterable)GooglePayComponent.PAYMENT_METHOD_TYPES, (Object)paymentMethod.getType());
    }

    @NotNull
    public GooglePayComponent get(@NotNull ComponentActivity activity, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull ComponentCallback<GooglePayComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (GooglePayComponent)PaymentComponentProvider.DefaultImpls.get((PaymentComponentProvider)this, (ComponentActivity)activity, (PaymentMethod)paymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public GooglePayComponent get(@NotNull Fragment fragment, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull ComponentCallback<GooglePayComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (GooglePayComponent)PaymentComponentProvider.DefaultImpls.get((PaymentComponentProvider)this, (Fragment)fragment, (PaymentMethod)paymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public GooglePayComponent get(@NotNull ComponentActivity activity, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull SessionComponentCallback<GooglePayComponentState> componentCallback, @Nullable String key) {
        return (GooglePayComponent)SessionPaymentComponentProvider.DefaultImpls.get((SessionPaymentComponentProvider)this, (ComponentActivity)activity, (CheckoutSession)checkoutSession, (PaymentMethod)paymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    @NotNull
    public GooglePayComponent get(@NotNull Fragment fragment, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull GooglePayConfiguration configuration, @NotNull SessionComponentCallback<GooglePayComponentState> componentCallback, @Nullable String key) {
        return (GooglePayComponent)SessionPaymentComponentProvider.DefaultImpls.get((SessionPaymentComponentProvider)this, (Fragment)fragment, (CheckoutSession)checkoutSession, (PaymentMethod)paymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    private static final void isAvailable$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void isAvailable$lambda$3(WeakReference $callbackWeakReference, PaymentMethod $paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$callbackWeakReference, (String)"$callbackWeakReference");
            Intrinsics.checkNotNullParameter((Object)$paymentMethod, (String)"$paymentMethod");
            Logger.e((String)TAG, (String)"GooglePay readyToPay task is cancelled.");
            ComponentAvailableCallback componentAvailableCallback = (ComponentAvailableCallback)$callbackWeakReference.get();
            if (componentAvailableCallback == null) break block0;
            componentAvailableCallback.onAvailabilityResult(false, $paymentMethod);
        }
    }

    private static final void isAvailable$lambda$4(WeakReference $callbackWeakReference, PaymentMethod $paymentMethod, Exception it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$callbackWeakReference, (String)"$callbackWeakReference");
            Intrinsics.checkNotNullParameter((Object)$paymentMethod, (String)"$paymentMethod");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Logger.e((String)TAG, (String)"GooglePay readyToPay task is failed.", (Throwable)it);
            ComponentAvailableCallback componentAvailableCallback = (ComponentAvailableCallback)$callbackWeakReference.get();
            if (componentAvailableCallback == null) break block0;
            componentAvailableCallback.onAvailabilityResult(false, $paymentMethod);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public GooglePayComponentProvider() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ AnalyticsRepository access$getAnalyticsRepository$p(GooglePayComponentProvider $this) {
        return $this.analyticsRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/googlepay/internal/provider/GooglePayComponentProvider$Companion;", "", "()V", "TAG", "", "googlepay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

