/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.model.RequestOptions;
import com.adyen.model.modification.AbstractModificationRequest;
import com.adyen.model.modification.AdjustAuthorisationRequest;
import com.adyen.model.modification.CancelOrRefundRequest;
import com.adyen.model.modification.CancelRequest;
import com.adyen.model.modification.CaptureRequest;
import com.adyen.model.modification.DonationRequest;
import com.adyen.model.modification.ModificationResult;
import com.adyen.model.modification.RefundRequest;
import com.adyen.model.modification.TechnicalCancelRequest;
import com.adyen.model.modification.VoidPendingRefundRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.modification.AdjustAuthorisation;
import com.adyen.service.resource.modification.Cancel;
import com.adyen.service.resource.modification.CancelOrRefund;
import com.adyen.service.resource.modification.Capture;
import com.adyen.service.resource.modification.Donate;
import com.adyen.service.resource.modification.Refund;
import com.adyen.service.resource.modification.TechnicalCancel;
import com.adyen.service.resource.modification.VoidPendingRefund;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public class Modification
extends Service {
    private CancelOrRefund cancelOrRefund;
    private Cancel cancel;
    private Capture capture = new Capture(this);
    private Refund refund;
    private AdjustAuthorisation adjustAuthorisation;
    private TechnicalCancel technicalCancel;
    private VoidPendingRefund voidPendingRefund;
    private Donate donate;

    public Modification(Client client) {
        super(client);
        this.cancelOrRefund = new CancelOrRefund(this);
        this.cancel = new Cancel(this);
        this.refund = new Refund(this);
        this.adjustAuthorisation = new AdjustAuthorisation(this);
        this.technicalCancel = new TechnicalCancel(this);
        this.voidPendingRefund = new VoidPendingRefund(this);
        this.donate = new Donate(this);
    }

    public ModificationResult capture(CaptureRequest captureRequest) throws IOException, ApiException {
        return this.capture(captureRequest, null);
    }

    public ModificationResult capture(CaptureRequest captureRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(captureRequest);
        String jsonResult = this.capture.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest) throws IOException, ApiException {
        return this.cancelOrRefund(cancelOrRefundRequest, null);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(cancelOrRefundRequest);
        String jsonResult = this.cancelOrRefund.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult refund(RefundRequest refundRequest) throws IOException, ApiException {
        return this.refund(refundRequest, null);
    }

    public ModificationResult refund(RefundRequest refundRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(refundRequest);
        String jsonResult = this.refund.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult cancel(CancelRequest cancelRequest) throws IOException, ApiException {
        return this.cancel(cancelRequest, null);
    }

    public ModificationResult cancel(CancelRequest cancelRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(cancelRequest);
        String jsonResult = this.cancel.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest) throws IOException, ApiException {
        return this.technicalCancel(technicalCancelRequest, null);
    }

    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(technicalCancelRequest);
        String jsonResult = this.technicalCancel.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult adjustAuthorization(AdjustAuthorisationRequest adjustAuthorisationRequest) throws IOException, ApiException {
        return this.adjustAuthorization(adjustAuthorisationRequest, null);
    }

    public ModificationResult adjustAuthorization(AdjustAuthorisationRequest adjustAuthorisationRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(adjustAuthorisationRequest);
        String jsonResult = this.adjustAuthorisation.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest) throws IOException, ApiException {
        return this.voidPendingRefund(voidPendingRefundRequest, null);
    }

    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(voidPendingRefundRequest);
        String jsonResult = this.voidPendingRefund.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult donate(DonationRequest donationRequest) throws IOException, ApiException {
        return this.donate(donationRequest, null);
    }

    public ModificationResult donate(DonationRequest donationRequest, RequestOptions requestOptions) throws IOException, ApiException {
        String jsonRequest = this.serializeDonationRequest(donationRequest);
        String jsonResult = this.donate.request(jsonRequest, requestOptions);
        return this.deserializeResponse(jsonResult);
    }

    private String serializeRequest(AbstractModificationRequest modificationRequest) {
        String jsonRequest = GSON.toJson((Object)modificationRequest);
        return jsonRequest;
    }

    private String serializeDonationRequest(DonationRequest donationRequest) {
        String jsonRequest = GSON.toJson((Object)donationRequest);
        return jsonRequest;
    }

    private ModificationResult deserializeResponse(String jsonResult) {
        ModificationResult modificationResult = (ModificationResult)GSON.fromJson(jsonResult, new TypeToken<ModificationResult>(){}.getType());
        return modificationResult;
    }
}

