/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Config;
import com.adyen.Service;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.ApiError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;

public class Resource {
    protected static final Gson GSON = new Gson();
    protected String endpoint;
    protected List<String> requiredFields;
    private Service service;

    public Resource(Service service, String endpoint, List<String> requiredFields) {
        this.service = service;
        this.endpoint = endpoint;
        this.requiredFields = requiredFields;
    }

    public String request(String json) throws ApiException, IOException {
        return this.request(json, null);
    }

    public String request(String json, RequestOptions requestOptions) throws ApiException, IOException {
        ClientInterface clientInterface = this.service.getClient().getHttpClient();
        Config config = this.service.getClient().getConfig();
        try {
            return clientInterface.request(this.endpoint, json, config, this.service.isApiKeyRequired(), requestOptions);
        }
        catch (HTTPClientException e) {
            String responseBody = e.getResponseBody();
            ApiException apiException = new ApiException(e.getMessage(), e.getCode(), e.getResponseHeaders());
            try {
                ApiError apiError = (ApiError)GSON.fromJson(responseBody, new TypeToken<ApiError>(){}.getType());
                apiException.setError(apiError);
            }
            catch (JsonSyntaxException ignored) {
                throw new ApiException("Invalid response or an invalid X-API-Key key was used", apiException.getStatusCode());
            }
            throw apiException;
        }
    }
}

