/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.PaymentAmountUpdateRequest;
import com.adyen.model.checkout.PaymentAmountUpdateResponse;
import com.adyen.model.checkout.PaymentCancelRequest;
import com.adyen.model.checkout.PaymentCancelResponse;
import com.adyen.model.checkout.PaymentCaptureRequest;
import com.adyen.model.checkout.PaymentCaptureResponse;
import com.adyen.model.checkout.PaymentRefundRequest;
import com.adyen.model.checkout.PaymentRefundResponse;
import com.adyen.model.checkout.PaymentReversalRequest;
import com.adyen.model.checkout.PaymentReversalResponse;
import com.adyen.model.checkout.StandalonePaymentCancelRequest;
import com.adyen.model.checkout.StandalonePaymentCancelResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ModificationsApi
extends Service {
    public static final String API_VERSION = "71";
    protected String baseURL;

    public ModificationsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://checkout-test.adyen.com/v71");
    }

    public ModificationsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public StandalonePaymentCancelResponse cancelAuthorisedPayment(StandalonePaymentCancelRequest standalonePaymentCancelRequest) throws ApiException, IOException {
        return this.cancelAuthorisedPayment(standalonePaymentCancelRequest, null);
    }

    public StandalonePaymentCancelResponse cancelAuthorisedPayment(StandalonePaymentCancelRequest standalonePaymentCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = standalonePaymentCancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cancels", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return StandalonePaymentCancelResponse.fromJson(jsonResult);
    }

    public PaymentCancelResponse cancelAuthorisedPaymentByPspReference(String paymentPspReference, PaymentCancelRequest paymentCancelRequest) throws ApiException, IOException {
        return this.cancelAuthorisedPaymentByPspReference(paymentPspReference, paymentCancelRequest, null);
    }

    public PaymentCancelResponse cancelAuthorisedPaymentByPspReference(String paymentPspReference, PaymentCancelRequest paymentCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentPspReference == null) {
            throw new IllegalArgumentException("Please provide the paymentPspReference path parameter");
        }
        pathParams.put("paymentPspReference", paymentPspReference);
        String requestBody = paymentCancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/{paymentPspReference}/cancels", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentCancelResponse.fromJson(jsonResult);
    }

    public PaymentCaptureResponse captureAuthorisedPayment(String paymentPspReference, PaymentCaptureRequest paymentCaptureRequest) throws ApiException, IOException {
        return this.captureAuthorisedPayment(paymentPspReference, paymentCaptureRequest, null);
    }

    public PaymentCaptureResponse captureAuthorisedPayment(String paymentPspReference, PaymentCaptureRequest paymentCaptureRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentPspReference == null) {
            throw new IllegalArgumentException("Please provide the paymentPspReference path parameter");
        }
        pathParams.put("paymentPspReference", paymentPspReference);
        String requestBody = paymentCaptureRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/{paymentPspReference}/captures", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentCaptureResponse.fromJson(jsonResult);
    }

    public PaymentRefundResponse refundCapturedPayment(String paymentPspReference, PaymentRefundRequest paymentRefundRequest) throws ApiException, IOException {
        return this.refundCapturedPayment(paymentPspReference, paymentRefundRequest, null);
    }

    public PaymentRefundResponse refundCapturedPayment(String paymentPspReference, PaymentRefundRequest paymentRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentPspReference == null) {
            throw new IllegalArgumentException("Please provide the paymentPspReference path parameter");
        }
        pathParams.put("paymentPspReference", paymentPspReference);
        String requestBody = paymentRefundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/{paymentPspReference}/refunds", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentRefundResponse.fromJson(jsonResult);
    }

    public PaymentReversalResponse refundOrCancelPayment(String paymentPspReference, PaymentReversalRequest paymentReversalRequest) throws ApiException, IOException {
        return this.refundOrCancelPayment(paymentPspReference, paymentReversalRequest, null);
    }

    public PaymentReversalResponse refundOrCancelPayment(String paymentPspReference, PaymentReversalRequest paymentReversalRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentPspReference == null) {
            throw new IllegalArgumentException("Please provide the paymentPspReference path parameter");
        }
        pathParams.put("paymentPspReference", paymentPspReference);
        String requestBody = paymentReversalRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/{paymentPspReference}/reversals", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentReversalResponse.fromJson(jsonResult);
    }

    public PaymentAmountUpdateResponse updateAuthorisedAmount(String paymentPspReference, PaymentAmountUpdateRequest paymentAmountUpdateRequest) throws ApiException, IOException {
        return this.updateAuthorisedAmount(paymentPspReference, paymentAmountUpdateRequest, null);
    }

    public PaymentAmountUpdateResponse updateAuthorisedAmount(String paymentPspReference, PaymentAmountUpdateRequest paymentAmountUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentPspReference == null) {
            throw new IllegalArgumentException("Please provide the paymentPspReference path parameter");
        }
        pathParams.put("paymentPspReference", paymentPspReference);
        String requestBody = paymentAmountUpdateRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/payments/{paymentPspReference}/amountUpdates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentAmountUpdateResponse.fromJson(jsonResult);
    }
}

