/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.capital;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.capital.Disbursement;
import com.adyen.model.capital.DisbursementInfoUpdate;
import com.adyen.model.capital.Disbursements;
import com.adyen.model.capital.Grant;
import com.adyen.model.capital.GrantInfo;
import com.adyen.model.capital.Grants;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class GrantsApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public GrantsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/capital/v1");
    }

    public GrantsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Disbursements getAllGrantDisbursements(String grantId) throws ApiException, IOException {
        return this.getAllGrantDisbursements(grantId, null);
    }

    public Disbursements getAllGrantDisbursements(String grantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (grantId == null) {
            throw new IllegalArgumentException("Please provide the grantId path parameter");
        }
        pathParams.put("grantId", grantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants/{grantId}/disbursements", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Disbursements.fromJson(jsonResult);
    }

    public Grants getAllGrants(String counterpartyAccountHolderId) throws ApiException, IOException {
        return this.getAllGrants(counterpartyAccountHolderId, null);
    }

    public Grants getAllGrants(String counterpartyAccountHolderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (counterpartyAccountHolderId != null) {
            queryParams.put("counterpartyAccountHolderId", counterpartyAccountHolderId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return Grants.fromJson(jsonResult);
    }

    public Grant getGrant(String grantId) throws ApiException, IOException {
        return this.getGrant(grantId, null);
    }

    public Grant getGrant(String grantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (grantId == null) {
            throw new IllegalArgumentException("Please provide the grantId path parameter");
        }
        pathParams.put("grantId", grantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants/{grantId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Grant.fromJson(jsonResult);
    }

    public Disbursement getGrantDisbursement(String grantId, String disbursementId) throws ApiException, IOException {
        return this.getGrantDisbursement(grantId, disbursementId, null);
    }

    public Disbursement getGrantDisbursement(String grantId, String disbursementId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (grantId == null) {
            throw new IllegalArgumentException("Please provide the grantId path parameter");
        }
        pathParams.put("grantId", grantId);
        if (disbursementId == null) {
            throw new IllegalArgumentException("Please provide the disbursementId path parameter");
        }
        pathParams.put("disbursementId", disbursementId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants/{grantId}/disbursements/{disbursementId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Disbursement.fromJson(jsonResult);
    }

    public Grant requestGrant(GrantInfo grantInfo) throws ApiException, IOException {
        return this.requestGrant(grantInfo, null);
    }

    public Grant requestGrant(GrantInfo grantInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = grantInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Grant.fromJson(jsonResult);
    }

    public Disbursement updateGrantDisbursement(String grantId, String disbursementId, DisbursementInfoUpdate disbursementInfoUpdate) throws ApiException, IOException {
        return this.updateGrantDisbursement(grantId, disbursementId, disbursementInfoUpdate, null);
    }

    public Disbursement updateGrantDisbursement(String grantId, String disbursementId, DisbursementInfoUpdate disbursementInfoUpdate, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (grantId == null) {
            throw new IllegalArgumentException("Please provide the grantId path parameter");
        }
        pathParams.put("grantId", grantId);
        if (disbursementId == null) {
            throw new IllegalArgumentException("Please provide the disbursementId path parameter");
        }
        pathParams.put("disbursementId", disbursementId);
        String requestBody = disbursementInfoUpdate.toJson();
        Resource resource = new Resource(this, this.baseURL + "/grants/{grantId}/disbursements/{disbursementId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Disbursement.fromJson(jsonResult);
    }
}

