/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.adyen.model.payment.SplitAmount;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"account", "amount", "description", "reference", "type"})
public class Split {
    public static final String JSON_PROPERTY_ACCOUNT = "account";
    private String account;
    private boolean isSetAccount = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private SplitAmount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    private boolean isSetDescription = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Split account(String account) {
        this.account = account;
        this.isSetAccount = true;
        return this;
    }

    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccount(String account) {
        this.account = account;
        this.isSetAccount = true;
    }

    public Split amount(SplitAmount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SplitAmount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(SplitAmount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public Split description(String description) {
        this.description = description;
        this.isSetDescription = true;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
        this.isSetDescription = true;
    }

    public Split reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public Split type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public Split includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        return Objects.equals(this.account, split.account) && Objects.equals(this.isSetAccount, split.isSetAccount) && Objects.equals(this.amount, split.amount) && Objects.equals(this.isSetAmount, split.isSetAmount) && Objects.equals(this.description, split.description) && Objects.equals(this.isSetDescription, split.isSetDescription) && Objects.equals(this.reference, split.reference) && Objects.equals(this.isSetReference, split.isSetReference) && Objects.equals((Object)this.type, (Object)split.type) && Objects.equals(this.isSetType, split.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.isSetAccount, this.amount, this.isSetAmount, this.description, this.isSetDescription, this.reference, this.isSetReference, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Split {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_ACCOUNT, this.account);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetDescription) {
            this.addIfNull(nulls, JSON_PROPERTY_DESCRIPTION, this.description);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Split fromJson(String jsonString) throws JsonProcessingException {
        return (Split)JSON.getMapper().readValue(jsonString, Split.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ACQUIRINGFEES(String.valueOf("AcquiringFees")),
        ADYENCOMMISSION(String.valueOf("AdyenCommission")),
        ADYENFEES(String.valueOf("AdyenFees")),
        ADYENMARKUP(String.valueOf("AdyenMarkup")),
        BALANCEACCOUNT(String.valueOf("BalanceAccount")),
        COMMISSION(String.valueOf("Commission")),
        DEFAULT(String.valueOf("Default")),
        INTERCHANGE(String.valueOf("Interchange")),
        MARKETPLACE(String.valueOf("MarketPlace")),
        PAYMENTFEE(String.valueOf("PaymentFee")),
        REMAINDER(String.valueOf("Remainder")),
        SCHEMEFEE(String.valueOf("SchemeFee")),
        SURCHARGE(String.valueOf("Surcharge")),
        TIP(String.valueOf("Tip")),
        TOPUP(String.valueOf("TopUp")),
        VAT(String.valueOf("VAT"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

