/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.FraudResult;
import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "authCode", "dccAmount", "dccSignature", "fraudResult", "issuerUrl", "md", "paRequest", "pspReference", "refusalReason", "resultCode"})
public class PaymentResult {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    private boolean isSetAuthCode = false;
    public static final String JSON_PROPERTY_DCC_AMOUNT = "dccAmount";
    private Amount dccAmount;
    private boolean isSetDccAmount = false;
    public static final String JSON_PROPERTY_DCC_SIGNATURE = "dccSignature";
    private String dccSignature;
    private boolean isSetDccSignature = false;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    private boolean isSetFraudResult = false;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    private boolean isSetIssuerUrl = false;
    public static final String JSON_PROPERTY_MD = "md";
    private String md;
    private boolean isSetMd = false;
    public static final String JSON_PROPERTY_PA_REQUEST = "paRequest";
    private String paRequest;
    private boolean isSetPaRequest = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    private boolean isSetRefusalReason = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaymentResult additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public PaymentResult putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public PaymentResult authCode(String authCode) {
        this.authCode = authCode;
        this.isSetAuthCode = true;
        return this;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
        this.isSetAuthCode = true;
    }

    public PaymentResult dccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        this.isSetDccAmount = true;
        return this;
    }

    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getDccAmount() {
        return this.dccAmount;
    }

    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        this.isSetDccAmount = true;
    }

    public PaymentResult dccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        this.isSetDccSignature = true;
        return this;
    }

    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDccSignature() {
        return this.dccSignature;
    }

    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        this.isSetDccSignature = true;
    }

    public PaymentResult fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
    }

    public PaymentResult issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        this.isSetIssuerUrl = true;
        return this;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        this.isSetIssuerUrl = true;
    }

    public PaymentResult md(String md) {
        this.md = md;
        this.isSetMd = true;
        return this;
    }

    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMd() {
        return this.md;
    }

    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMd(String md) {
        this.md = md;
        this.isSetMd = true;
    }

    public PaymentResult paRequest(String paRequest) {
        this.paRequest = paRequest;
        this.isSetPaRequest = true;
        return this;
    }

    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaRequest() {
        return this.paRequest;
    }

    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaRequest(String paRequest) {
        this.paRequest = paRequest;
        this.isSetPaRequest = true;
    }

    public PaymentResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public PaymentResult refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
    }

    public PaymentResult resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public PaymentResult includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResult paymentResult = (PaymentResult)o;
        return Objects.equals(this.additionalData, paymentResult.additionalData) && Objects.equals(this.isSetAdditionalData, paymentResult.isSetAdditionalData) && Objects.equals(this.authCode, paymentResult.authCode) && Objects.equals(this.isSetAuthCode, paymentResult.isSetAuthCode) && Objects.equals(this.dccAmount, paymentResult.dccAmount) && Objects.equals(this.isSetDccAmount, paymentResult.isSetDccAmount) && Objects.equals(this.dccSignature, paymentResult.dccSignature) && Objects.equals(this.isSetDccSignature, paymentResult.isSetDccSignature) && Objects.equals(this.fraudResult, paymentResult.fraudResult) && Objects.equals(this.isSetFraudResult, paymentResult.isSetFraudResult) && Objects.equals(this.issuerUrl, paymentResult.issuerUrl) && Objects.equals(this.isSetIssuerUrl, paymentResult.isSetIssuerUrl) && Objects.equals(this.md, paymentResult.md) && Objects.equals(this.isSetMd, paymentResult.isSetMd) && Objects.equals(this.paRequest, paymentResult.paRequest) && Objects.equals(this.isSetPaRequest, paymentResult.isSetPaRequest) && Objects.equals(this.pspReference, paymentResult.pspReference) && Objects.equals(this.isSetPspReference, paymentResult.isSetPspReference) && Objects.equals(this.refusalReason, paymentResult.refusalReason) && Objects.equals(this.isSetRefusalReason, paymentResult.isSetRefusalReason) && Objects.equals((Object)this.resultCode, (Object)paymentResult.resultCode) && Objects.equals(this.isSetResultCode, paymentResult.isSetResultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.authCode, this.isSetAuthCode, this.dccAmount, this.isSetDccAmount, this.dccSignature, this.isSetDccSignature, this.fraudResult, this.isSetFraudResult, this.issuerUrl, this.isSetIssuerUrl, this.md, this.isSetMd, this.paRequest, this.isSetPaRequest, this.pspReference, this.isSetPspReference, this.refusalReason, this.isSetRefusalReason, this.resultCode, this.isSetResultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResult {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    dccAmount: ").append(this.toIndentedString(this.dccAmount)).append("\n");
        sb.append("    dccSignature: ").append(this.toIndentedString(this.dccSignature)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    paRequest: ").append(this.toIndentedString(this.paRequest)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetAuthCode) {
            this.addIfNull(nulls, JSON_PROPERTY_AUTH_CODE, this.authCode);
        }
        if (this.isSetDccAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_DCC_AMOUNT, this.dccAmount);
        }
        if (this.isSetDccSignature) {
            this.addIfNull(nulls, JSON_PROPERTY_DCC_SIGNATURE, this.dccSignature);
        }
        if (this.isSetFraudResult) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_RESULT, this.fraudResult);
        }
        if (this.isSetIssuerUrl) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUER_URL, this.issuerUrl);
        }
        if (this.isSetMd) {
            this.addIfNull(nulls, JSON_PROPERTY_MD, this.md);
        }
        if (this.isSetPaRequest) {
            this.addIfNull(nulls, JSON_PROPERTY_PA_REQUEST, this.paRequest);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON, this.refusalReason);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaymentResult fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentResult)JSON.getMapper().readValue(jsonString, PaymentResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),
        AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),
        AUTHORISED(String.valueOf("Authorised")),
        CANCELLED(String.valueOf("Cancelled")),
        CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),
        ERROR(String.valueOf("Error")),
        IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),
        PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),
        PENDING(String.valueOf("Pending")),
        PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),
        RECEIVED(String.valueOf("Received")),
        REDIRECTSHOPPER(String.valueOf("RedirectShopper")),
        REFUSED(String.valueOf("Refused")),
        SUCCESS(String.valueOf("Success"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

