/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"city", "country", "houseNumberOrName", "postalCode", "stateOrProvince", "street"})
public class ViasAddress {
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_HOUSE_NUMBER_OR_NAME = "houseNumberOrName";
    private String houseNumberOrName;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "stateOrProvince";
    private String stateOrProvince;
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;

    public ViasAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The name of the city. Required if the `houseNumberOrName`, `street`, `postalCode`, or `stateOrProvince` are provided.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public ViasAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character country code of the address in ISO-3166-1 alpha-2 format. For example, **NL**.")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public ViasAddress houseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
        return this;
    }

    @ApiModelProperty(value="The number or name of the house.")
    @JsonProperty(value="houseNumberOrName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHouseNumberOrName() {
        return this.houseNumberOrName;
    }

    @JsonProperty(value="houseNumberOrName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHouseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
    }

    public ViasAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code. Required if the `houseNumberOrName`, `street`, `city`, or `stateOrProvince` are provided.  Maximum length:  * 5 digits for addresses in the US.  * 10 characters for all other countries.")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public ViasAddress stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The abbreviation of the state or province. Required if the `houseNumberOrName`, `street`, `city`, or `postalCode` are provided.   Maximum length:  * 2 characters for addresses in the US or Canada.  * 3 characters for all other countries. ")
    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public ViasAddress street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(value="The name of the street. Required if the `houseNumberOrName`, `city`, `postalCode`, or `stateOrProvince` are provided.")
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreet(String street) {
        this.street = street;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViasAddress viasAddress = (ViasAddress)o;
        return Objects.equals(this.city, viasAddress.city) && Objects.equals(this.country, viasAddress.country) && Objects.equals(this.houseNumberOrName, viasAddress.houseNumberOrName) && Objects.equals(this.postalCode, viasAddress.postalCode) && Objects.equals(this.stateOrProvince, viasAddress.stateOrProvince) && Objects.equals(this.street, viasAddress.street);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.houseNumberOrName, this.postalCode, this.stateOrProvince, this.street);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViasAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    houseNumberOrName: ").append(this.toIndentedString(this.houseNumberOrName)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ViasAddress fromJson(String jsonString) throws JsonProcessingException {
        return (ViasAddress)JSON.getMapper().readValue(jsonString, ViasAddress.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

