/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.ViasAddress;
import com.adyen.model.marketpayaccount.ViasName;
import com.adyen.model.marketpayaccount.ViasPersonalData;
import com.adyen.model.marketpayaccount.ViasPhoneNumber;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "email", "fullPhoneNumber", "jobTitle", "name", "personalData", "phoneNumber", "signatoryCode", "signatoryReference", "webAddress"})
public class SignatoryContact {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
    private String fullPhoneNumber;
    public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
    private String jobTitle;
    public static final String JSON_PROPERTY_NAME = "name";
    private ViasName name;
    public static final String JSON_PROPERTY_PERSONAL_DATA = "personalData";
    private ViasPersonalData personalData;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private ViasPhoneNumber phoneNumber;
    public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
    private String signatoryCode;
    public static final String JSON_PROPERTY_SIGNATORY_REFERENCE = "signatoryReference";
    private String signatoryReference;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public SignatoryContact address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public SignatoryContact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The e-mail address of the person.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public SignatoryContact fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the person provided as a single string.  It will be handled as a landline phone. Examples: \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public SignatoryContact jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ApiModelProperty(value="Job title of the signatory.  Example values: **Chief Executive Officer**, **Chief Financial Officer**, **Chief Operating Officer**, **President**, **Vice President**, **Executive President**, **Managing Member**, **Partner**, **Treasurer**, **Director**, or **Other**.")
    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public SignatoryContact name(ViasName name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasName getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(ViasName name) {
        this.name = name;
    }

    public SignatoryContact personalData(ViasPersonalData personalData) {
        this.personalData = personalData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="personalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPersonalData getPersonalData() {
        return this.personalData;
    }

    @JsonProperty(value="personalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonalData(ViasPersonalData personalData) {
        this.personalData = personalData;
    }

    public SignatoryContact phoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public SignatoryContact signatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier (UUID) of the signatory. >**If, during an Account Holder create or update request, this field is left blank (but other fields provided), a new Signatory will be created with a procedurally-generated UUID.**  >**If, during an Account Holder create request, a UUID is provided, the creation of the Signatory will fail while the creation of the Account Holder will continue.**  >**If, during an Account Holder update request, a UUID that is not correlated with an existing Signatory is provided, the update of the Signatory will fail.**  >**If, during an Account Holder update request, a UUID that is correlated with an existing Signatory is provided, the existing Signatory will be updated.** ")
    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatoryCode() {
        return this.signatoryCode;
    }

    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
    }

    public SignatoryContact signatoryReference(String signatoryReference) {
        this.signatoryReference = signatoryReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the signatory.")
    @JsonProperty(value="signatoryReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatoryReference() {
        return this.signatoryReference;
    }

    @JsonProperty(value="signatoryReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryReference(String signatoryReference) {
        this.signatoryReference = signatoryReference;
    }

    public SignatoryContact webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the person's website.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatoryContact signatoryContact = (SignatoryContact)o;
        return Objects.equals(this.address, signatoryContact.address) && Objects.equals(this.email, signatoryContact.email) && Objects.equals(this.fullPhoneNumber, signatoryContact.fullPhoneNumber) && Objects.equals(this.jobTitle, signatoryContact.jobTitle) && Objects.equals(this.name, signatoryContact.name) && Objects.equals(this.personalData, signatoryContact.personalData) && Objects.equals(this.phoneNumber, signatoryContact.phoneNumber) && Objects.equals(this.signatoryCode, signatoryContact.signatoryCode) && Objects.equals(this.signatoryReference, signatoryContact.signatoryReference) && Objects.equals(this.webAddress, signatoryContact.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.email, this.fullPhoneNumber, this.jobTitle, this.name, this.personalData, this.phoneNumber, this.signatoryCode, this.signatoryReference, this.webAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignatoryContact {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    personalData: ").append(this.toIndentedString(this.personalData)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    signatoryCode: ").append(this.toIndentedString(this.signatoryCode)).append("\n");
        sb.append("    signatoryReference: ").append(this.toIndentedString(this.signatoryReference)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SignatoryContact fromJson(String jsonString) throws JsonProcessingException {
        return (SignatoryContact)JSON.getMapper().readValue(jsonString, SignatoryContact.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

