/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"legalEntityCode", "shareholderCode"})
public class MigratedShareholders {
    public static final String JSON_PROPERTY_LEGAL_ENTITY_CODE = "legalEntityCode";
    private String legalEntityCode;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;

    public MigratedShareholders legalEntityCode(String legalEntityCode) {
        this.legalEntityCode = legalEntityCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the legal entity of that shareholder in the balance platform.")
    @JsonProperty(value="legalEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityCode() {
        return this.legalEntityCode;
    }

    @JsonProperty(value="legalEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityCode(String legalEntityCode) {
        this.legalEntityCode = legalEntityCode;
    }

    public MigratedShareholders shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account of the migrated shareholder in the classic integration.")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigratedShareholders migratedShareholders = (MigratedShareholders)o;
        return Objects.equals(this.legalEntityCode, migratedShareholders.legalEntityCode) && Objects.equals(this.shareholderCode, migratedShareholders.shareholderCode);
    }

    public int hashCode() {
        return Objects.hash(this.legalEntityCode, this.shareholderCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigratedShareholders {\n");
        sb.append("    legalEntityCode: ").append(this.toIndentedString(this.legalEntityCode)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MigratedShareholders fromJson(String jsonString) throws JsonProcessingException {
        return (MigratedShareholders)JSON.getMapper().readValue(jsonString, MigratedShareholders.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

