/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.Account;
import com.adyen.model.marketpayaccount.AccountHolderDetails;
import com.adyen.model.marketpayaccount.AccountHolderStatus;
import com.adyen.model.marketpayaccount.ErrorFieldType;
import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCVerificationResult;
import com.adyen.model.marketpayaccount.MigrationData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "accountHolderDetails", "accountHolderStatus", "accounts", "description", "invalidFields", "legalEntity", "migrationData", "primaryCurrency", "pspReference", "resultCode", "systemUpToDateTime", "verification", "verificationProfile"})
public class GetAccountHolderResponse {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS = "accountHolderDetails";
    private AccountHolderDetails accountHolderDetails;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_STATUS = "accountHolderStatus";
    private AccountHolderStatus accountHolderStatus;
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<Account> accounts = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_LEGAL_ENTITY = "legalEntity";
    private LegalEntityEnum legalEntity;
    public static final String JSON_PROPERTY_MIGRATION_DATA = "migrationData";
    private MigrationData migrationData;
    public static final String JSON_PROPERTY_PRIMARY_CURRENCY = "primaryCurrency";
    private String primaryCurrency;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;
    public static final String JSON_PROPERTY_SYSTEM_UP_TO_DATE_TIME = "systemUpToDateTime";
    private OffsetDateTime systemUpToDateTime;
    public static final String JSON_PROPERTY_VERIFICATION = "verification";
    private KYCVerificationResult verification;
    public static final String JSON_PROPERTY_VERIFICATION_PROFILE = "verificationProfile";
    private String verificationProfile;

    public GetAccountHolderResponse accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetAccountHolderResponse accountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountHolderDetails getAccountHolderDetails() {
        return this.accountHolderDetails;
    }

    @JsonProperty(value="accountHolderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
    }

    public GetAccountHolderResponse accountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolderStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountHolderStatus getAccountHolderStatus() {
        return this.accountHolderStatus;
    }

    @JsonProperty(value="accountHolderStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
    }

    public GetAccountHolderResponse accounts(List<Account> accounts) {
        this.accounts = accounts;
        return this;
    }

    public GetAccountHolderResponse addAccountsItem(Account accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<Account>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of the accounts under the account holder.")
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Account> getAccounts() {
        return this.accounts;
    }

    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public GetAccountHolderResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the account holder.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public GetAccountHolderResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public GetAccountHolderResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Contains field validation errors that would prevent requests from being processed.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public GetAccountHolderResponse legalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
        return this;
    }

    @ApiModelProperty(value="The legal entity of the account holder.")
    @JsonProperty(value="legalEntity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LegalEntityEnum getLegalEntity() {
        return this.legalEntity;
    }

    @JsonProperty(value="legalEntity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
    }

    public GetAccountHolderResponse migrationData(MigrationData migrationData) {
        this.migrationData = migrationData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="migrationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MigrationData getMigrationData() {
        return this.migrationData;
    }

    @JsonProperty(value="migrationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigrationData(MigrationData migrationData) {
        this.migrationData = migrationData;
    }

    public GetAccountHolderResponse primaryCurrency(String primaryCurrency) {
        this.primaryCurrency = primaryCurrency;
        return this;
    }

    @ApiModelProperty(value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes), with which the prospective account holder primarily deals.")
    @JsonProperty(value="primaryCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrimaryCurrency() {
        return this.primaryCurrency;
    }

    @JsonProperty(value="primaryCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryCurrency(String primaryCurrency) {
        this.primaryCurrency = primaryCurrency;
    }

    public GetAccountHolderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public GetAccountHolderResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public GetAccountHolderResponse systemUpToDateTime(OffsetDateTime systemUpToDateTime) {
        this.systemUpToDateTime = systemUpToDateTime;
        return this;
    }

    @ApiModelProperty(value="The time that shows how up to date is the information in the response.")
    @JsonProperty(value="systemUpToDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getSystemUpToDateTime() {
        return this.systemUpToDateTime;
    }

    @JsonProperty(value="systemUpToDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSystemUpToDateTime(OffsetDateTime systemUpToDateTime) {
        this.systemUpToDateTime = systemUpToDateTime;
    }

    public GetAccountHolderResponse verification(KYCVerificationResult verification) {
        this.verification = verification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="verification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KYCVerificationResult getVerification() {
        return this.verification;
    }

    @JsonProperty(value="verification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerification(KYCVerificationResult verification) {
        this.verification = verification;
    }

    public GetAccountHolderResponse verificationProfile(String verificationProfile) {
        this.verificationProfile = verificationProfile;
        return this;
    }

    @ApiModelProperty(value="The identifier of the profile that applies to this entity.")
    @JsonProperty(value="verificationProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationProfile() {
        return this.verificationProfile;
    }

    @JsonProperty(value="verificationProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationProfile(String verificationProfile) {
        this.verificationProfile = verificationProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountHolderResponse getAccountHolderResponse = (GetAccountHolderResponse)o;
        return Objects.equals(this.accountHolderCode, getAccountHolderResponse.accountHolderCode) && Objects.equals(this.accountHolderDetails, getAccountHolderResponse.accountHolderDetails) && Objects.equals(this.accountHolderStatus, getAccountHolderResponse.accountHolderStatus) && Objects.equals(this.accounts, getAccountHolderResponse.accounts) && Objects.equals(this.description, getAccountHolderResponse.description) && Objects.equals(this.invalidFields, getAccountHolderResponse.invalidFields) && Objects.equals((Object)this.legalEntity, (Object)getAccountHolderResponse.legalEntity) && Objects.equals(this.migrationData, getAccountHolderResponse.migrationData) && Objects.equals(this.primaryCurrency, getAccountHolderResponse.primaryCurrency) && Objects.equals(this.pspReference, getAccountHolderResponse.pspReference) && Objects.equals(this.resultCode, getAccountHolderResponse.resultCode) && Objects.equals(this.systemUpToDateTime, getAccountHolderResponse.systemUpToDateTime) && Objects.equals(this.verification, getAccountHolderResponse.verification) && Objects.equals(this.verificationProfile, getAccountHolderResponse.verificationProfile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.accountHolderDetails, this.accountHolderStatus, this.accounts, this.description, this.invalidFields, this.legalEntity, this.migrationData, this.primaryCurrency, this.pspReference, this.resultCode, this.systemUpToDateTime, this.verification, this.verificationProfile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccountHolderResponse {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    accountHolderDetails: ").append(this.toIndentedString(this.accountHolderDetails)).append("\n");
        sb.append("    accountHolderStatus: ").append(this.toIndentedString(this.accountHolderStatus)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    legalEntity: ").append(this.toIndentedString((Object)this.legalEntity)).append("\n");
        sb.append("    migrationData: ").append(this.toIndentedString(this.migrationData)).append("\n");
        sb.append("    primaryCurrency: ").append(this.toIndentedString(this.primaryCurrency)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("    systemUpToDateTime: ").append(this.toIndentedString(this.systemUpToDateTime)).append("\n");
        sb.append("    verification: ").append(this.toIndentedString(this.verification)).append("\n");
        sb.append("    verificationProfile: ").append(this.toIndentedString(this.verificationProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetAccountHolderResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetAccountHolderResponse)JSON.getMapper().readValue(jsonString, GetAccountHolderResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum LegalEntityEnum {
        BUSINESS("Business"),
        INDIVIDUAL("Individual"),
        NONPROFIT("NonProfit"),
        PARTNERSHIP("Partnership"),
        PUBLICCOMPANY("PublicCompany");

        private String value;

        private LegalEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LegalEntityEnum fromValue(String value) {
            for (LegalEntityEnum b : LegalEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

