/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"midNumber", "reuseMidNumber", "serviceLevel"})
public class AmexInfo {
    public static final String JSON_PROPERTY_MID_NUMBER = "midNumber";
    private String midNumber;
    private boolean isSetMidNumber = false;
    public static final String JSON_PROPERTY_REUSE_MID_NUMBER = "reuseMidNumber";
    private Boolean reuseMidNumber;
    private boolean isSetReuseMidNumber = false;
    public static final String JSON_PROPERTY_SERVICE_LEVEL = "serviceLevel";
    private ServiceLevelEnum serviceLevel;
    private boolean isSetServiceLevel = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public AmexInfo midNumber(String midNumber) {
        this.midNumber = midNumber;
        this.isSetMidNumber = true;
        return this;
    }

    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMidNumber() {
        return this.midNumber;
    }

    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMidNumber(String midNumber) {
        this.midNumber = midNumber;
        this.isSetMidNumber = true;
    }

    public AmexInfo reuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
        this.isSetReuseMidNumber = true;
        return this;
    }

    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReuseMidNumber() {
        return this.reuseMidNumber;
    }

    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
        this.isSetReuseMidNumber = true;
    }

    public AmexInfo serviceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
        this.isSetServiceLevel = true;
        return this;
    }

    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceLevelEnum getServiceLevel() {
        return this.serviceLevel;
    }

    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
        this.isSetServiceLevel = true;
    }

    public AmexInfo includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmexInfo amexInfo = (AmexInfo)o;
        return Objects.equals(this.midNumber, amexInfo.midNumber) && Objects.equals(this.isSetMidNumber, amexInfo.isSetMidNumber) && Objects.equals(this.reuseMidNumber, amexInfo.reuseMidNumber) && Objects.equals(this.isSetReuseMidNumber, amexInfo.isSetReuseMidNumber) && Objects.equals((Object)this.serviceLevel, (Object)amexInfo.serviceLevel) && Objects.equals(this.isSetServiceLevel, amexInfo.isSetServiceLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.midNumber, this.isSetMidNumber, this.reuseMidNumber, this.isSetReuseMidNumber, this.serviceLevel, this.isSetServiceLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmexInfo {\n");
        sb.append("    midNumber: ").append(this.toIndentedString(this.midNumber)).append("\n");
        sb.append("    reuseMidNumber: ").append(this.toIndentedString(this.reuseMidNumber)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString((Object)this.serviceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetMidNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_MID_NUMBER, this.midNumber);
        }
        if (this.isSetReuseMidNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_REUSE_MID_NUMBER, this.reuseMidNumber);
        }
        if (this.isSetServiceLevel) {
            this.addIfNull(nulls, JSON_PROPERTY_SERVICE_LEVEL, (Object)this.serviceLevel);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static AmexInfo fromJson(String jsonString) throws JsonProcessingException {
        return (AmexInfo)JSON.getMapper().readValue(jsonString, AmexInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceLevelEnum {
        NOCONTRACT(String.valueOf("noContract")),
        GATEWAYCONTRACT(String.valueOf("gatewayContract")),
        PAYMENTDESIGNATORCONTRACT(String.valueOf("paymentDesignatorContract"));

        private static final Logger LOG;
        private String value;

        private ServiceLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceLevelEnum fromValue(String value) {
            for (ServiceLevelEnum b : ServiceLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ServiceLevelEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ServiceLevelEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ServiceLevelEnum.class.getName());
        }
    }
}

