/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.DeliveryMethod;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.TaxTotal;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "deliveryMethods", "paymentData", "pspReference", "sessionId", "taxTotal"})
public class PaypalUpdateOrderRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_DELIVERY_METHODS = "deliveryMethods";
    private List<DeliveryMethod> deliveryMethods;
    private boolean isSetDeliveryMethods = false;
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    private boolean isSetPaymentData = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId;
    private boolean isSetSessionId = false;
    public static final String JSON_PROPERTY_TAX_TOTAL = "taxTotal";
    private TaxTotal taxTotal;
    private boolean isSetTaxTotal = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaypalUpdateOrderRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public PaypalUpdateOrderRequest deliveryMethods(List<DeliveryMethod> deliveryMethods) {
        this.deliveryMethods = deliveryMethods;
        this.isSetDeliveryMethods = true;
        return this;
    }

    public PaypalUpdateOrderRequest addDeliveryMethodsItem(DeliveryMethod deliveryMethodsItem) {
        if (this.deliveryMethods == null) {
            this.deliveryMethods = new ArrayList<DeliveryMethod>();
        }
        this.deliveryMethods.add(deliveryMethodsItem);
        return this;
    }

    @JsonProperty(value="deliveryMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DeliveryMethod> getDeliveryMethods() {
        return this.deliveryMethods;
    }

    @JsonProperty(value="deliveryMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryMethods(List<DeliveryMethod> deliveryMethods) {
        this.deliveryMethods = deliveryMethods;
        this.isSetDeliveryMethods = true;
    }

    public PaypalUpdateOrderRequest paymentData(String paymentData) {
        this.paymentData = paymentData;
        this.isSetPaymentData = true;
        return this;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
        this.isSetPaymentData = true;
    }

    public PaypalUpdateOrderRequest pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public PaypalUpdateOrderRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        this.isSetSessionId = true;
        return this;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.isSetSessionId = true;
    }

    public PaypalUpdateOrderRequest taxTotal(TaxTotal taxTotal) {
        this.taxTotal = taxTotal;
        this.isSetTaxTotal = true;
        return this;
    }

    @JsonProperty(value="taxTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaxTotal getTaxTotal() {
        return this.taxTotal;
    }

    @JsonProperty(value="taxTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxTotal(TaxTotal taxTotal) {
        this.taxTotal = taxTotal;
        this.isSetTaxTotal = true;
    }

    public PaypalUpdateOrderRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaypalUpdateOrderRequest paypalUpdateOrderRequest = (PaypalUpdateOrderRequest)o;
        return Objects.equals(this.amount, paypalUpdateOrderRequest.amount) && Objects.equals(this.isSetAmount, paypalUpdateOrderRequest.isSetAmount) && Objects.equals(this.deliveryMethods, paypalUpdateOrderRequest.deliveryMethods) && Objects.equals(this.isSetDeliveryMethods, paypalUpdateOrderRequest.isSetDeliveryMethods) && Objects.equals(this.paymentData, paypalUpdateOrderRequest.paymentData) && Objects.equals(this.isSetPaymentData, paypalUpdateOrderRequest.isSetPaymentData) && Objects.equals(this.pspReference, paypalUpdateOrderRequest.pspReference) && Objects.equals(this.isSetPspReference, paypalUpdateOrderRequest.isSetPspReference) && Objects.equals(this.sessionId, paypalUpdateOrderRequest.sessionId) && Objects.equals(this.isSetSessionId, paypalUpdateOrderRequest.isSetSessionId) && Objects.equals(this.taxTotal, paypalUpdateOrderRequest.taxTotal) && Objects.equals(this.isSetTaxTotal, paypalUpdateOrderRequest.isSetTaxTotal);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.isSetAmount, this.deliveryMethods, this.isSetDeliveryMethods, this.paymentData, this.isSetPaymentData, this.pspReference, this.isSetPspReference, this.sessionId, this.isSetSessionId, this.taxTotal, this.isSetTaxTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaypalUpdateOrderRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    deliveryMethods: ").append(this.toIndentedString(this.deliveryMethods)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    taxTotal: ").append(this.toIndentedString(this.taxTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetDeliveryMethods) {
            this.addIfNull(nulls, JSON_PROPERTY_DELIVERY_METHODS, this.deliveryMethods);
        }
        if (this.isSetPaymentData) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_DATA, this.paymentData);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetSessionId) {
            this.addIfNull(nulls, JSON_PROPERTY_SESSION_ID, this.sessionId);
        }
        if (this.isSetTaxTotal) {
            this.addIfNull(nulls, JSON_PROPERTY_TAX_TOTAL, this.taxTotal);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaypalUpdateOrderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaypalUpdateOrderRequest)JSON.getMapper().readValue(jsonString, PaypalUpdateOrderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

