/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.EnhancedSchemeData;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "applicationInfo", "capturePspReference", "enhancedSchemeData", "lineItems", "merchantAccount", "merchantRefundReason", "reference", "splits", "store"})
public class PaymentRefundRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    private boolean isSetApplicationInfo = false;
    public static final String JSON_PROPERTY_CAPTURE_PSP_REFERENCE = "capturePspReference";
    private String capturePspReference;
    private boolean isSetCapturePspReference = false;
    public static final String JSON_PROPERTY_ENHANCED_SCHEME_DATA = "enhancedSchemeData";
    private EnhancedSchemeData enhancedSchemeData;
    private boolean isSetEnhancedSchemeData = false;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems;
    private boolean isSetLineItems = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_MERCHANT_REFUND_REASON = "merchantRefundReason";
    private MerchantRefundReasonEnum merchantRefundReason;
    private boolean isSetMerchantRefundReason = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits;
    private boolean isSetSplits = false;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    private boolean isSetStore = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaymentRefundRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public PaymentRefundRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        this.isSetApplicationInfo = true;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        this.isSetApplicationInfo = true;
    }

    public PaymentRefundRequest capturePspReference(String capturePspReference) {
        this.capturePspReference = capturePspReference;
        this.isSetCapturePspReference = true;
        return this;
    }

    @JsonProperty(value="capturePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCapturePspReference() {
        return this.capturePspReference;
    }

    @JsonProperty(value="capturePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapturePspReference(String capturePspReference) {
        this.capturePspReference = capturePspReference;
        this.isSetCapturePspReference = true;
    }

    public PaymentRefundRequest enhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
        this.enhancedSchemeData = enhancedSchemeData;
        this.isSetEnhancedSchemeData = true;
        return this;
    }

    @JsonProperty(value="enhancedSchemeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnhancedSchemeData getEnhancedSchemeData() {
        return this.enhancedSchemeData;
    }

    @JsonProperty(value="enhancedSchemeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
        this.enhancedSchemeData = enhancedSchemeData;
        this.isSetEnhancedSchemeData = true;
    }

    public PaymentRefundRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        this.isSetLineItems = true;
        return this;
    }

    public PaymentRefundRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        this.isSetLineItems = true;
    }

    public PaymentRefundRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public PaymentRefundRequest merchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
        this.isSetMerchantRefundReason = true;
        return this;
    }

    @JsonProperty(value="merchantRefundReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRefundReasonEnum getMerchantRefundReason() {
        return this.merchantRefundReason;
    }

    @JsonProperty(value="merchantRefundReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
        this.isSetMerchantRefundReason = true;
    }

    public PaymentRefundRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public PaymentRefundRequest splits(List<Split> splits) {
        this.splits = splits;
        this.isSetSplits = true;
        return this;
    }

    public PaymentRefundRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
        this.isSetSplits = true;
    }

    public PaymentRefundRequest store(String store) {
        this.store = store;
        this.isSetStore = true;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
        this.isSetStore = true;
    }

    public PaymentRefundRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRefundRequest paymentRefundRequest = (PaymentRefundRequest)o;
        return Objects.equals(this.amount, paymentRefundRequest.amount) && Objects.equals(this.isSetAmount, paymentRefundRequest.isSetAmount) && Objects.equals(this.applicationInfo, paymentRefundRequest.applicationInfo) && Objects.equals(this.isSetApplicationInfo, paymentRefundRequest.isSetApplicationInfo) && Objects.equals(this.capturePspReference, paymentRefundRequest.capturePspReference) && Objects.equals(this.isSetCapturePspReference, paymentRefundRequest.isSetCapturePspReference) && Objects.equals(this.enhancedSchemeData, paymentRefundRequest.enhancedSchemeData) && Objects.equals(this.isSetEnhancedSchemeData, paymentRefundRequest.isSetEnhancedSchemeData) && Objects.equals(this.lineItems, paymentRefundRequest.lineItems) && Objects.equals(this.isSetLineItems, paymentRefundRequest.isSetLineItems) && Objects.equals(this.merchantAccount, paymentRefundRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, paymentRefundRequest.isSetMerchantAccount) && Objects.equals((Object)this.merchantRefundReason, (Object)paymentRefundRequest.merchantRefundReason) && Objects.equals(this.isSetMerchantRefundReason, paymentRefundRequest.isSetMerchantRefundReason) && Objects.equals(this.reference, paymentRefundRequest.reference) && Objects.equals(this.isSetReference, paymentRefundRequest.isSetReference) && Objects.equals(this.splits, paymentRefundRequest.splits) && Objects.equals(this.isSetSplits, paymentRefundRequest.isSetSplits) && Objects.equals(this.store, paymentRefundRequest.store) && Objects.equals(this.isSetStore, paymentRefundRequest.isSetStore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.applicationInfo, this.isSetApplicationInfo, this.capturePspReference, this.isSetCapturePspReference, this.enhancedSchemeData, this.isSetEnhancedSchemeData, this.lineItems, this.isSetLineItems, this.merchantAccount, this.isSetMerchantAccount, this.merchantRefundReason, this.isSetMerchantRefundReason, this.reference, this.isSetReference, this.splits, this.isSetSplits, this.store, this.isSetStore});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRefundRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    capturePspReference: ").append(this.toIndentedString(this.capturePspReference)).append("\n");
        sb.append("    enhancedSchemeData: ").append(this.toIndentedString(this.enhancedSchemeData)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantRefundReason: ").append(this.toIndentedString((Object)this.merchantRefundReason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetApplicationInfo) {
            this.addIfNull(nulls, JSON_PROPERTY_APPLICATION_INFO, this.applicationInfo);
        }
        if (this.isSetCapturePspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_CAPTURE_PSP_REFERENCE, this.capturePspReference);
        }
        if (this.isSetEnhancedSchemeData) {
            this.addIfNull(nulls, JSON_PROPERTY_ENHANCED_SCHEME_DATA, this.enhancedSchemeData);
        }
        if (this.isSetLineItems) {
            this.addIfNull(nulls, JSON_PROPERTY_LINE_ITEMS, this.lineItems);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetMerchantRefundReason) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_REFUND_REASON, (Object)this.merchantRefundReason);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSplits) {
            this.addIfNull(nulls, JSON_PROPERTY_SPLITS, this.splits);
        }
        if (this.isSetStore) {
            this.addIfNull(nulls, JSON_PROPERTY_STORE, this.store);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaymentRefundRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentRefundRequest)JSON.getMapper().readValue(jsonString, PaymentRefundRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum MerchantRefundReasonEnum {
        FRAUD(String.valueOf("FRAUD")),
        CUSTOMER_REQUEST(String.valueOf("CUSTOMER REQUEST")),
        RETURN(String.valueOf("RETURN")),
        DUPLICATE(String.valueOf("DUPLICATE")),
        OTHER(String.valueOf("OTHER"));

        private static final Logger LOG;
        private String value;

        private MerchantRefundReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MerchantRefundReasonEnum fromValue(String value) {
            for (MerchantRefundReasonEnum b : MerchantRefundReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("MerchantRefundReasonEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])MerchantRefundReasonEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(MerchantRefundReasonEnum.class.getName());
        }
    }
}

