/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"maxValue", "plans", "preselectedValue", "values"})
public class InstallmentOption {
    public static final String JSON_PROPERTY_MAX_VALUE = "maxValue";
    private Integer maxValue;
    private boolean isSetMaxValue = false;
    public static final String JSON_PROPERTY_PLANS = "plans";
    private List<PlansEnum> plans;
    private boolean isSetPlans = false;
    public static final String JSON_PROPERTY_PRESELECTED_VALUE = "preselectedValue";
    private Integer preselectedValue;
    private boolean isSetPreselectedValue = false;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Integer> values;
    private boolean isSetValues = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public InstallmentOption maxValue(Integer maxValue) {
        this.maxValue = maxValue;
        this.isSetMaxValue = true;
        return this;
    }

    @JsonProperty(value="maxValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxValue() {
        return this.maxValue;
    }

    @JsonProperty(value="maxValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
        this.isSetMaxValue = true;
    }

    public InstallmentOption plans(List<PlansEnum> plans) {
        this.plans = plans;
        this.isSetPlans = true;
        return this;
    }

    public InstallmentOption addPlansItem(PlansEnum plansItem) {
        if (this.plans == null) {
            this.plans = new ArrayList<PlansEnum>();
        }
        this.plans.add(plansItem);
        return this;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PlansEnum> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlans(List<PlansEnum> plans) {
        this.plans = plans;
        this.isSetPlans = true;
    }

    public InstallmentOption preselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
        this.isSetPreselectedValue = true;
        return this;
    }

    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPreselectedValue() {
        return this.preselectedValue;
    }

    @JsonProperty(value="preselectedValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
        this.isSetPreselectedValue = true;
    }

    public InstallmentOption values(List<Integer> values) {
        this.values = values;
        this.isSetValues = true;
        return this;
    }

    public InstallmentOption addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<Integer> values) {
        this.values = values;
        this.isSetValues = true;
    }

    public InstallmentOption includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallmentOption installmentOption = (InstallmentOption)o;
        return Objects.equals(this.maxValue, installmentOption.maxValue) && Objects.equals(this.isSetMaxValue, installmentOption.isSetMaxValue) && Objects.equals(this.plans, installmentOption.plans) && Objects.equals(this.isSetPlans, installmentOption.isSetPlans) && Objects.equals(this.preselectedValue, installmentOption.preselectedValue) && Objects.equals(this.isSetPreselectedValue, installmentOption.isSetPreselectedValue) && Objects.equals(this.values, installmentOption.values) && Objects.equals(this.isSetValues, installmentOption.isSetValues);
    }

    public int hashCode() {
        return Objects.hash(this.maxValue, this.isSetMaxValue, this.plans, this.isSetPlans, this.preselectedValue, this.isSetPreselectedValue, this.values, this.isSetValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstallmentOption {\n");
        sb.append("    maxValue: ").append(this.toIndentedString(this.maxValue)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    preselectedValue: ").append(this.toIndentedString(this.preselectedValue)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetMaxValue) {
            this.addIfNull(nulls, JSON_PROPERTY_MAX_VALUE, this.maxValue);
        }
        if (this.isSetPlans) {
            this.addIfNull(nulls, JSON_PROPERTY_PLANS, this.plans);
        }
        if (this.isSetPreselectedValue) {
            this.addIfNull(nulls, JSON_PROPERTY_PRESELECTED_VALUE, this.preselectedValue);
        }
        if (this.isSetValues) {
            this.addIfNull(nulls, JSON_PROPERTY_VALUES, this.values);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static InstallmentOption fromJson(String jsonString) throws JsonProcessingException {
        return (InstallmentOption)JSON.getMapper().readValue(jsonString, InstallmentOption.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PlansEnum {
        BONUS(String.valueOf("bonus")),
        BUYNOW_PAYLATER(String.valueOf("buynow_paylater")),
        INTERES_REFUND_PRCTG(String.valueOf("interes_refund_prctg")),
        INTEREST_BONUS(String.valueOf("interest_bonus")),
        NOINTERES_REFUND_PRCTG(String.valueOf("nointeres_refund_prctg")),
        NOINTEREST_BONUS(String.valueOf("nointerest_bonus")),
        REFUND_PRCTG(String.valueOf("refund_prctg")),
        REGULAR(String.valueOf("regular")),
        REVOLVING(String.valueOf("revolving")),
        WITH_INTEREST(String.valueOf("with_interest"));

        private static final Logger LOG;
        private String value;

        private PlansEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlansEnum fromValue(String value) {
            for (PlansEnum b : PlansEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PlansEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PlansEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PlansEnum.class.getName());
        }
    }
}

