/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"paymentData", "paymentMethodType", "sdkData", "type", "url"})
public class CheckoutSDKAction {
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    private boolean isSetPaymentData = false;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
    private String paymentMethodType;
    private boolean isSetPaymentMethodType = false;
    public static final String JSON_PROPERTY_SDK_DATA = "sdkData";
    private Map<String, String> sdkData;
    private boolean isSetSdkData = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private boolean isSetUrl = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CheckoutSDKAction paymentData(String paymentData) {
        this.paymentData = paymentData;
        this.isSetPaymentData = true;
        return this;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
        this.isSetPaymentData = true;
    }

    public CheckoutSDKAction paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        this.isSetPaymentMethodType = true;
        return this;
    }

    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        this.isSetPaymentMethodType = true;
    }

    public CheckoutSDKAction sdkData(Map<String, String> sdkData) {
        this.sdkData = sdkData;
        this.isSetSdkData = true;
        return this;
    }

    public CheckoutSDKAction putSdkDataItem(String key, String sdkDataItem) {
        if (this.sdkData == null) {
            this.sdkData = new HashMap<String, String>();
        }
        this.sdkData.put(key, sdkDataItem);
        return this;
    }

    @JsonProperty(value="sdkData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getSdkData() {
        return this.sdkData;
    }

    @JsonProperty(value="sdkData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkData(Map<String, String> sdkData) {
        this.sdkData = sdkData;
        this.isSetSdkData = true;
    }

    public CheckoutSDKAction type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public CheckoutSDKAction url(String url) {
        this.url = url;
        this.isSetUrl = true;
        return this;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
        this.isSetUrl = true;
    }

    public CheckoutSDKAction includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutSDKAction checkoutSDKAction = (CheckoutSDKAction)o;
        return Objects.equals(this.paymentData, checkoutSDKAction.paymentData) && Objects.equals(this.isSetPaymentData, checkoutSDKAction.isSetPaymentData) && Objects.equals(this.paymentMethodType, checkoutSDKAction.paymentMethodType) && Objects.equals(this.isSetPaymentMethodType, checkoutSDKAction.isSetPaymentMethodType) && Objects.equals(this.sdkData, checkoutSDKAction.sdkData) && Objects.equals(this.isSetSdkData, checkoutSDKAction.isSetSdkData) && Objects.equals((Object)this.type, (Object)checkoutSDKAction.type) && Objects.equals(this.isSetType, checkoutSDKAction.isSetType) && Objects.equals(this.url, checkoutSDKAction.url) && Objects.equals(this.isSetUrl, checkoutSDKAction.isSetUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentData, this.isSetPaymentData, this.paymentMethodType, this.isSetPaymentMethodType, this.sdkData, this.isSetSdkData, this.type, this.isSetType, this.url, this.isSetUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutSDKAction {\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    sdkData: ").append(this.toIndentedString(this.sdkData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetPaymentData) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_DATA, this.paymentData);
        }
        if (this.isSetPaymentMethodType) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_METHOD_TYPE, this.paymentMethodType);
        }
        if (this.isSetSdkData) {
            this.addIfNull(nulls, JSON_PROPERTY_SDK_DATA, this.sdkData);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUrl) {
            this.addIfNull(nulls, JSON_PROPERTY_URL, this.url);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CheckoutSDKAction fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutSDKAction)JSON.getMapper().readValue(jsonString, CheckoutSDKAction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        SDK(String.valueOf("sdk")),
        WECHATPAYSDK(String.valueOf("wechatpaySDK"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

