/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.Balance;
import com.adyen.model.capital.GrantLimit;
import com.adyen.model.capital.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balances", "fundingBalanceAccountId", "id", "limits"})
public class GrantAccount {
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<Balance> balances;
    private boolean isSetBalances = false;
    public static final String JSON_PROPERTY_FUNDING_BALANCE_ACCOUNT_ID = "fundingBalanceAccountId";
    private String fundingBalanceAccountId;
    private boolean isSetFundingBalanceAccountId = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_LIMITS = "limits";
    private List<GrantLimit> limits;
    private boolean isSetLimits = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public GrantAccount balances(List<Balance> balances) {
        this.balances = balances;
        this.isSetBalances = true;
        return this;
    }

    public GrantAccount addBalancesItem(Balance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<Balance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Balance> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<Balance> balances) {
        this.balances = balances;
        this.isSetBalances = true;
    }

    public GrantAccount fundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
        this.isSetFundingBalanceAccountId = true;
        return this;
    }

    @JsonProperty(value="fundingBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingBalanceAccountId() {
        return this.fundingBalanceAccountId;
    }

    @JsonProperty(value="fundingBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
        this.isSetFundingBalanceAccountId = true;
    }

    public GrantAccount id(String id) {
        this.id = id;
        this.isSetId = true;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
        this.isSetId = true;
    }

    public GrantAccount limits(List<GrantLimit> limits) {
        this.limits = limits;
        this.isSetLimits = true;
        return this;
    }

    public GrantAccount addLimitsItem(GrantLimit limitsItem) {
        if (this.limits == null) {
            this.limits = new ArrayList<GrantLimit>();
        }
        this.limits.add(limitsItem);
        return this;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GrantLimit> getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimits(List<GrantLimit> limits) {
        this.limits = limits;
        this.isSetLimits = true;
    }

    public GrantAccount includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantAccount grantAccount = (GrantAccount)o;
        return Objects.equals(this.balances, grantAccount.balances) && Objects.equals(this.isSetBalances, grantAccount.isSetBalances) && Objects.equals(this.fundingBalanceAccountId, grantAccount.fundingBalanceAccountId) && Objects.equals(this.isSetFundingBalanceAccountId, grantAccount.isSetFundingBalanceAccountId) && Objects.equals(this.id, grantAccount.id) && Objects.equals(this.isSetId, grantAccount.isSetId) && Objects.equals(this.limits, grantAccount.limits) && Objects.equals(this.isSetLimits, grantAccount.isSetLimits);
    }

    public int hashCode() {
        return Objects.hash(this.balances, this.isSetBalances, this.fundingBalanceAccountId, this.isSetFundingBalanceAccountId, this.id, this.isSetId, this.limits, this.isSetLimits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantAccount {\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    fundingBalanceAccountId: ").append(this.toIndentedString(this.fundingBalanceAccountId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBalances) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCES, this.balances);
        }
        if (this.isSetFundingBalanceAccountId) {
            this.addIfNull(nulls, JSON_PROPERTY_FUNDING_BALANCE_ACCOUNT_ID, this.fundingBalanceAccountId);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetLimits) {
            this.addIfNull(nulls, JSON_PROPERTY_LIMITS, this.limits);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static GrantAccount fromJson(String jsonString) throws JsonProcessingException {
        return (GrantAccount)JSON.getMapper().readValue(jsonString, GrantAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

