/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.CardIdentification;
import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"cardIdentification", "networkPaymentReference", "reference", "sourceOfFunds"})
public class FundingInstrument {
    public static final String JSON_PROPERTY_CARD_IDENTIFICATION = "cardIdentification";
    private CardIdentification cardIdentification;
    private boolean isSetCardIdentification = false;
    public static final String JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE = "networkPaymentReference";
    private String networkPaymentReference;
    private boolean isSetNetworkPaymentReference = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
    private SourceOfFundsEnum sourceOfFunds;
    private boolean isSetSourceOfFunds = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public FundingInstrument cardIdentification(CardIdentification cardIdentification) {
        this.cardIdentification = cardIdentification;
        this.isSetCardIdentification = true;
        return this;
    }

    @JsonProperty(value="cardIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardIdentification getCardIdentification() {
        return this.cardIdentification;
    }

    @JsonProperty(value="cardIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardIdentification(CardIdentification cardIdentification) {
        this.cardIdentification = cardIdentification;
        this.isSetCardIdentification = true;
    }

    public FundingInstrument networkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
        this.isSetNetworkPaymentReference = true;
        return this;
    }

    @JsonProperty(value="networkPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkPaymentReference() {
        return this.networkPaymentReference;
    }

    @JsonProperty(value="networkPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
        this.isSetNetworkPaymentReference = true;
    }

    public FundingInstrument reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public FundingInstrument sourceOfFunds(SourceOfFundsEnum sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        this.isSetSourceOfFunds = true;
        return this;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceOfFundsEnum getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceOfFunds(SourceOfFundsEnum sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        this.isSetSourceOfFunds = true;
    }

    public FundingInstrument includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundingInstrument fundingInstrument = (FundingInstrument)o;
        return Objects.equals(this.cardIdentification, fundingInstrument.cardIdentification) && Objects.equals(this.isSetCardIdentification, fundingInstrument.isSetCardIdentification) && Objects.equals(this.networkPaymentReference, fundingInstrument.networkPaymentReference) && Objects.equals(this.isSetNetworkPaymentReference, fundingInstrument.isSetNetworkPaymentReference) && Objects.equals(this.reference, fundingInstrument.reference) && Objects.equals(this.isSetReference, fundingInstrument.isSetReference) && Objects.equals((Object)this.sourceOfFunds, (Object)fundingInstrument.sourceOfFunds) && Objects.equals(this.isSetSourceOfFunds, fundingInstrument.isSetSourceOfFunds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardIdentification, this.isSetCardIdentification, this.networkPaymentReference, this.isSetNetworkPaymentReference, this.reference, this.isSetReference, this.sourceOfFunds, this.isSetSourceOfFunds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundingInstrument {\n");
        sb.append("    cardIdentification: ").append(this.toIndentedString(this.cardIdentification)).append("\n");
        sb.append("    networkPaymentReference: ").append(this.toIndentedString(this.networkPaymentReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString((Object)this.sourceOfFunds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCardIdentification) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD_IDENTIFICATION, this.cardIdentification);
        }
        if (this.isSetNetworkPaymentReference) {
            this.addIfNull(nulls, JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE, this.networkPaymentReference);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSourceOfFunds) {
            this.addIfNull(nulls, JSON_PROPERTY_SOURCE_OF_FUNDS, (Object)this.sourceOfFunds);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static FundingInstrument fromJson(String jsonString) throws JsonProcessingException {
        return (FundingInstrument)JSON.getMapper().readValue(jsonString, FundingInstrument.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum SourceOfFundsEnum {
        DEBIT(String.valueOf("DEBIT")),
        DEPOSIT_ACCOUNT(String.valueOf("DEPOSIT_ACCOUNT"));

        private static final Logger LOG;
        private String value;

        private SourceOfFundsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceOfFundsEnum fromValue(String value) {
            for (SourceOfFundsEnum b : SourceOfFundsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("SourceOfFundsEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])SourceOfFundsEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(SourceOfFundsEnum.class.getName());
        }
    }
}

