/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"authenticationMethod", "enablePayAtTable", "paymentInstrument"})
public class PayAtTable {
    public static final String JSON_PROPERTY_AUTHENTICATION_METHOD = "authenticationMethod";
    private AuthenticationMethodEnum authenticationMethod;
    private boolean isSetAuthenticationMethod = false;
    public static final String JSON_PROPERTY_ENABLE_PAY_AT_TABLE = "enablePayAtTable";
    private Boolean enablePayAtTable;
    private boolean isSetEnablePayAtTable = false;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
    private PaymentInstrumentEnum paymentInstrument;
    private boolean isSetPaymentInstrument = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PayAtTable authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        this.isSetAuthenticationMethod = true;
        return this;
    }

    @JsonProperty(value="authenticationMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationMethodEnum getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @JsonProperty(value="authenticationMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        this.isSetAuthenticationMethod = true;
    }

    public PayAtTable enablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
        this.isSetEnablePayAtTable = true;
        return this;
    }

    @JsonProperty(value="enablePayAtTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnablePayAtTable() {
        return this.enablePayAtTable;
    }

    @JsonProperty(value="enablePayAtTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
        this.isSetEnablePayAtTable = true;
    }

    public PayAtTable paymentInstrument(PaymentInstrumentEnum paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        this.isSetPaymentInstrument = true;
        return this;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrumentEnum getPaymentInstrument() {
        return this.paymentInstrument;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrument(PaymentInstrumentEnum paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        this.isSetPaymentInstrument = true;
    }

    public PayAtTable includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayAtTable payAtTable = (PayAtTable)o;
        return Objects.equals((Object)this.authenticationMethod, (Object)payAtTable.authenticationMethod) && Objects.equals(this.isSetAuthenticationMethod, payAtTable.isSetAuthenticationMethod) && Objects.equals(this.enablePayAtTable, payAtTable.enablePayAtTable) && Objects.equals(this.isSetEnablePayAtTable, payAtTable.isSetEnablePayAtTable) && Objects.equals((Object)this.paymentInstrument, (Object)payAtTable.paymentInstrument) && Objects.equals(this.isSetPaymentInstrument, payAtTable.isSetPaymentInstrument);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationMethod, this.isSetAuthenticationMethod, this.enablePayAtTable, this.isSetEnablePayAtTable, this.paymentInstrument, this.isSetPaymentInstrument});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayAtTable {\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    enablePayAtTable: ").append(this.toIndentedString(this.enablePayAtTable)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString((Object)this.paymentInstrument)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAuthenticationMethod) {
            this.addIfNull(nulls, JSON_PROPERTY_AUTHENTICATION_METHOD, (Object)this.authenticationMethod);
        }
        if (this.isSetEnablePayAtTable) {
            this.addIfNull(nulls, JSON_PROPERTY_ENABLE_PAY_AT_TABLE, this.enablePayAtTable);
        }
        if (this.isSetPaymentInstrument) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_INSTRUMENT, (Object)this.paymentInstrument);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PayAtTable fromJson(String jsonString) throws JsonProcessingException {
        return (PayAtTable)JSON.getMapper().readValue(jsonString, PayAtTable.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PaymentInstrumentEnum {
        CASH(String.valueOf("Cash")),
        CARD(String.valueOf("Card"));

        private static final Logger LOG;
        private String value;

        private PaymentInstrumentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentInstrumentEnum fromValue(String value) {
            for (PaymentInstrumentEnum b : PaymentInstrumentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PaymentInstrumentEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PaymentInstrumentEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PaymentInstrumentEnum.class.getName());
        }
    }

    public static enum AuthenticationMethodEnum {
        MAGSWIPE(String.valueOf("MAGSWIPE")),
        MKE(String.valueOf("MKE"));

        private static final Logger LOG;
        private String value;

        private AuthenticationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthenticationMethodEnum fromValue(String value) {
            for (AuthenticationMethodEnum b : AuthenticationMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("AuthenticationMethodEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])AuthenticationMethodEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(AuthenticationMethodEnum.class.getName());
        }
    }
}

